/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.AsValue;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.types.Entity;

public abstract class InternalEntity
implements Entity,
AsValue {
    private final long id;
    private final Map<String, Value> properties;

    public InternalEntity(long id, Map<String, Value> properties) {
        this.id = id;
        this.properties = properties;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public Map<String, Object> asMap() {
        return this.asMap(Values.ofObject());
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapFunction) {
        return Extract.map(this.properties, mapFunction);
    }

    @Override
    public Value asValue() {
        return new MapValue(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalEntity that = (InternalEntity)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "Entity{id=" + this.id + ", properties=" + this.properties + '}';
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public Iterable<String> keys() {
        return this.properties.keySet();
    }

    @Override
    public Value get(String key) {
        Value value2 = this.properties.get(key);
        return value2 == null ? Values.NULL : value2;
    }

    @Override
    public Iterable<Value> values() {
        return this.properties.values();
    }

    @Override
    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        return Iterables.map(this.properties.values(), mapFunction);
    }
}

