/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.io.IOException;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.connector.jdbc.xa.XidImpl;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class XidSerializer
extends TypeSerializer<Xid> {
    private static final long serialVersionUID = 1L;
    private static final TypeSerializerSnapshot<Xid> SNAPSHOT = new XidSimpleTypeSerializerSnapshot();

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<Xid> duplicate() {
        return this;
    }

    public Xid createInstance() {
        return new XidImpl(0, new byte[0], new byte[0]);
    }

    public Xid copy(Xid from) {
        return from;
    }

    public Xid copy(Xid from, Xid reuse) {
        return from;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Xid xid, DataOutputView target) throws IOException {
        target.writeInt(xid.getFormatId());
        this.writeBytesWithSize(target, xid.getGlobalTransactionId());
        this.writeBytesWithSize(target, xid.getBranchQualifier());
    }

    public Xid deserialize(DataInputView source) throws IOException {
        return new XidImpl(source.readInt(), this.readBytesWithSize(source), this.readBytesWithSize(source));
    }

    private void writeBytesWithSize(DataOutputView target, byte[] bytes) throws IOException {
        target.writeByte(bytes.length);
        target.write(bytes, 0, bytes.length);
    }

    private byte[] readBytesWithSize(DataInputView source) throws IOException {
        byte len = source.readByte();
        byte[] bytes = new byte[len];
        source.read(bytes, 0, (int)len);
        return bytes;
    }

    public Xid deserialize(Xid reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        return obj instanceof XidSerializer;
    }

    public int hashCode() {
        return XidSerializer.class.hashCode();
    }

    public TypeSerializerSnapshot<Xid> snapshotConfiguration() {
        return SNAPSHOT;
    }

    public static class XidSimpleTypeSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Xid> {
        private static final int VERSION = 1;

        public XidSimpleTypeSerializerSnapshot() {
            super(XidSerializer::new);
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            super.writeSnapshot(out);
            out.writeInt(1);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader classLoader) throws IOException {
            super.readSnapshot(readVersion, in, classLoader);
            in.readInt();
        }
    }
}

