/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.catalog.factory;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.connector.jdbc.catalog.JdbcCatalog;
import org.apache.flink.connector.jdbc.catalog.factory.JdbcCatalogFactoryOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCatalogFactory
implements CatalogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCatalogFactory.class);

    public String factoryIdentifier() {
        return "jdbc";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(JdbcCatalogFactoryOptions.DEFAULT_DATABASE);
        options.add(JdbcCatalogFactoryOptions.USERNAME);
        options.add(JdbcCatalogFactoryOptions.PASSWORD);
        options.add(JdbcCatalogFactoryOptions.BASE_URL);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FactoryUtil.PROPERTY_VERSION);
        return options;
    }

    public Catalog createCatalog(CatalogFactory.Context context) {
        FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)this, (CatalogFactory.Context)context);
        helper.validate();
        return new JdbcCatalog(context.getName(), (String)helper.getOptions().get(JdbcCatalogFactoryOptions.DEFAULT_DATABASE), (String)helper.getOptions().get(JdbcCatalogFactoryOptions.USERNAME), (String)helper.getOptions().get(JdbcCatalogFactoryOptions.PASSWORD), (String)helper.getOptions().get(JdbcCatalogFactoryOptions.BASE_URL));
    }
}

