/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.jdbc.input;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.seatunnel.flink.jdbc.input.TypeInformationMap;

public class OracleTypeInformationMap
implements TypeInformationMap {
    private static final Map<String, TypeInformation<?>> INFORMATION_MAP = new HashMap();

    @Override
    public TypeInformation<?> getInformation(String datatype) {
        return INFORMATION_MAP.get(datatype);
    }

    static {
        INFORMATION_MAP.put("NVARCHAR2", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("VARCHAR2", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("FLOAT", (TypeInformation<?>)BasicTypeInfo.DOUBLE_TYPE_INFO);
        INFORMATION_MAP.put("NUMBER", (TypeInformation<?>)BasicTypeInfo.BIG_DEC_TYPE_INFO);
        INFORMATION_MAP.put("LONG", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("DATE", (TypeInformation<?>)SqlTimeTypeInfo.TIMESTAMP);
        INFORMATION_MAP.put("RAW", (TypeInformation<?>)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO);
        INFORMATION_MAP.put("LONG RAW", (TypeInformation<?>)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO);
        INFORMATION_MAP.put("NCHAR", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("CHAR", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("BINARY_FLOAT", (TypeInformation<?>)BasicTypeInfo.FLOAT_TYPE_INFO);
        INFORMATION_MAP.put("BINARY_DOUBLE", (TypeInformation<?>)BasicTypeInfo.DOUBLE_TYPE_INFO);
        INFORMATION_MAP.put("ROWID", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("NCLOB", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("CLOB", (TypeInformation<?>)BasicTypeInfo.STRING_TYPE_INFO);
        INFORMATION_MAP.put("BLOB", (TypeInformation<?>)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO);
        INFORMATION_MAP.put("BFILE", (TypeInformation<?>)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO);
        INFORMATION_MAP.put("TIMESTAMP", (TypeInformation<?>)SqlTimeTypeInfo.TIMESTAMP);
        INFORMATION_MAP.put("TIMESTAMP WITH TIME ZONE", (TypeInformation<?>)SqlTimeTypeInfo.TIMESTAMP);
        INFORMATION_MAP.put("TIMESTAMP WITH LOCAL TIME ZONE", (TypeInformation<?>)SqlTimeTypeInfo.TIMESTAMP);
    }
}

