/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.assertion;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;
import org.apache.seatunnel.flink.assertion.rule.AssertFieldRule;

public class AssertExecutor {
    public Optional<AssertFieldRule> fail(Row row, List<AssertFieldRule> assertFieldRules) {
        return assertFieldRules.stream().filter(assertFieldRule -> !this.pass(row, (AssertFieldRule)assertFieldRule)).findFirst();
    }

    private boolean pass(Row row, AssertFieldRule assertFieldRule) {
        Object value = row.getField(assertFieldRule.getFieldName());
        if (Objects.isNull(value)) {
            return Boolean.FALSE;
        }
        Boolean typeChecked = this.checkType(value, assertFieldRule.getFieldType());
        if (Boolean.FALSE.equals(typeChecked)) {
            return Boolean.FALSE;
        }
        Boolean valueChecked = this.checkValue(value, assertFieldRule.getFieldValueRules());
        if (Boolean.FALSE.equals(valueChecked)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkValue(Object value, List<AssertFieldRule.AssertValueRule> fieldValueRules) {
        AssertFieldRule.AssertValueRule failValueRule;
        if (CollectionUtils.isNotEmpty(fieldValueRules) && Objects.nonNull(failValueRule = (AssertFieldRule.AssertValueRule)fieldValueRules.stream().filter(valueRule -> !this.pass(value, (AssertFieldRule.AssertValueRule)valueRule)).findFirst().orElse(null))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean pass(Object value, AssertFieldRule.AssertValueRule valueRule) {
        String valueStr;
        if (AssertFieldRule.AssertValueRuleType.NOT_NULL.equals((Object)valueRule.getFieldValueRuleType())) {
            return Objects.nonNull(value);
        }
        if (value instanceof Number && AssertFieldRule.AssertValueRuleType.MAX.equals((Object)valueRule.getFieldValueRuleType())) {
            return ((Number)value).doubleValue() <= valueRule.getFieldValueRuleValue();
        }
        if (value instanceof Number && AssertFieldRule.AssertValueRuleType.MIN.equals((Object)valueRule.getFieldValueRuleType())) {
            return ((Number)value).doubleValue() >= valueRule.getFieldValueRuleValue();
        }
        String string = valueStr = Objects.isNull(value) ? "" : String.valueOf(value);
        if (AssertFieldRule.AssertValueRuleType.MAX_LENGTH.equals((Object)valueRule.getFieldValueRuleType())) {
            return (double)valueStr.length() <= valueRule.getFieldValueRuleValue();
        }
        if (AssertFieldRule.AssertValueRuleType.MIN_LENGTH.equals((Object)valueRule.getFieldValueRuleType())) {
            return (double)valueStr.length() >= valueRule.getFieldValueRuleValue();
        }
        return Boolean.TRUE;
    }

    private Boolean checkType(Object value, TypeInformation<?> fieldType) {
        return value.getClass().equals(fieldType.getTypeClass());
    }
}

