/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.nio.Buffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.roaringbitmap.Util;

public final class BufferUtil {
    protected static boolean USE_HYBRID_BINSEARCH = false;

    public static void flipBitmapRange(LongBuffer bitmap, int start, int end) {
        if (BufferUtil.isBackedBySimpleArray(bitmap)) {
            Util.flipBitmapRange(bitmap.array(), start, end);
            return;
        }
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        bitmap.put(firstword, bitmap.get(firstword) ^ (-1L << start ^ 0xFFFFFFFFFFFFFFFFL));
        for (int i = firstword; i < endword; ++i) {
            bitmap.put(i, bitmap.get(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        bitmap.put(endword, bitmap.get(endword) ^ -1L >>> -end);
    }

    public static void resetBitmapRange(LongBuffer bitmap, int start, int end) {
        if (BufferUtil.isBackedBySimpleArray(bitmap)) {
            Util.resetBitmapRange(bitmap.array(), start, end);
            return;
        }
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            bitmap.put(firstword, bitmap.get(firstword) & (-1L << start & -1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL));
            return;
        }
        bitmap.put(firstword, bitmap.get(firstword) & (-1L << start ^ 0xFFFFFFFFFFFFFFFFL));
        for (int i = firstword + 1; i < endword; ++i) {
            bitmap.put(i, 0L);
        }
        bitmap.put(endword, bitmap.get(endword) & (-1L >>> -end ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static void setBitmapRange(LongBuffer bitmap, int start, int end) {
        if (BufferUtil.isBackedBySimpleArray(bitmap)) {
            Util.setBitmapRange(bitmap.array(), start, end);
            return;
        }
        if (start == end) {
            return;
        }
        int firstword = start / 64;
        int endword = (end - 1) / 64;
        if (firstword == endword) {
            bitmap.put(firstword, bitmap.get(firstword) | -1L << start & -1L >>> -end);
            return;
        }
        bitmap.put(firstword, bitmap.get(firstword) | -1L << start);
        for (int i = firstword + 1; i < endword; ++i) {
            bitmap.put(i, -1L);
        }
        bitmap.put(endword, bitmap.get(endword) | -1L >>> -end);
    }

    protected static int advanceUntil(ShortBuffer array, int pos, int length, short min2) {
        int upper;
        int lower = pos + 1;
        if (lower >= length || BufferUtil.toIntUnsigned(array.get(lower)) >= BufferUtil.toIntUnsigned(min2)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < length && BufferUtil.toIntUnsigned(array.get(lower + spansize)) < BufferUtil.toIntUnsigned(min2)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < length ? lower + spansize : length - 1;
        if (array.get(upper) == min2) {
            return upper;
        }
        if (BufferUtil.toIntUnsigned(array.get(upper)) < BufferUtil.toIntUnsigned(min2)) {
            return length;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            short arraymid = array.get(mid);
            if (arraymid == min2) {
                return mid;
            }
            if (BufferUtil.toIntUnsigned(arraymid) < BufferUtil.toIntUnsigned(min2)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    protected static void fillArrayAND(short[] container, LongBuffer bitmap1, LongBuffer bitmap2) {
        int pos = 0;
        if (bitmap1.limit() != bitmap2.limit()) {
            throw new IllegalArgumentException("not supported");
        }
        if (BufferUtil.isBackedBySimpleArray(bitmap1) && BufferUtil.isBackedBySimpleArray(bitmap2)) {
            int len = bitmap1.limit();
            long[] b1 = bitmap1.array();
            long[] b2 = bitmap2.array();
            for (int k = 0; k < len; ++k) {
                long t;
                for (long bitset = b1[k] & b2[k]; bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        } else {
            int len = bitmap1.limit();
            for (int k = 0; k < len; ++k) {
                long t;
                for (long bitset = bitmap1.get(k) & bitmap2.get(k); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        }
    }

    protected static void fillArrayANDNOT(short[] container, LongBuffer bitmap1, LongBuffer bitmap2) {
        int pos = 0;
        if (bitmap1.limit() != bitmap2.limit()) {
            throw new IllegalArgumentException("not supported");
        }
        if (BufferUtil.isBackedBySimpleArray(bitmap1) && BufferUtil.isBackedBySimpleArray(bitmap2)) {
            int len = bitmap1.limit();
            long[] b1 = bitmap1.array();
            long[] b2 = bitmap2.array();
            for (int k = 0; k < len; ++k) {
                long t;
                for (long bitset = b1[k] & (b2[k] ^ 0xFFFFFFFFFFFFFFFFL); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        } else {
            int len = bitmap1.limit();
            for (int k = 0; k < len; ++k) {
                long t;
                for (long bitset = bitmap1.get(k) & (bitmap2.get(k) ^ 0xFFFFFFFFFFFFFFFFL); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        }
    }

    protected static void fillArrayXOR(short[] container, LongBuffer bitmap1, LongBuffer bitmap2) {
        int pos = 0;
        if (bitmap1.limit() != bitmap2.limit()) {
            throw new IllegalArgumentException("not supported");
        }
        if (BufferUtil.isBackedBySimpleArray(bitmap1) && BufferUtil.isBackedBySimpleArray(bitmap2)) {
            int len = bitmap1.limit();
            long[] b1 = bitmap1.array();
            long[] b2 = bitmap2.array();
            for (int k = 0; k < len; ++k) {
                long t;
                for (long bitset = b1[k] ^ b2[k]; bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        } else {
            int len = bitmap1.limit();
            for (int k = 0; k < len; ++k) {
                long t;
                for (long bitset = bitmap1.get(k) ^ bitmap2.get(k); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    container[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                }
            }
        }
    }

    protected static int getSizeInBytesFromCardinalityEtc(int card, int numRuns, boolean isRunEncoded) {
        boolean isBitmap;
        if (isRunEncoded) {
            return 2 + numRuns * 2 * 2;
        }
        boolean bl = isBitmap = card > 4096;
        if (isBitmap) {
            return 8192;
        }
        return card * 2;
    }

    protected static boolean isBackedBySimpleArray(Buffer b) {
        return b.hasArray() && b.arrayOffset() == 0;
    }

    protected static short highbits(int x) {
        return (short)(x >>> 16);
    }

    protected static short lowbits(int x) {
        return (short)(x & 0xFFFF);
    }

    protected static short maxLowBit() {
        return -1;
    }

    protected static int maxLowBitAsInteger() {
        return 65535;
    }

    protected static void arraycopy(ShortBuffer src, int srcPos, ShortBuffer dest, int destPos, int length) {
        if (BufferUtil.isBackedBySimpleArray(src) && BufferUtil.isBackedBySimpleArray(dest)) {
            System.arraycopy(src.array(), srcPos, dest.array(), destPos, length);
        } else if (srcPos < destPos) {
            for (int k = length - 1; k >= 0; --k) {
                dest.put(destPos + k, src.get(k + srcPos));
            }
        } else {
            for (int k = 0; k < length; ++k) {
                dest.put(destPos + k, src.get(k + srcPos));
            }
        }
    }

    protected static int toIntUnsigned(short x) {
        return x & 0xFFFF;
    }

    public static int unsignedBinarySearch(ShortBuffer array, int begin, int end, short k) {
        if (USE_HYBRID_BINSEARCH) {
            return BufferUtil.hybridUnsignedBinarySearch(array, begin, end, k);
        }
        return BufferUtil.branchyUnsignedBinarySearch(array, begin, end, k);
    }

    protected static int hybridUnsignedBinarySearch(ShortBuffer array, int begin, int end, short k) {
        int x;
        int ikey = BufferUtil.toIntUnsigned(k);
        if (end > 0 && BufferUtil.toIntUnsigned(array.get(end - 1)) < ikey) {
            return -end - 1;
        }
        int low = begin;
        int high = end - 1;
        while (low + 32 <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = BufferUtil.toIntUnsigned(array.get(middleIndex));
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            int val = BufferUtil.toIntUnsigned(array.get(x));
            if (val < ikey) continue;
            if (val != ikey) break;
            return x;
        }
        return -(x + 1);
    }

    protected static int branchyUnsignedBinarySearch(ShortBuffer array, int begin, int end, short k) {
        int ikey = BufferUtil.toIntUnsigned(k);
        if (end > 0 && BufferUtil.toIntUnsigned(array.get(end - 1)) < ikey) {
            return -end - 1;
        }
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = BufferUtil.toIntUnsigned(array.get(middleIndex));
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    protected static int unsignedDifference(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        int pos = 0;
        int k1 = 0;
        int k2 = 0;
        if (0 == length2) {
            set1.get(buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            return 0;
        }
        short s1 = set1.get(k1);
        short s2 = set2.get(k2);
        while (true) {
            if (BufferUtil.toIntUnsigned(s1) < BufferUtil.toIntUnsigned(s2)) {
                buffer[pos++] = s1;
                if (++k1 >= length1) break;
                s1 = set1.get(k1);
                continue;
            }
            if (BufferUtil.toIntUnsigned(s1) == BufferUtil.toIntUnsigned(s2)) {
                ++k2;
                if (++k1 >= length1) break;
                if (k2 >= length2) {
                    set1.position(k1);
                    set1.get(buffer, pos, length1 - k1);
                    return pos + length1 - k1;
                }
                s1 = set1.get(k1);
                s2 = set2.get(k2);
                continue;
            }
            if (++k2 >= length2) {
                set1.position(k1);
                set1.get(buffer, pos, length1 - k1);
                return pos + length1 - k1;
            }
            s2 = set2.get(k2);
        }
        return pos;
    }

    protected static int unsignedExclusiveUnion2by2(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        int pos = 0;
        int k1 = 0;
        int k2 = 0;
        if (0 == length2) {
            set1.get(buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            set2.get(buffer, 0, length2);
            return length2;
        }
        short s1 = set1.get(k1);
        short s2 = set2.get(k2);
        while (true) {
            if (BufferUtil.toIntUnsigned(s1) < BufferUtil.toIntUnsigned(s2)) {
                buffer[pos++] = s1;
                if (++k1 >= length1) {
                    set2.position(k2);
                    set2.get(buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                s1 = set1.get(k1);
                continue;
            }
            if (BufferUtil.toIntUnsigned(s1) == BufferUtil.toIntUnsigned(s2)) {
                ++k2;
                if (++k1 >= length1) {
                    set2.position(k2);
                    set2.get(buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                if (k2 >= length2) {
                    set1.position(k1);
                    set1.get(buffer, pos, length1 - k1);
                    return pos + length1 - k1;
                }
                s1 = set1.get(k1);
                s2 = set2.get(k2);
                continue;
            }
            buffer[pos++] = s2;
            if (++k2 >= length2) {
                set1.position(k1);
                set1.get(buffer, pos, length1 - k1);
                return pos + length1 - k1;
            }
            s2 = set2.get(k2);
        }
    }

    protected static int unsignedIntersect2by2(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        if (length1 * 64 < length2) {
            return BufferUtil.unsignedOneSidedGallopingIntersect2by2(set1, length1, set2, length2, buffer);
        }
        if (length2 * 64 < length1) {
            return BufferUtil.unsignedOneSidedGallopingIntersect2by2(set2, length2, set1, length1, buffer);
        }
        return BufferUtil.unsignedLocalIntersect2by2(set1, length1, set2, length2, buffer);
    }

    protected static int unsignedOneSidedGallopingIntersect2by2(ShortBuffer smallSet, int smallLength, ShortBuffer largeSet, int largeLength, short[] buffer) {
        if (0 == smallLength) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        short s1 = largeSet.get(k1);
        short s2 = smallSet.get(k2);
        while (true) {
            if (BufferUtil.toIntUnsigned(s1) < BufferUtil.toIntUnsigned(s2)) {
                if ((k1 = BufferUtil.advanceUntil(largeSet, k1, largeLength, s2)) == largeLength) break;
                s1 = largeSet.get(k1);
            }
            if (BufferUtil.toIntUnsigned(s2) < BufferUtil.toIntUnsigned(s1)) {
                if (++k2 == smallLength) break;
                s2 = smallSet.get(k2);
                continue;
            }
            buffer[pos++] = s2;
            if (++k2 == smallLength || (k1 = BufferUtil.advanceUntil(largeSet, k1, largeLength, s2 = smallSet.get(k2))) == largeLength) break;
            s1 = largeSet.get(k1);
        }
        return pos;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int unsignedLocalIntersect2by2(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        if (0 == length1) return 0;
        if (0 == length2) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        short s1 = set1.get(k1);
        short s2 = set2.get(k2);
        while (true) {
            if (BufferUtil.toIntUnsigned(s2) < BufferUtil.toIntUnsigned(s1)) {
                do {
                    if (++k2 != length2) continue;
                    return pos;
                } while (BufferUtil.toIntUnsigned(s2 = set2.get(k2)) < BufferUtil.toIntUnsigned(s1));
            }
            if (BufferUtil.toIntUnsigned(s1) >= BufferUtil.toIntUnsigned(s2)) {
                buffer[pos++] = s1;
                if (++k1 == length1) {
                    return pos;
                }
                s1 = set1.get(k1);
                if (++k2 == length2) {
                    return pos;
                }
                s2 = set2.get(k2);
                continue;
            }
            do {
                if (++k1 != length1) continue;
                return pos;
            } while (BufferUtil.toIntUnsigned(s1 = set1.get(k1)) < BufferUtil.toIntUnsigned(s2));
        }
    }

    protected static int oldunsignedOneSidedGallopingIntersect2by2(ShortBuffer smallSet, int smallLength, ShortBuffer largeSet, int largeLength, short[] buffer) {
        if (0 == smallLength) {
            return 0;
        }
        int k1 = 0;
        int k2 = 0;
        int pos = 0;
        while (BufferUtil.toIntUnsigned(largeSet.get(k1)) >= BufferUtil.toIntUnsigned(smallSet.get(k2)) || (k1 = BufferUtil.advanceUntil(largeSet, k1, largeLength, smallSet.get(k2))) != largeLength) {
            if (BufferUtil.toIntUnsigned(smallSet.get(k2)) < BufferUtil.toIntUnsigned(largeSet.get(k1))) {
                if (++k2 != smallLength) continue;
                break;
            }
            buffer[pos++] = smallSet.get(k2);
            if (++k2 != smallLength && (k1 = BufferUtil.advanceUntil(largeSet, k1, largeLength, smallSet.get(k2))) != largeLength) continue;
            break;
        }
        return pos;
    }

    protected static int unsignedUnion2by2(ShortBuffer set1, int length1, ShortBuffer set2, int length2, short[] buffer) {
        int pos = 0;
        int k1 = 0;
        int k2 = 0;
        if (0 == length2) {
            set1.get(buffer, 0, length1);
            return length1;
        }
        if (0 == length1) {
            set2.get(buffer, 0, length2);
            return length2;
        }
        short s1 = set1.get(k1);
        short s2 = set2.get(k2);
        while (true) {
            int v2;
            int v1;
            if ((v1 = BufferUtil.toIntUnsigned(s1)) < (v2 = BufferUtil.toIntUnsigned(s2))) {
                buffer[pos++] = s1;
                if (++k1 >= length1) {
                    set2.position(k2);
                    set2.get(buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                s1 = set1.get(k1);
                continue;
            }
            if (v1 == v2) {
                buffer[pos++] = s1;
                ++k2;
                if (++k1 >= length1) {
                    set2.position(k2);
                    set2.get(buffer, pos, length2 - k2);
                    return pos + length2 - k2;
                }
                if (k2 >= length2) {
                    set1.position(k1);
                    set1.get(buffer, pos, length1 - k1);
                    return pos + length1 - k1;
                }
                s1 = set1.get(k1);
                s2 = set2.get(k2);
                continue;
            }
            buffer[pos++] = s2;
            if (++k2 >= length2) {
                set1.position(k1);
                set1.get(buffer, pos, length1 - k1);
                return pos + length1 - k1;
            }
            s2 = set2.get(k2);
        }
    }

    public static int compareUnsigned(short a, short b) {
        return BufferUtil.toIntUnsigned(a) - BufferUtil.toIntUnsigned(b);
    }

    private BufferUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean unsignedIntersects(ShortBuffer set1, int length1, ShortBuffer set2, int length2) {
        if (0 == length1) return false;
        if (0 == length2) {
            return false;
        }
        int k1 = 0;
        int k2 = 0;
        short s1 = set1.get(k1);
        short s2 = set2.get(k2);
        while (true) {
            if (BufferUtil.toIntUnsigned(s2) < BufferUtil.toIntUnsigned(s1)) {
                do {
                    if (++k2 != length2) continue;
                    return false;
                } while (BufferUtil.toIntUnsigned(s2 = set2.get(k2)) < BufferUtil.toIntUnsigned(s1));
            }
            if (BufferUtil.toIntUnsigned(s1) >= BufferUtil.toIntUnsigned(s2)) return true;
            do {
                if (++k1 != length1) continue;
                return false;
            } while (BufferUtil.toIntUnsigned(s1 = set1.get(k1)) < BufferUtil.toIntUnsigned(s2));
        }
    }
}

