/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class PruneColumns
extends TypeUtil.SchemaVisitor<Type> {
    private final Set<Integer> selected;
    private final boolean selectFullTypes;

    PruneColumns(Set<Integer> selected, boolean selectFullTypes) {
        Preconditions.checkNotNull(selected, "Selected field ids cannot be null");
        this.selected = selected;
        this.selectFullTypes = selectFullTypes;
    }

    @Override
    public Type schema(Schema schema, Type structResult) {
        return structResult;
    }

    @Override
    public Type struct(Types.StructType struct, List<Type> fieldResults) {
        List<Types.NestedField> fields = struct.fields();
        ArrayList<Types.NestedField> selectedFields = Lists.newArrayListWithExpectedSize(fields.size());
        boolean sameTypes = true;
        for (int i = 0; i < fieldResults.size(); ++i) {
            Types.NestedField field = fields.get(i);
            Type projectedType = fieldResults.get(i);
            if (field.type() == projectedType) {
                selectedFields.add(field);
                continue;
            }
            if (projectedType == null) continue;
            sameTypes = false;
            if (field.isOptional()) {
                selectedFields.add(Types.NestedField.optional(field.fieldId(), field.name(), projectedType, field.doc()));
                continue;
            }
            selectedFields.add(Types.NestedField.required(field.fieldId(), field.name(), projectedType, field.doc()));
        }
        if (!selectedFields.isEmpty()) {
            if (selectedFields.size() == fields.size() && sameTypes) {
                return struct;
            }
            return Types.StructType.of(selectedFields);
        }
        return null;
    }

    @Override
    public Type field(Types.NestedField field, Type fieldResult) {
        if (this.selected.contains(field.fieldId())) {
            if (this.selectFullTypes) {
                return field.type();
            }
            if (field.type().isStructType()) {
                return this.projectSelectedStruct(fieldResult);
            }
            Preconditions.checkArgument(!field.type().isNestedType(), "Cannot explicitly project List or Map types, %s:%s of type %s was selected", (Object)field.fieldId(), (Object)field.name(), (Object)field.type());
            return field.type();
        }
        if (fieldResult != null) {
            return fieldResult;
        }
        return null;
    }

    @Override
    public Type list(Types.ListType list, Type elementResult) {
        if (this.selected.contains(list.elementId())) {
            if (this.selectFullTypes) {
                return list;
            }
            if (list.elementType().isStructType()) {
                Types.StructType projectedStruct = this.projectSelectedStruct(elementResult);
                return this.projectList(list, projectedStruct);
            }
            Preconditions.checkArgument(list.elementType().isPrimitiveType(), "Cannot explicitly project List or Map types, List element %s of type %s was selected", list.elementId(), (Object)list.elementType());
            return list;
        }
        if (elementResult != null) {
            return this.projectList(list, elementResult);
        }
        return null;
    }

    @Override
    public Type map(Types.MapType map, Type ignored, Type valueResult) {
        if (this.selected.contains(map.valueId())) {
            if (this.selectFullTypes) {
                return map;
            }
            if (map.valueType().isStructType()) {
                Types.StructType projectedStruct = this.projectSelectedStruct(valueResult);
                return this.projectMap(map, projectedStruct);
            }
            Preconditions.checkArgument(map.valueType().isPrimitiveType(), "Cannot explicitly project List or Map types, Map value %s of type %s was selected", map.valueId(), (Object)map.valueType());
            return map;
        }
        if (valueResult != null) {
            return this.projectMap(map, valueResult);
        }
        if (this.selected.contains(map.keyId())) {
            return map;
        }
        return null;
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return null;
    }

    private Types.ListType projectList(Types.ListType list, Type elementResult) {
        Preconditions.checkArgument(elementResult != null, "Cannot project a list when the element result is null");
        if (list.elementType() == elementResult) {
            return list;
        }
        if (list.isElementOptional()) {
            return Types.ListType.ofOptional(list.elementId(), elementResult);
        }
        return Types.ListType.ofRequired(list.elementId(), elementResult);
    }

    private Types.MapType projectMap(Types.MapType map, Type valueResult) {
        Preconditions.checkArgument(valueResult != null, "Attempted to project a map without a defined map value type");
        if (map.valueType() == valueResult) {
            return map;
        }
        if (map.isValueOptional()) {
            return Types.MapType.ofOptional(map.keyId(), map.valueId(), map.keyType(), valueResult);
        }
        return Types.MapType.ofRequired(map.keyId(), map.valueId(), map.keyType(), valueResult);
    }

    private Types.StructType projectSelectedStruct(Type projectedField) {
        Preconditions.checkArgument(projectedField == null || projectedField.isStructType());
        if (projectedField == null) {
            return Types.StructType.of(new Types.NestedField[0]);
        }
        return projectedField.asStructType();
    }
}

