/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.UUID;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.iceberg.util.UUIDUtil;

public class UUIDConversion
extends Conversion<UUID> {
    @Override
    public Class<UUID> getConvertedType() {
        return UUID.class;
    }

    @Override
    public String getLogicalTypeName() {
        return LogicalTypes.uuid().getName();
    }

    @Override
    public UUID fromFixed(GenericFixed value, Schema schema, LogicalType type) {
        return UUIDUtil.convert(value.bytes());
    }

    @Override
    public GenericFixed toFixed(UUID value, Schema schema, LogicalType type) {
        return new GenericData.Fixed(schema, UUIDUtil.convert(value));
    }
}

