/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeleteFileIndex;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestFilterManager;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.ManifestMergeManager;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.events.CreateSnapshotEvent;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Predicate;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MergingSnapshotProducer<ThisT>
extends SnapshotProducer<ThisT> {
    private static final Logger LOG = LoggerFactory.getLogger(MergingSnapshotProducer.class);
    private static final Set<String> VALIDATE_ADDED_FILES_OPERATIONS = ImmutableSet.of("append", "overwrite");
    private static final Set<String> VALIDATE_DATA_FILES_EXIST_OPERATIONS = ImmutableSet.of("overwrite", "replace", "delete");
    private static final Set<String> VALIDATE_DATA_FILES_EXIST_SKIP_DELETE_OPERATIONS = ImmutableSet.of("overwrite", "replace");
    private static final Set<String> VALIDATE_ADDED_DELETE_FILES_OPERATIONS = ImmutableSet.of("overwrite", "delete");
    private final String tableName;
    private final TableOperations ops;
    private final SnapshotSummary.Builder summaryBuilder = SnapshotSummary.builder();
    private final ManifestMergeManager<DataFile> mergeManager;
    private final ManifestFilterManager<DataFile> filterManager;
    private final ManifestMergeManager<DeleteFile> deleteMergeManager;
    private final ManifestFilterManager<DeleteFile> deleteFilterManager;
    private final boolean snapshotIdInheritanceEnabled;
    private final List<DataFile> newFiles = Lists.newArrayList();
    private Long newFilesSequenceNumber;
    private final Map<Integer, List<DeleteFile>> newDeleteFilesBySpec = Maps.newHashMap();
    private final List<ManifestFile> appendManifests = Lists.newArrayList();
    private final List<ManifestFile> rewrittenAppendManifests = Lists.newArrayList();
    private final SnapshotSummary.Builder addedFilesSummary = SnapshotSummary.builder();
    private final SnapshotSummary.Builder appendedManifestsSummary = SnapshotSummary.builder();
    private Expression deleteExpression = Expressions.alwaysFalse();
    private PartitionSpec dataSpec;
    private ManifestFile cachedNewManifest = null;
    private boolean hasNewFiles = false;
    private final List<ManifestFile> cachedNewDeleteManifests = Lists.newLinkedList();
    private boolean hasNewDeleteFiles = false;
    private boolean caseSensitive = true;

    MergingSnapshotProducer(String tableName, TableOperations ops) {
        super(ops);
        this.tableName = tableName;
        this.ops = ops;
        this.dataSpec = null;
        long targetSizeBytes = ops.current().propertyAsLong("commit.manifest.target-size-bytes", 0x800000L);
        int minCountToMerge = ops.current().propertyAsInt("commit.manifest.min-count-to-merge", 100);
        boolean mergeEnabled = ops.current().propertyAsBoolean("commit.manifest-merge.enabled", true);
        this.mergeManager = new DataFileMergeManager(targetSizeBytes, minCountToMerge, mergeEnabled);
        this.filterManager = new DataFileFilterManager();
        this.deleteMergeManager = new DeleteFileMergeManager(targetSizeBytes, minCountToMerge, mergeEnabled);
        this.deleteFilterManager = new DeleteFileFilterManager();
        this.snapshotIdInheritanceEnabled = ops.current().propertyAsBoolean("compatibility.snapshot-id-inheritance.enabled", false);
    }

    @Override
    public ThisT set(String property, String value) {
        this.summaryBuilder.set(property, value);
        return this.self();
    }

    public ThisT caseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
        this.filterManager.caseSensitive(isCaseSensitive);
        this.deleteFilterManager.caseSensitive(isCaseSensitive);
        return this.self();
    }

    protected boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    protected PartitionSpec dataSpec() {
        Preconditions.checkState(this.dataSpec != null, "Cannot determine partition spec: no data files have been added");
        return this.dataSpec;
    }

    protected Expression rowFilter() {
        return this.deleteExpression;
    }

    protected List<DataFile> addedFiles() {
        return ImmutableList.copyOf(this.newFiles);
    }

    protected void failAnyDelete() {
        this.filterManager.failAnyDelete();
        this.deleteFilterManager.failAnyDelete();
    }

    protected void failMissingDeletePaths() {
        this.filterManager.failMissingDeletePaths();
        this.deleteFilterManager.failMissingDeletePaths();
    }

    protected void deleteByRowFilter(Expression expr) {
        this.deleteExpression = expr;
        this.filterManager.deleteByRowFilter(expr);
        this.deleteFilterManager.deleteByRowFilter(expr);
    }

    protected void dropPartition(int specId, StructLike partition) {
        this.filterManager.dropPartition(specId, partition);
        this.deleteFilterManager.dropPartition(specId, partition);
    }

    protected void delete(DataFile file) {
        this.filterManager.delete(file);
    }

    protected void delete(DeleteFile file) {
        this.deleteFilterManager.delete(file);
    }

    protected void delete(CharSequence path) {
        this.filterManager.delete(path);
    }

    protected void add(DataFile file) {
        Preconditions.checkNotNull(file, "Invalid data file: null");
        this.setDataSpec(file);
        this.addedFilesSummary.addedFile(this.dataSpec(), file);
        this.hasNewFiles = true;
        this.newFiles.add(file);
    }

    protected void add(DeleteFile file) {
        Preconditions.checkNotNull(file, "Invalid delete file: null");
        PartitionSpec fileSpec = this.ops.current().spec(file.specId());
        List deleteFiles = this.newDeleteFilesBySpec.computeIfAbsent(file.specId(), specId -> Lists.newArrayList());
        deleteFiles.add(file);
        this.addedFilesSummary.addedFile(fileSpec, file);
        this.hasNewDeleteFiles = true;
    }

    private void setDataSpec(DataFile file) {
        PartitionSpec fileSpec = this.ops.current().spec(file.specId());
        Preconditions.checkNotNull(fileSpec, "Cannot find partition spec for data file: %s", (Object)file.path());
        if (this.dataSpec == null) {
            this.dataSpec = fileSpec;
        } else if (this.dataSpec.specId() != file.specId()) {
            throw new ValidationException("Invalid data file, expected spec id: %d", this.dataSpec.specId());
        }
    }

    protected void add(ManifestFile manifest) {
        Preconditions.checkArgument(manifest.content() == ManifestContent.DATA, "Cannot append delete manifest: %s", (Object)manifest);
        if (this.snapshotIdInheritanceEnabled && manifest.snapshotId() == null) {
            this.appendedManifestsSummary.addedManifest(manifest);
            this.appendManifests.add(manifest);
        } else {
            ManifestFile copiedManifest = this.copyManifest(manifest);
            this.rewrittenAppendManifests.add(copiedManifest);
        }
    }

    private ManifestFile copyManifest(ManifestFile manifest) {
        TableMetadata current = this.ops.current();
        InputFile toCopy = this.ops.io().newInputFile(manifest.path());
        OutputFile newManifestPath = this.newManifestOutput();
        return ManifestFiles.copyAppendManifest(current.formatVersion(), toCopy, current.specsById(), newManifestPath, this.snapshotId(), this.appendedManifestsSummary);
    }

    protected void validateAddedDataFiles(TableMetadata base, Long startingSnapshotId, Expression conflictDetectionFilter) {
        if (base.currentSnapshot() == null) {
            return;
        }
        Pair<List<ManifestFile>, Set<Long>> history = this.validationHistory(base, startingSnapshotId, VALIDATE_ADDED_FILES_OPERATIONS, ManifestContent.DATA);
        List<ManifestFile> manifests = history.first();
        Set<Long> newSnapshots = history.second();
        ManifestGroup conflictGroup = new ManifestGroup(this.ops.io(), manifests, ImmutableList.of()).caseSensitive(this.caseSensitive).filterManifestEntries(entry -> newSnapshots.contains(entry.snapshotId())).filterData(conflictDetectionFilter).specsById(base.specsById()).ignoreDeleted().ignoreExisting();
        try (Iterator conflicts = conflictGroup.entries().iterator();){
            if (conflicts.hasNext()) {
                throw new ValidationException("Found conflicting files that can contain records matching %s: %s", conflictDetectionFilter, Iterators.toString(Iterators.transform(conflicts, entry -> ((DataFile)entry.file()).path().toString())));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to validate no appends matching %s", conflictDetectionFilter), e);
        }
    }

    protected void validateNoNewDeletesForDataFiles(TableMetadata base, Long startingSnapshotId, Iterable<DataFile> dataFiles) {
        this.validateNoNewDeletesForDataFiles(base, startingSnapshotId, null, dataFiles, this.newFilesSequenceNumber != null);
    }

    protected void validateNoNewDeletesForDataFiles(TableMetadata base, Long startingSnapshotId, Expression dataFilter, Iterable<DataFile> dataFiles) {
        this.validateNoNewDeletesForDataFiles(base, startingSnapshotId, dataFilter, dataFiles, false);
    }

    private void validateNoNewDeletesForDataFiles(TableMetadata base, Long startingSnapshotId, Expression dataFilter, Iterable<DataFile> dataFiles, boolean ignoreEqualityDeletes) {
        if (base.currentSnapshot() == null || base.formatVersion() < 2) {
            return;
        }
        Pair<List<ManifestFile>, Set<Long>> history = this.validationHistory(base, startingSnapshotId, VALIDATE_ADDED_DELETE_FILES_OPERATIONS, ManifestContent.DELETES);
        List<ManifestFile> deleteManifests = history.first();
        long startingSequenceNumber = this.startingSequenceNumber(base, startingSnapshotId);
        DeleteFileIndex deletes = this.buildDeleteFileIndex(deleteManifests, startingSequenceNumber, dataFilter);
        for (DataFile dataFile : dataFiles) {
            DeleteFile[] deleteFiles = deletes.forDataFile(startingSequenceNumber, dataFile);
            if (ignoreEqualityDeletes) {
                ValidationException.check(Arrays.stream(deleteFiles).noneMatch(deleteFile -> deleteFile.content() == FileContent.POSITION_DELETES), "Cannot commit, found new position delete for replaced data file: %s", dataFile);
                continue;
            }
            ValidationException.check(deleteFiles.length == 0, "Cannot commit, found new delete for replaced data file: %s", dataFile);
        }
    }

    protected void validateNoNewDeleteFiles(TableMetadata base, Long startingSnapshotId, Expression dataFilter) {
        if (base.currentSnapshot() == null || base.formatVersion() < 2) {
            return;
        }
        Pair<List<ManifestFile>, Set<Long>> history = this.validationHistory(base, startingSnapshotId, VALIDATE_ADDED_DELETE_FILES_OPERATIONS, ManifestContent.DELETES);
        List<ManifestFile> deleteManifests = history.first();
        long startingSequenceNumber = this.startingSequenceNumber(base, startingSnapshotId);
        DeleteFileIndex deletes = this.buildDeleteFileIndex(deleteManifests, startingSequenceNumber, dataFilter);
        ValidationException.check(deletes.isEmpty(), "Found new conflicting delete files that can apply to records matching %s: %s", dataFilter, Iterables.transform(deletes.referencedDeleteFiles(), ContentFile::path));
    }

    protected void setNewFilesSequenceNumber(long sequenceNumber) {
        this.newFilesSequenceNumber = sequenceNumber;
    }

    private long startingSequenceNumber(TableMetadata metadata, Long staringSnapshotId) {
        if (staringSnapshotId != null && metadata.snapshot(staringSnapshotId) != null) {
            Snapshot startingSnapshot = metadata.snapshot(staringSnapshotId);
            return startingSnapshot.sequenceNumber();
        }
        return 0L;
    }

    private DeleteFileIndex buildDeleteFileIndex(List<ManifestFile> deleteManifests, long startingSequenceNumber, Expression dataFilter) {
        DeleteFileIndex.Builder builder = DeleteFileIndex.builderFor(this.ops.io(), deleteManifests).afterSequenceNumber(startingSequenceNumber).caseSensitive(this.caseSensitive).specsById(this.ops.current().specsById());
        if (dataFilter != null) {
            builder.filterData(dataFilter);
        }
        return builder.build();
    }

    protected void validateDataFilesExist(TableMetadata base, Long startingSnapshotId, CharSequenceSet requiredDataFiles, boolean skipDeletes, Expression conflictDetectionFilter) {
        if (base.currentSnapshot() == null) {
            return;
        }
        Set<String> matchingOperations = skipDeletes ? VALIDATE_DATA_FILES_EXIST_SKIP_DELETE_OPERATIONS : VALIDATE_DATA_FILES_EXIST_OPERATIONS;
        Pair<List<ManifestFile>, Set<Long>> history = this.validationHistory(base, startingSnapshotId, matchingOperations, ManifestContent.DATA);
        List<ManifestFile> manifests = history.first();
        Set<Long> newSnapshots = history.second();
        ManifestGroup matchingDeletesGroup = new ManifestGroup(this.ops.io(), manifests, ImmutableList.of()).filterManifestEntries(entry -> entry.status() != ManifestEntry.Status.ADDED && newSnapshots.contains(entry.snapshotId()) && requiredDataFiles.contains(((DataFile)entry.file()).path())).specsById(base.specsById()).ignoreExisting();
        if (conflictDetectionFilter != null) {
            matchingDeletesGroup.filterData(conflictDetectionFilter);
        }
        try (Iterator deletes = matchingDeletesGroup.entries().iterator();){
            if (deletes.hasNext()) {
                throw new ValidationException("Cannot commit, missing data files: %s", Iterators.toString(Iterators.transform(deletes, entry -> ((DataFile)entry.file()).path().toString())));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to validate required files exist", e);
        }
    }

    private Pair<List<ManifestFile>, Set<Long>> validationHistory(TableMetadata base, Long startingSnapshotId, Set<String> matchingOperations, ManifestContent content) {
        ArrayList<ManifestFile> manifests = Lists.newArrayList();
        HashSet<Long> newSnapshots = Sets.newHashSet();
        Snapshot lastSnapshot = null;
        Iterable<Snapshot> snapshots = SnapshotUtil.ancestorsBetween(base.currentSnapshot().snapshotId(), startingSnapshotId, base::snapshot);
        Iterator<Snapshot> iterator = snapshots.iterator();
        while (iterator.hasNext()) {
            Snapshot currentSnapshot;
            lastSnapshot = currentSnapshot = iterator.next();
            if (!matchingOperations.contains(currentSnapshot.operation())) continue;
            newSnapshots.add(currentSnapshot.snapshotId());
            if (content == ManifestContent.DATA) {
                for (ManifestFile manifest : currentSnapshot.dataManifests()) {
                    if (manifest.snapshotId().longValue() != currentSnapshot.snapshotId()) continue;
                    manifests.add(manifest);
                }
                continue;
            }
            for (ManifestFile manifest : currentSnapshot.deleteManifests()) {
                if (manifest.snapshotId().longValue() != currentSnapshot.snapshotId()) continue;
                manifests.add(manifest);
            }
        }
        ValidationException.check(lastSnapshot == null || Objects.equals(lastSnapshot.parentId(), startingSnapshotId), "Cannot determine history between starting snapshot %s and the last known ancestor %s", startingSnapshotId, lastSnapshot != null ? Long.valueOf(lastSnapshot.snapshotId()) : null);
        return Pair.of(manifests, newSnapshots);
    }

    @Override
    protected Map<String, String> summary() {
        this.summaryBuilder.setPartitionSummaryLimit(this.ops.current().propertyAsInt("write.summary.partition-limit", 0));
        return this.summaryBuilder.build();
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base) {
        Snapshot current = base.currentSnapshot();
        List<ManifestFile> filtered = this.filterManager.filterManifests(base.schema(), current != null ? current.dataManifests() : null);
        long minDataSequenceNumber = filtered.stream().map(ManifestFile::minSequenceNumber).filter(seq -> seq > 0L).reduce(base.lastSequenceNumber(), Math::min);
        this.deleteFilterManager.dropDeleteFilesOlderThan(minDataSequenceNumber);
        List<ManifestFile> filteredDeletes = this.deleteFilterManager.filterManifests(base.schema(), current != null ? current.deleteManifests() : null);
        Predicate shouldKeep = manifest -> manifest.hasAddedFiles() || manifest.hasExistingFiles() || manifest.snapshotId().longValue() == this.snapshotId();
        Iterable<ManifestFile> unmergedManifests = Iterables.filter(Iterables.concat(this.prepareNewManifests(), filtered), shouldKeep);
        Iterable<ManifestFile> unmergedDeleteManifests = Iterables.filter(Iterables.concat(this.prepareDeleteManifests(), filteredDeletes), shouldKeep);
        this.summaryBuilder.clear();
        this.summaryBuilder.merge(this.addedFilesSummary);
        this.summaryBuilder.merge(this.appendedManifestsSummary);
        this.summaryBuilder.merge(this.filterManager.buildSummary(filtered));
        this.summaryBuilder.merge(this.deleteFilterManager.buildSummary(filteredDeletes));
        ArrayList<ManifestFile> manifests = Lists.newArrayList();
        Iterables.addAll(manifests, this.mergeManager.mergeManifests(unmergedManifests));
        Iterables.addAll(manifests, this.deleteMergeManager.mergeManifests(unmergedDeleteManifests));
        return manifests;
    }

    @Override
    public Object updateEvent() {
        Map<String, String> summary;
        long snapshotId = this.snapshotId();
        Snapshot justSaved = this.ops.refresh().snapshot(snapshotId);
        long sequenceNumber = -1L;
        if (justSaved == null) {
            LOG.warn("Failed to load committed snapshot: omitting sequence number from notifications");
            summary = this.summary();
        } else {
            sequenceNumber = justSaved.sequenceNumber();
            summary = justSaved.summary();
        }
        return new CreateSnapshotEvent(this.tableName, this.operation(), snapshotId, sequenceNumber, summary);
    }

    private void cleanUncommittedAppends(Set<ManifestFile> committed) {
        if (this.cachedNewManifest != null && !committed.contains(this.cachedNewManifest)) {
            this.deleteFile(this.cachedNewManifest.path());
            this.cachedNewManifest = null;
        }
        ListIterator<ManifestFile> deleteManifestsIterator = this.cachedNewDeleteManifests.listIterator();
        while (deleteManifestsIterator.hasNext()) {
            ManifestFile deleteManifest = deleteManifestsIterator.next();
            if (committed.contains(deleteManifest)) continue;
            this.deleteFile(deleteManifest.path());
            deleteManifestsIterator.remove();
        }
        for (ManifestFile manifest : this.rewrittenAppendManifests) {
            if (committed.contains(manifest)) continue;
            this.deleteFile(manifest.path());
        }
        if (!committed.isEmpty()) {
            for (ManifestFile manifest : this.appendManifests) {
                if (committed.contains(manifest)) continue;
                this.deleteFile(manifest.path());
            }
        }
    }

    @Override
    protected void cleanUncommitted(Set<ManifestFile> committed) {
        this.mergeManager.cleanUncommitted(committed);
        this.filterManager.cleanUncommitted(committed);
        this.deleteMergeManager.cleanUncommitted(committed);
        this.deleteFilterManager.cleanUncommitted(committed);
        this.cleanUncommittedAppends(committed);
    }

    private Iterable<ManifestFile> prepareNewManifests() {
        Iterable<ManifestFile> newManifests;
        if (this.newFiles.size() > 0) {
            ManifestFile newManifest = this.newFilesAsManifest();
            newManifests = Iterables.concat(ImmutableList.of(newManifest), this.appendManifests, this.rewrittenAppendManifests);
        } else {
            newManifests = Iterables.concat(this.appendManifests, this.rewrittenAppendManifests);
        }
        return Iterables.transform(newManifests, manifest -> GenericManifestFile.copyOf(manifest).withSnapshotId(this.snapshotId()).build());
    }

    private ManifestFile newFilesAsManifest() {
        if (this.hasNewFiles && this.cachedNewManifest != null) {
            this.deleteFile(this.cachedNewManifest.path());
            this.cachedNewManifest = null;
        }
        if (this.cachedNewManifest == null) {
            try {
                try (ManifestWriter<DataFile> writer = this.newManifestWriter(this.dataSpec());){
                    if (this.newFilesSequenceNumber == null) {
                        writer.addAll(this.newFiles);
                    } else {
                        this.newFiles.forEach(f -> writer.add((DataFile)f, this.newFilesSequenceNumber));
                    }
                }
                this.cachedNewManifest = writer.toManifestFile();
                this.hasNewFiles = false;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest writer", new Object[0]);
            }
        }
        return this.cachedNewManifest;
    }

    private Iterable<ManifestFile> prepareDeleteManifests() {
        if (this.newDeleteFilesBySpec.isEmpty()) {
            return ImmutableList.of();
        }
        return this.newDeleteFilesAsManifests();
    }

    private List<ManifestFile> newDeleteFilesAsManifests() {
        if (this.hasNewDeleteFiles && this.cachedNewDeleteManifests.size() > 0) {
            for (ManifestFile cachedNewDeleteManifest : this.cachedNewDeleteManifests) {
                this.deleteFile(cachedNewDeleteManifest.path());
            }
            this.cachedNewDeleteManifests.clear();
        }
        if (this.cachedNewDeleteManifests.isEmpty()) {
            this.newDeleteFilesBySpec.forEach((specId, deleteFiles) -> {
                PartitionSpec spec = this.ops.current().spec((int)specId);
                try {
                    try (ManifestWriter<DeleteFile> writer = this.newDeleteManifestWriter(spec);){
                        writer.addAll(deleteFiles);
                    }
                    this.cachedNewDeleteManifests.add(writer.toManifestFile());
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to close manifest writer", new Object[0]);
                }
            });
            this.hasNewDeleteFiles = false;
        }
        return this.cachedNewDeleteManifests;
    }

    private class DeleteFileMergeManager
    extends ManifestMergeManager<DeleteFile> {
        DeleteFileMergeManager(long targetSizeBytes, int minCountToMerge, boolean mergeEnabled) {
            super(targetSizeBytes, minCountToMerge, mergeEnabled);
        }

        @Override
        protected long snapshotId() {
            return MergingSnapshotProducer.this.snapshotId();
        }

        @Override
        protected PartitionSpec spec(int specId) {
            return MergingSnapshotProducer.this.ops.current().spec(specId);
        }

        @Override
        protected void deleteFile(String location) {
            MergingSnapshotProducer.this.deleteFile(location);
        }

        @Override
        protected ManifestWriter<DeleteFile> newManifestWriter(PartitionSpec manifestSpec) {
            return MergingSnapshotProducer.this.newDeleteManifestWriter(manifestSpec);
        }

        @Override
        protected ManifestReader<DeleteFile> newManifestReader(ManifestFile manifest) {
            return MergingSnapshotProducer.this.newDeleteManifestReader(manifest);
        }
    }

    private class DeleteFileFilterManager
    extends ManifestFilterManager<DeleteFile> {
        private DeleteFileFilterManager() {
            super(MergingSnapshotProducer.this.ops.current().specsById());
        }

        @Override
        protected void deleteFile(String location) {
            MergingSnapshotProducer.this.deleteFile(location);
        }

        @Override
        protected ManifestWriter<DeleteFile> newManifestWriter(PartitionSpec manifestSpec) {
            return MergingSnapshotProducer.this.newDeleteManifestWriter(manifestSpec);
        }

        @Override
        protected ManifestReader<DeleteFile> newManifestReader(ManifestFile manifest) {
            return MergingSnapshotProducer.this.newDeleteManifestReader(manifest);
        }
    }

    private class DataFileMergeManager
    extends ManifestMergeManager<DataFile> {
        DataFileMergeManager(long targetSizeBytes, int minCountToMerge, boolean mergeEnabled) {
            super(targetSizeBytes, minCountToMerge, mergeEnabled);
        }

        @Override
        protected long snapshotId() {
            return MergingSnapshotProducer.this.snapshotId();
        }

        @Override
        protected PartitionSpec spec(int specId) {
            return MergingSnapshotProducer.this.ops.current().spec(specId);
        }

        @Override
        protected void deleteFile(String location) {
            MergingSnapshotProducer.this.deleteFile(location);
        }

        @Override
        protected ManifestWriter<DataFile> newManifestWriter(PartitionSpec manifestSpec) {
            return MergingSnapshotProducer.this.newManifestWriter(manifestSpec);
        }

        @Override
        protected ManifestReader<DataFile> newManifestReader(ManifestFile manifest) {
            return MergingSnapshotProducer.this.newManifestReader(manifest);
        }
    }

    private class DataFileFilterManager
    extends ManifestFilterManager<DataFile> {
        private DataFileFilterManager() {
            super(MergingSnapshotProducer.this.ops.current().specsById());
        }

        @Override
        protected void deleteFile(String location) {
            MergingSnapshotProducer.this.deleteFile(location);
        }

        @Override
        protected ManifestWriter<DataFile> newManifestWriter(PartitionSpec manifestSpec) {
            return MergingSnapshotProducer.this.newManifestWriter(manifestSpec);
        }

        @Override
        protected ManifestReader<DataFile> newManifestReader(ManifestFile manifest) {
            return MergingSnapshotProducer.this.newManifestReader(manifest);
        }
    }
}

