/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseMetadataTableScan;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericManifestEntry;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

public class ManifestEntriesTable
extends BaseMetadataTable {
    ManifestEntriesTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".entries");
    }

    ManifestEntriesTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    @Override
    public TableScan newScan() {
        return new EntriesTableScan(this.operations(), this.table(), this.schema());
    }

    @Override
    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = ManifestEntry.getSchema(partitionType);
        if (partitionType.fields().size() < 1) {
            return TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return schema;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ENTRIES;
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final Schema schema;
        private final Schema fileSchema;
        private final FileIO io;
        private final ManifestFile manifest;
        private final Map<Integer, PartitionSpec> specsById;

        ManifestReadTask(FileIO io, ManifestFile manifest, Schema schema, String schemaString, String specString, ResidualEvaluator residuals, Map<Integer, PartitionSpec> specsById) {
            super(DataFiles.fromManifest(manifest), null, schemaString, specString, residuals);
            this.schema = schema;
            this.io = io;
            this.manifest = manifest;
            this.specsById = specsById;
            Type fileProjection = schema.findType("data_file");
            this.fileSchema = fileProjection != null ? new Schema(fileProjection.asStructType().fields()) : new Schema(new Types.NestedField[0]);
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            CloseableIterable<StructLike> prunedRows = this.manifest.content() == ManifestContent.DATA ? CloseableIterable.transform(ManifestFiles.read(this.manifest, this.io).project(this.fileSchema).entries(), file -> (GenericManifestEntry)file) : CloseableIterable.transform(ManifestFiles.readDeleteManifest(this.manifest, this.io, this.specsById).project(this.fileSchema).entries(), file -> (GenericManifestEntry)file);
            Schema readSchema = ManifestEntry.wrapFileSchema(this.fileSchema.asStruct());
            StructProjection projection = StructProjection.create(readSchema, this.schema);
            return CloseableIterable.transform(prunedRows, projection::wrap);
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }
    }

    private static class EntriesTableScan
    extends BaseMetadataTableScan {
        EntriesTableScan(TableOperations ops, Table table, Schema schema) {
            super(ops, table, schema);
        }

        private EntriesTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, context);
        }

        @Override
        public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
            throw new UnsupportedOperationException(String.format("Cannot incrementally scan table of type %s", MetadataTableType.ENTRIES.name()));
        }

        @Override
        public TableScan appendsAfter(long fromSnapshotId) {
            throw new UnsupportedOperationException(String.format("Cannot incrementally scan table of type %s", MetadataTableType.ENTRIES.name()));
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new EntriesTableScan(ops, table, schema, context);
        }

        @Override
        protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats) {
            CloseableIterable<ManifestFile> manifests = CloseableIterable.withNoopClose(snapshot.allManifests());
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
            ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
            return CloseableIterable.transform(manifests, manifest -> new ManifestReadTask(ops.io(), (ManifestFile)manifest, this.schema(), schemaString, specString, residuals, ops.current().specsById()));
        }
    }
}

