/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.fake.source;

import com.github.jsonzou.jmockdata.JMockData;
import com.github.jsonzou.jmockdata.MockConfig;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;

public class MockSchema
implements Serializable {
    private static final long serialVersionUID = -7018198671355055858L;
    private static final int STATIC_RANGE_SIZE = 2;
    private static final int STATIC_RANGE_MIN_INDEX = 0;
    private static final int STATIC_RANGE_MAX_INDEX = 1;
    private static final int TIME_RANGE_SIZE = 6;
    private static final int TIME_RANGE_HOUR_MIN_INDEX = 0;
    private static final int TIME_RANGE_HOUR_MAX_INDEX = 1;
    private static final int TIME_RANGE_MINUTE_MIN_INDEX = 2;
    private static final int TIME_RANGE_MINUTE_MAX_INDEX = 3;
    private static final int TIME_RANGE_SECOND_MIN_INDEX = 4;
    private static final int TIME_RANGE_SECOND_MAX_INDEX = 5;
    private String name;
    private String type;
    private Config mockConfig;
    private static final String[] NAME_SEEDS = new String[]{"Gary", "Ricky Huo", "Kid Xiong"};
    private static final Integer[] NAME_SIZE_RANGE = new Integer[]{1, 1};
    private static final Integer[] AGE_RANGE = new Integer[]{1, 100};
    public static List<MockSchema> DEFAULT_MOCK_SCHEMAS = new ArrayList<MockSchema>(0);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Config getMockConfig() {
        return this.mockConfig;
    }

    public void setMockConfig(Config mockConfig) {
        this.mockConfig = mockConfig;
    }

    public TypeInformation<?> typeInformation() {
        BasicTypeInfo dataType;
        switch (this.type.trim().toLowerCase()) {
            case "int": 
            case "integer": {
                dataType = BasicTypeInfo.INT_TYPE_INFO;
                break;
            }
            case "byte": {
                dataType = BasicTypeInfo.BYTE_TYPE_INFO;
                break;
            }
            case "boolean": {
                dataType = BasicTypeInfo.BOOLEAN_TYPE_INFO;
                break;
            }
            case "char": 
            case "character": {
                dataType = BasicTypeInfo.CHAR_TYPE_INFO;
                break;
            }
            case "short": {
                dataType = BasicTypeInfo.SHORT_TYPE_INFO;
                break;
            }
            case "long": 
            case "bigint": {
                dataType = BasicTypeInfo.LONG_TYPE_INFO;
                break;
            }
            case "float": {
                dataType = BasicTypeInfo.FLOAT_TYPE_INFO;
                break;
            }
            case "double": {
                dataType = BasicTypeInfo.DOUBLE_TYPE_INFO;
                break;
            }
            case "date": {
                dataType = BasicTypeInfo.DATE_TYPE_INFO;
                break;
            }
            case "timestamp": {
                dataType = SqlTimeTypeInfo.TIMESTAMP;
                break;
            }
            case "decimal": 
            case "bigdecimal": {
                dataType = BasicTypeInfo.BIG_DEC_TYPE_INFO;
                break;
            }
            case "int[]": {
                dataType = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                break;
            }
            case "byte[]": {
                dataType = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
                break;
            }
            case "boolean[]": {
                dataType = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
                break;
            }
            case "char[]": 
            case "character[]": {
                dataType = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                break;
            }
            case "short[]": {
                dataType = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                break;
            }
            case "long[]": {
                dataType = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                break;
            }
            case "float[]": {
                dataType = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                break;
            }
            case "double[]": {
                dataType = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                break;
            }
            case "string[]": {
                dataType = BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO;
                break;
            }
            case "binary": {
                dataType = GenericTypeInfo.of(ByteArrayInputStream.class);
                break;
            }
            default: {
                dataType = BasicTypeInfo.STRING_TYPE_INFO;
            }
        }
        return dataType;
    }

    public Object mockData() {
        Object mockData;
        MockConfig mockConfig = new MockConfig();
        this.resolve(mockConfig);
        switch (this.type.trim().toLowerCase()) {
            case "int": 
            case "integer": {
                mockData = JMockData.mock(Integer.TYPE, mockConfig);
                break;
            }
            case "byte": {
                mockData = JMockData.mock(Byte.TYPE, mockConfig);
                break;
            }
            case "boolean": {
                mockData = JMockData.mock(Boolean.TYPE, mockConfig);
                break;
            }
            case "char": 
            case "character": {
                mockData = JMockData.mock(Character.TYPE, mockConfig);
                break;
            }
            case "short": {
                mockData = JMockData.mock(Short.TYPE, mockConfig);
                break;
            }
            case "long": 
            case "bigint": {
                mockData = JMockData.mock(Long.TYPE, mockConfig);
                break;
            }
            case "float": {
                mockData = JMockData.mock(Float.TYPE, mockConfig);
                break;
            }
            case "double": {
                mockData = JMockData.mock(Double.TYPE, mockConfig);
                break;
            }
            case "date": {
                mockData = JMockData.mock(Date.class, mockConfig);
                break;
            }
            case "timestamp": {
                mockData = JMockData.mock(Timestamp.class, mockConfig);
                break;
            }
            case "decimal": 
            case "bigdecimal": {
                mockData = JMockData.mock(BigDecimal.class, mockConfig);
                break;
            }
            case "int[]": {
                mockData = JMockData.mock(int[].class, mockConfig);
                break;
            }
            case "byte[]": {
                mockData = JMockData.mock(byte[].class, mockConfig);
                break;
            }
            case "boolean[]": {
                mockData = JMockData.mock(boolean[].class, mockConfig);
                break;
            }
            case "char[]": 
            case "character[]": {
                mockData = JMockData.mock(char[].class, mockConfig);
                break;
            }
            case "short[]": {
                mockData = JMockData.mock(short[].class, mockConfig);
                break;
            }
            case "long[]": {
                mockData = JMockData.mock(long[].class, mockConfig);
                break;
            }
            case "float[]": {
                mockData = JMockData.mock(float[].class, mockConfig);
                break;
            }
            case "double[]": {
                mockData = JMockData.mock(double[].class, mockConfig);
                break;
            }
            case "string[]": {
                mockData = JMockData.mock(String[].class, mockConfig);
                break;
            }
            case "binary": {
                byte[] bytes = JMockData.mock(byte[].class, mockConfig);
                mockData = new ByteArrayInputStream(bytes);
                break;
            }
            default: {
                mockData = JMockData.mock(String.class, mockConfig);
            }
        }
        return mockData;
    }

    private void resolve(MockConfig mockConfig) {
        if (this.mockConfig != null) {
            this.byteConfigResolve(mockConfig);
            this.booleanConfigResolve(mockConfig);
            this.charConfigResolve(mockConfig);
            this.dateConfigResolve(mockConfig);
            this.decimalConfigResolve(mockConfig);
            this.doubleConfigResolve(mockConfig);
            this.floatConfigResolve(mockConfig);
            this.intConfigResolve(mockConfig);
            this.longConfigResolve(mockConfig);
            this.numberConfigResolve(mockConfig);
            this.sizeConfigResolve(mockConfig);
            this.stringConfigResolve(mockConfig);
            this.timeConfigResolve(mockConfig);
        }
    }

    private void byteConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("byte_range")) {
            List byteRange = this.mockConfig.getBytesList("byte_range");
            assert (byteRange.size() >= 2);
            mockConfig.byteRange(((Long)byteRange.get(0)).byteValue(), ((Long)byteRange.get(1)).byteValue());
        }
    }

    private void booleanConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("boolean_seed")) {
            List booleanSeedList = this.mockConfig.getBooleanList("boolean_seed");
            boolean[] booleanSeed = new boolean[booleanSeedList.size()];
            for (int index = 0; index < booleanSeedList.size(); ++index) {
                booleanSeed[index] = (Boolean)booleanSeedList.get(index);
            }
            mockConfig.booleanSeed(booleanSeed);
        }
    }

    private void charConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("char_seed")) {
            String charSeedString = this.mockConfig.getString("char_seed");
            byte[] bytes = charSeedString.getBytes(StandardCharsets.UTF_8);
            char[] charSeed = new char[bytes.length];
            for (int index = 0; index < bytes.length; ++index) {
                charSeed[index] = (char)bytes[index];
            }
            mockConfig.charSeed(charSeed);
        }
    }

    private void dateConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("date_range")) {
            List dateRange = this.mockConfig.getStringList("date_range");
            assert (dateRange.size() >= 2);
            mockConfig.dateRange((String)dateRange.get(0), (String)dateRange.get(1));
        }
    }

    private void decimalConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("decimal_scale")) {
            int scala = this.mockConfig.getInt("decimal_scale");
            mockConfig.decimalScale(scala);
        }
    }

    private void doubleConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("double_range")) {
            List doubleRange = this.mockConfig.getDoubleList("double_range");
            assert (doubleRange.size() >= 2);
            mockConfig.doubleRange((Double)doubleRange.get(0), (Double)doubleRange.get(1));
        }
    }

    private void floatConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("float_range")) {
            List floatRange = this.mockConfig.getDoubleList("float_range");
            assert (floatRange.size() >= 2);
            mockConfig.floatRange(((Double)floatRange.get(0)).floatValue(), ((Double)floatRange.get(1)).floatValue());
        }
    }

    private void intConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("int_range")) {
            List intRange = this.mockConfig.getIntList("int_range");
            assert (intRange.size() >= 2);
            mockConfig.intRange((Integer)intRange.get(0), (Integer)intRange.get(1));
        }
    }

    private void longConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("long_range")) {
            List longRange = this.mockConfig.getLongList("long_range");
            assert (longRange.size() >= 2);
            mockConfig.longRange((Long)longRange.get(0), (Long)longRange.get(1));
        }
    }

    private void numberConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("number_regex")) {
            String numberRegex = this.mockConfig.getString("number_regex");
            mockConfig.numberRegex(numberRegex);
        }
    }

    private void sizeConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("size_range")) {
            List sizeRange = this.mockConfig.getIntList("size_range");
            assert (sizeRange.size() >= 2);
            mockConfig.sizeRange((Integer)sizeRange.get(0), (Integer)sizeRange.get(1));
        }
    }

    private void stringConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("string_regex")) {
            String stringRegex = this.mockConfig.getString("string_regex");
            mockConfig.stringRegex(stringRegex);
        }
        if (this.mockConfig.hasPath("string_seed")) {
            List stringSeed = this.mockConfig.getStringList("string_seed");
            mockConfig.stringSeed(stringSeed.toArray(new String[0]));
        }
    }

    private void timeConfigResolve(MockConfig mockConfig) {
        if (this.mockConfig.hasPath("time_range")) {
            List timeRange = this.mockConfig.getIntList("time_range");
            assert (timeRange.size() >= 6);
            mockConfig.timeRange((Integer)timeRange.get(0), (Integer)timeRange.get(1), (Integer)timeRange.get(2), (Integer)timeRange.get(3), (Integer)timeRange.get(4), (Integer)timeRange.get(5));
        }
    }

    public static RowTypeInfo mockRowTypeInfo(List<MockSchema> mockDataSchema) {
        TypeInformation[] types = new TypeInformation[mockDataSchema.size()];
        String[] fieldNames = new String[mockDataSchema.size()];
        for (int index = 0; index < mockDataSchema.size(); ++index) {
            MockSchema schema = mockDataSchema.get(index);
            types[index] = schema.typeInformation();
            fieldNames[index] = schema.getName();
        }
        return new RowTypeInfo(types, fieldNames);
    }

    public static Row mockRowData(List<MockSchema> mockDataSchema) {
        Object[] fieldByPosition = new Object[mockDataSchema.size()];
        for (int index = 0; index < mockDataSchema.size(); ++index) {
            Object colData;
            MockSchema schema = mockDataSchema.get(index);
            fieldByPosition[index] = colData = schema.mockData();
        }
        return Row.of((Object[])fieldByPosition);
    }

    public static List<MockSchema> resolveConfig(Config config) {
        if (config.hasPath("mock_data_schema")) {
            return config.getConfigList("mock_data_schema").stream().map(schemaConfig -> {
                MockSchema schema = new MockSchema();
                schema.setName(schemaConfig.getString("name"));
                schema.setType(schemaConfig.getString("type"));
                if (schemaConfig.hasPath("mock_config")) {
                    schema.setMockConfig(schemaConfig.getConfig("mock_config"));
                }
                return schema;
            }).collect(Collectors.toList());
        }
        return DEFAULT_MOCK_SCHEMAS;
    }

    static {
        MockSchema nameSchema = new MockSchema();
        nameSchema.setName("name");
        nameSchema.setType("string");
        HashMap<String, List<Object>> nameSchemaConfigMap = new HashMap<String, List<Object>>(0);
        nameSchemaConfigMap.put("string_seed", Arrays.asList(NAME_SEEDS));
        nameSchemaConfigMap.put("size_range", Arrays.asList(NAME_SIZE_RANGE));
        nameSchema.setMockConfig(ConfigFactory.parseMap(nameSchemaConfigMap));
        DEFAULT_MOCK_SCHEMAS.add(nameSchema);
        MockSchema ageSchema = new MockSchema();
        ageSchema.setName("age");
        ageSchema.setType("int");
        HashMap<String, List<Integer>> ageSchemaConfigMap = new HashMap<String, List<Integer>>(0);
        ageSchemaConfigMap.put("int_range", Arrays.asList(AGE_RANGE));
        ageSchema.setMockConfig(ConfigFactory.parseMap(ageSchemaConfigMap));
        DEFAULT_MOCK_SCHEMAS.add(ageSchema);
    }
}

