/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.mocker;

import com.github.jsonzou.jmockdata.BeanMockerInterceptor;
import com.github.jsonzou.jmockdata.DataConfig;
import com.github.jsonzou.jmockdata.InterceptType;
import com.github.jsonzou.jmockdata.MockException;
import com.github.jsonzou.jmockdata.Mocker;
import com.github.jsonzou.jmockdata.annotation.MockIgnore;
import com.github.jsonzou.jmockdata.mocker.BaseMocker;
import com.github.jsonzou.jmockdata.util.ReflectionUtils;
import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanMocker
implements Mocker<Object> {
    private Map<Class<?>, List<Field>> classFieldCache = new ConcurrentHashMap(43);
    private final Class clazz;

    BeanMocker(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    public Object mock(DataConfig mockConfig) {
        try {
            Object cacheBean;
            if (mockConfig.globalConfig().isEnabledCircle() && (cacheBean = mockConfig.globalConfig().getcacheBean(this.clazz.getName())) != null) {
                return cacheBean;
            }
            Object result = this.clazz.newInstance();
            mockConfig.globalConfig().cacheBean(this.clazz.getName(), result);
            if (mockConfig.globalConfig().isConfigExcludeMock(this.clazz)) {
                return result;
            }
            this.setFieldValueByFieldAccessible(mockConfig, result);
            return result;
        }
        catch (Exception e) {
            throw new MockException(e);
        }
    }

    private void setFieldValueByFieldAccessible(DataConfig mockConfig, Object result) throws IllegalAccessException {
        Class currentClass = this.clazz;
        while (this.isSupportMock(currentClass)) {
            for (Field field : this.getMockFields(currentClass, mockConfig)) {
                DataConfig fieldDataMockConfig = mockConfig.globalConfig().getDataConfig(currentClass, field.getName());
                Object value = null;
                BeanMockerInterceptor bi = mockConfig.globalConfig().getBeanMockerInterceptor(this.clazz);
                boolean unset = false;
                if (bi == null) {
                    value = new BaseMocker(field.getGenericType(), new Type[0]).mock(fieldDataMockConfig);
                } else {
                    Object fieldValue = bi.mock(this.clazz, field, result, fieldDataMockConfig);
                    if (fieldValue == null) {
                        unset = true;
                    } else if (fieldValue instanceof InterceptType) {
                        InterceptType interceptType = (InterceptType)((Object)fieldValue);
                        if (InterceptType.MOCK == interceptType) {
                            value = new BaseMocker(field.getGenericType(), new Type[0]).mock(fieldDataMockConfig);
                            unset = false;
                        } else if (InterceptType.UNMOCK == interceptType) {
                            unset = true;
                        }
                    } else {
                        value = fieldValue;
                        unset = false;
                    }
                }
                if (unset) continue;
                ReflectionUtils.setFieldValue(result, field, value);
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    public List<Field> getMockFields(Class<?> clazz, DataConfig mockConfig) {
        List<Field> fields = this.classFieldCache.get(clazz);
        if (fields == null) {
            Field[] dfields = clazz.getDeclaredFields();
            int size = 5 + dfields.length + dfields.length / 10;
            fields = new ArrayList<Field>(size);
            for (Field field : dfields) {
                if (!this.isSupportMock(mockConfig, field)) continue;
                field.setAccessible(true);
                fields.add(field);
            }
            this.classFieldCache.put(clazz, fields);
        }
        return fields;
    }

    private boolean isSupportMock(Class<?> clazz) {
        boolean unSupport = clazz == Object.class || clazz.isInterface() || clazz.isEnum() || clazz.isAnnotation() || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isProtected(clazz.getModifiers()) || Modifier.isPrivate(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || Modifier.isTransient(clazz.getModifiers()) || Modifier.isFinal(clazz.getModifiers()) || Modifier.isNative(clazz.getModifiers()) || Modifier.isFinal(clazz.getModifiers());
        return !unSupport;
    }

    private boolean isSupportMock(DataConfig mockConfig, Field field) {
        boolean isUnSuppotModifier;
        if (field.isAnnotationPresent(MockIgnore.class)) {
            return false;
        }
        boolean bl = isUnSuppotModifier = Modifier.isFinal(field.getModifiers()) || Modifier.isNative(field.getModifiers()) || Modifier.isVolatile(field.getModifiers()) || Modifier.isInterface(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || field.isSynthetic();
        if (isUnSuppotModifier) {
            return false;
        }
        if (!mockConfig.globalConfig().isEnabledStatic() && Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (!mockConfig.globalConfig().isEnabledPublic() && Modifier.isPublic(field.getModifiers())) {
            return false;
        }
        if (!mockConfig.globalConfig().isEnabledProtected() && Modifier.isProtected(field.getModifiers())) {
            return false;
        }
        if (!mockConfig.globalConfig().isEnabledPrivate() && Modifier.isPrivate(field.getModifiers())) {
            return false;
        }
        if (field.getName() != null && field.getName().equalsIgnoreCase("serialVersionUID")) {
            return false;
        }
        return !mockConfig.globalConfig().isConfigExcludeMock(this.clazz, field.getName());
    }

    @Deprecated
    private void setFieldValueByIntrospector(DataConfig mockConfig, Object result) throws IntrospectionException, ReflectiveOperationException {
        for (Class currentClass = this.clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Map.Entry<Field, Method> entry : ReflectionUtils.fieldAndSetterMethod(currentClass).entrySet()) {
                Field field = entry.getKey();
                if (field.isAnnotationPresent(MockIgnore.class) || field.getName() != null && field.getName().equalsIgnoreCase("serialVersionUID") || mockConfig.globalConfig().isConfigExcludeMock(this.clazz, field.getName())) continue;
                ReflectionUtils.setRefValue(result, entry.getValue(), new BaseMocker(field.getGenericType(), new Type[0]).mock(mockConfig.globalConfig().getDataConfig(currentClass, field.getName())));
            }
        }
    }
}

