/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.http.source;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.flink.BaseFlinkSource;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.batch.FlinkBatchSource;
import org.apache.seatunnel.flink.http.source.util.HttpClientResult;
import org.apache.seatunnel.flink.http.source.util.HttpClientUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={BaseFlinkSource.class})
public class Http
implements FlinkBatchSource {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final int INITIAL_CAPACITY = 16;
    private static Logger LOG = LoggerFactory.getLogger(Http.class);
    private Config config;
    private String url;
    private String method;
    private String header;
    private String requestParams;
    private String syncPath;
    private Map requestMap;

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        return CheckConfigUtil.checkAllExists((Config)this.config, (String[])new String[]{"url"});
    }

    public void prepare(FlinkEnvironment env) {
        this.url = this.config.getString("url");
        this.method = (String)TypesafeConfigUtils.getConfig((Config)this.config, (String)"method", (Object)GET);
        this.header = (String)TypesafeConfigUtils.getConfig((Config)this.config, (String)"header", (Object)"");
        this.requestParams = (String)TypesafeConfigUtils.getConfig((Config)this.config, (String)"request_params", (Object)"");
        this.syncPath = (String)TypesafeConfigUtils.getConfig((Config)this.config, (String)"sync_path", (Object)"");
        this.requestMap = this.jsonToMap(this.requestParams);
    }

    public DataSet<Row> getData(FlinkEnvironment env) {
        String syncValues = this.getSyncValues(env.getBatchEnvironment(), this.syncPath);
        LOG.info("sync values->{}", (Object)syncValues);
        Map syncMap = this.jsonToMap(syncValues);
        if (!syncMap.isEmpty()) {
            this.requestMap.putAll(syncMap);
        }
        HttpClientResult response = new HttpClientResult();
        try {
            Map headerMap = this.jsonToMap(this.header);
            response = POST.equals(this.method) ? HttpClientUtils.doPost(this.url, headerMap, this.requestMap) : HttpClientUtils.doGet(this.url, headerMap, this.requestMap);
        }
        catch (Exception e) {
            LOG.error("http call error!", (Throwable)e);
            throw new RuntimeException(e);
        }
        LOG.info("http respond code->{}", (Object)response.getCode());
        LOG.info("http respond body->{}", (Object)response.getContent());
        return env.getBatchTableEnvironment().toDataSet(env.getBatchTableEnvironment().fromValues((AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"rawMsg", (DataType)DataTypes.STRING())}), new Object[]{response.getContent()}), Row.class);
    }

    private String getSyncValues(ExecutionEnvironment env, String syncPath) {
        if (null == syncPath || syncPath.isEmpty()) {
            return "";
        }
        List values = new ArrayList();
        try {
            DataSource source = env.readTextFile(syncPath);
            if (null != source) {
                values = source.collect();
            }
        }
        catch (Exception e) {
            LOG.error("getSyncValues error, syncPath is {}", (Object)syncPath, (Object)e);
        }
        return values.isEmpty() ? "" : (String)values.iterator().next();
    }

    private Map jsonToMap(String content) {
        HashMap map = new HashMap(16);
        if (null == content || content.isEmpty()) {
            return map;
        }
        try {
            return (Map)new ObjectMapper().readValue(content, HashMap.class);
        }
        catch (IOException e) {
            LOG.error("{} json to map error!", (Object)content, (Object)e);
            return map;
        }
    }
}

