/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kudu.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.io.BaseEncoding;
import org.apache.kudu.shaded.com.google.common.primitives.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@NotThreadSafe
public final class ByteVec {
    @VisibleForTesting
    static final int DEFAULT_CAPACITY = 32;
    private byte[] data;
    private int len;

    private ByteVec(int capacity) {
        this.data = new byte[capacity];
        this.len = 0;
    }

    private ByteVec(byte[] data) {
        this.data = data;
        this.len = data.length;
    }

    public static ByteVec create() {
        return new ByteVec(32);
    }

    public static ByteVec withCapacity(int capacity) {
        return new ByteVec(capacity);
    }

    public static ByteVec wrap(byte[] data) {
        return new ByteVec(data);
    }

    public int capacity() {
        return this.data.length;
    }

    public byte[] data() {
        return this.data;
    }

    public int len() {
        return this.len;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public void reserveAdditional(int additional) {
        Preconditions.checkArgument(additional >= 0, "negative additional");
        if (this.data.length - this.len >= additional) {
            return;
        }
        this.data = Arrays.copyOf(this.data, Math.max(this.len + additional, this.data.length + this.data.length / 2));
    }

    public void reserveExact(int additional) {
        Preconditions.checkArgument(additional >= 0, "negative additional");
        if (this.data.length - this.len >= additional) {
            return;
        }
        this.data = Arrays.copyOf(this.data, this.len + additional);
    }

    public void shrinkToFit() {
        if (this.len < this.data.length) {
            this.data = Arrays.copyOf(this.data, this.len);
        }
    }

    public void truncate(int len) {
        Preconditions.checkArgument(len >= 0, "negative len");
        this.len = Math.min(this.len, len);
    }

    public void clear() {
        this.truncate(0);
    }

    public void push(byte element) {
        this.reserveAdditional(1);
        this.data[this.len++] = element;
    }

    public void set(int index, byte value) {
        if (index >= this.len) {
            throw new IndexOutOfBoundsException(String.format("index: %s, len: %s", index, this.len));
        }
        this.data[index] = value;
    }

    public void append(byte[] values, int offset, int len) {
        this.reserveAdditional(len);
        System.arraycopy(values, offset, this.data, this.len, len);
        this.len += len;
    }

    public void append(byte[] values) {
        this.append(values, 0, values.length);
    }

    public void append(ByteVec other) {
        this.append(other.data, 0, other.len);
    }

    public byte get(int index) {
        if (index >= this.len) {
            throw new IndexOutOfBoundsException(String.format("index: %s, len: %s", index, this.len));
        }
        return this.data[index];
    }

    public List<Byte> asList() {
        List<Byte> list = Bytes.asList(this.data);
        if (this.len < this.data.length) {
            return list.subList(0, this.len);
        }
        return list;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.data, this.len);
    }

    public String toString() {
        if (this.len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(4 + this.len * 2);
        builder.append("[0x");
        builder.append(BaseEncoding.base16().encode(this.data, 0, this.len));
        builder.append(']');
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteVec other = (ByteVec)o;
        if (this.len != other.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.len;
        for (int i = 0; i < this.len; ++i) {
            result = 31 * result + this.data[i];
        }
        return result;
    }

    public ByteVec clone() {
        ByteVec clone = ByteVec.withCapacity(this.data.length);
        clone.append(this);
        return clone;
    }
}

