/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.sort.SortOrder;

public abstract class CompositeValuesSourceBuilder<AB extends CompositeValuesSourceBuilder<AB>>
implements Writeable,
ToXContentFragment {
    protected final String name;
    private String field = null;
    private Script script = null;
    private ValueType valueType = null;
    private boolean missingBucket = false;
    private SortOrder order = SortOrder.ASC;
    private String format = null;

    CompositeValuesSourceBuilder(String name) {
        this(name, null);
    }

    CompositeValuesSourceBuilder(String name, ValueType valueType) {
        this.name = name;
        this.valueType = valueType;
    }

    CompositeValuesSourceBuilder(StreamInput in) throws IOException {
        this.name = in.readString();
        this.field = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        if (in.readBoolean()) {
            this.valueType = ValueType.readFromStream(in);
        }
        this.missingBucket = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readBoolean() : false;
        if (in.getVersion().before(Version.V_7_0_0)) {
            in.readGenericValue();
        }
        this.order = SortOrder.readFromStream(in);
        this.format = in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readOptionalString() : null;
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.field);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        boolean hasValueType = this.valueType != null;
        out.writeBoolean(hasValueType);
        if (hasValueType) {
            this.valueType.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeBoolean(this.missingBucket);
        }
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeGenericValue(null);
        }
        this.order.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeOptionalString(this.format);
        }
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected abstract void doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.type());
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        builder.field("missing_bucket", this.missingBucket);
        if (this.valueType != null) {
            builder.field("value_type", this.valueType.getPreferredName());
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        builder.field("order", this.order);
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.missingBucket, this.script, this.valueType, this.order, this.format);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeValuesSourceBuilder that = (CompositeValuesSourceBuilder)o;
        return Objects.equals(this.field, that.field()) && Objects.equals(this.script, that.script()) && Objects.equals(this.valueType, that.valueType()) && Objects.equals(this.missingBucket, that.missingBucket()) && Objects.equals(this.order, that.order()) && Objects.equals(this.format, that.format());
    }

    public String name() {
        return this.name;
    }

    abstract String type();

    public AB field(String field) {
        if (field == null) {
            throw new IllegalArgumentException("[field] must not be null");
        }
        this.field = field;
        return (AB)this;
    }

    public String field() {
        return this.field;
    }

    public AB script(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("[script] must not be null");
        }
        this.script = script;
        return (AB)this;
    }

    public Script script() {
        return this.script;
    }

    public AB valueType(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[valueType] must not be null");
        }
        this.valueType = valueType;
        return (AB)this;
    }

    public ValueType valueType() {
        return this.valueType;
    }

    public AB missingBucket(boolean missingBucket) {
        this.missingBucket = missingBucket;
        return (AB)this;
    }

    public boolean missingBucket() {
        return this.missingBucket;
    }

    public AB order(String order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null");
        }
        this.order = SortOrder.fromString(order);
        return (AB)this;
    }

    public AB order(SortOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null");
        }
        this.order = order;
        return (AB)this;
    }

    public SortOrder order() {
        return this.order;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)this;
    }

    public String format() {
        return this.format;
    }

    protected abstract CompositeValuesSourceConfig innerBuild(QueryShardContext var1, ValuesSourceConfig<?> var2) throws IOException;

    public final CompositeValuesSourceConfig build(QueryShardContext queryShardContext) throws IOException {
        ValuesSourceConfig config = ValuesSourceConfig.resolve(queryShardContext, this.valueType, this.field, this.script, null, null, this.format);
        return this.innerBuild(queryShardContext, config);
    }
}

