/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericDVIndexFieldData;
import org.elasticsearch.search.MultiValueMode;

public class LongValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;
    private final Function<SortedNumericDocValues, SortedNumericDocValues> converter;

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        this(indexFieldData, missingValue, sortMode, nested, null);
    }

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, Function<SortedNumericDocValues, SortedNumericDocValues> converter) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
        this.converter = converter;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.LONG;
    }

    private SortedNumericDocValues loadDocValues(LeafReaderContext context) {
        AtomicNumericFieldData data = (AtomicNumericFieldData)this.indexFieldData.load(context);
        SortedNumericDocValues values = data instanceof SortedNumericDVIndexFieldData.NanoSecondFieldData ? ((SortedNumericDVIndexFieldData.NanoSecondFieldData)data).getLongValuesAsNanos() : data.getLongValues();
        return this.converter != null ? this.converter.apply(values) : values;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final Long dMissingValue = (Long)this.missingObject(this.missingValue, reversed);
        return new FieldComparator.LongComparator(numHits, null, null){

            @Override
            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                NumericDocValues selectedValues;
                SortedNumericDocValues values = LongValuesComparatorSource.this.loadDocValues(context);
                if (LongValuesComparatorSource.this.nested == null) {
                    selectedValues = FieldData.replaceMissing(LongValuesComparatorSource.this.sortMode.select(values), dMissingValue);
                } else {
                    BitSet rootDocs = LongValuesComparatorSource.this.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = LongValuesComparatorSource.this.nested.innerDocs(context);
                    int maxChildren = LongValuesComparatorSource.this.nested.getNestedSort() != null ? LongValuesComparatorSource.this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
                    selectedValues = LongValuesComparatorSource.this.sortMode.select(values, dMissingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
                }
                return selectedValues;
            }
        };
    }
}

