/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.DestConfig;
import org.elasticsearch.client.transform.transforms.SourceConfig;
import org.elasticsearch.client.transform.transforms.SyncConfig;
import org.elasticsearch.client.transform.transforms.TransformConfig;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class TransformConfigUpdate
implements ToXContentObject {
    public static final String NAME = "transform_config_update";
    private static final ConstructingObjectParser<TransformConfigUpdate, String> PARSER = new ConstructingObjectParser("transform_config_update", false, args -> {
        SourceConfig source = (SourceConfig)args[0];
        DestConfig dest = (DestConfig)args[1];
        TimeValue frequency = args[2] == null ? null : TimeValue.parseTimeValue((String)args[2], TransformConfig.FREQUENCY.getPreferredName());
        SyncConfig syncConfig = (SyncConfig)args[3];
        String description = (String)args[4];
        return new TransformConfigUpdate(source, dest, frequency, syncConfig, description);
    });
    private final SourceConfig source;
    private final DestConfig dest;
    private final TimeValue frequency;
    private final SyncConfig syncConfig;
    private final String description;

    private static SyncConfig parseSyncConfig(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser::getTokenLocation);
        SyncConfig syncConfig = parser.namedObject(SyncConfig.class, parser.currentName(), false);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser::getTokenLocation);
        return syncConfig;
    }

    public TransformConfigUpdate(SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, String description) {
        this.source = source;
        this.dest = dest;
        this.frequency = frequency;
        this.syncConfig = syncConfig;
        this.description = description;
    }

    public SourceConfig getSource() {
        return this.source;
    }

    public DestConfig getDestination() {
        return this.dest;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.source != null) {
            builder.field(TransformConfig.SOURCE.getPreferredName(), this.source);
        }
        if (this.dest != null) {
            builder.field(TransformConfig.DEST.getPreferredName(), this.dest);
        }
        if (this.frequency != null) {
            builder.field(TransformConfig.FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        if (this.syncConfig != null) {
            builder.startObject(TransformConfig.SYNC.getPreferredName());
            builder.field(this.syncConfig.getName(), this.syncConfig);
            builder.endObject();
        }
        if (this.description != null) {
            builder.field(TransformConfig.DESCRIPTION.getPreferredName(), this.description);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformConfigUpdate that = (TransformConfigUpdate)other;
        return Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.dest, this.frequency, this.syncConfig, this.description);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TransformConfigUpdate fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SourceConfig.PARSER.apply(p, null), TransformConfig.SOURCE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DestConfig.PARSER.apply(p, null), TransformConfig.DEST);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformConfig.FREQUENCY);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TransformConfigUpdate.parseSyncConfig(p), TransformConfig.SYNC);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformConfig.DESCRIPTION);
    }

    public static class Builder {
        private SourceConfig source;
        private DestConfig dest;
        private TimeValue frequency;
        private SyncConfig syncConfig;
        private String description;

        public Builder setSource(SourceConfig source) {
            this.source = source;
            return this;
        }

        public Builder setDest(DestConfig dest) {
            this.dest = dest;
            return this;
        }

        public Builder setFrequency(TimeValue frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder setSyncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public TransformConfigUpdate build() {
            return new TransformConfigUpdate(this.source, this.dest, this.frequency, this.syncConfig, this.description);
        }
    }
}

