/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.transform.transforms.TransformConfig;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class PutTransformRequest
implements ToXContentObject,
Validatable {
    public static final String DEFER_VALIDATION = "defer_validation";
    private final TransformConfig config;
    private Boolean deferValidation;

    public PutTransformRequest(TransformConfig config) {
        this.config = config;
    }

    public TransformConfig getConfig() {
        return this.config;
    }

    public Boolean getDeferValidation() {
        return this.deferValidation;
    }

    public void setDeferValidation(boolean deferValidation) {
        this.deferValidation = deferValidation;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.config == null) {
            validationException.addValidationError("put requires a non-null transform config");
            return Optional.of(validationException);
        }
        if (this.config.getId() == null) {
            validationException.addValidationError("transform id cannot be null");
        }
        if (this.config.getSource() == null) {
            validationException.addValidationError("transform source cannot be null");
        }
        if (this.config.getDestination() == null) {
            validationException.addValidationError("transform destination cannot be null");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.config.toXContent(builder, params);
    }

    public int hashCode() {
        return Objects.hash(this.config);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PutTransformRequest other = (PutTransformRequest)obj;
        return Objects.equals(this.config, other.config);
    }
}

