/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.xcontent.XContentParser;

public class PreviewTransformResponse {
    private static final String PREVIEW = "preview";
    private static final String MAPPINGS = "mappings";
    private List<Map<String, Object>> docs;
    private Map<String, Object> mappings;

    public static PreviewTransformResponse fromXContent(XContentParser parser) throws IOException {
        Map<String, Object> previewMap = parser.mapOrdered();
        Object previewDocs = previewMap.get(PREVIEW);
        Object mappings = previewMap.get(MAPPINGS);
        return new PreviewTransformResponse((List)previewDocs, (Map)mappings);
    }

    public PreviewTransformResponse(List<Map<String, Object>> docs, Map<String, Object> mappings) {
        this.docs = docs;
        this.mappings = mappings;
    }

    public List<Map<String, Object>> getDocs() {
        return this.docs;
    }

    public Map<String, Object> getMappings() {
        return this.mappings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PreviewTransformResponse other = (PreviewTransformResponse)obj;
        return Objects.equals(other.docs, this.docs) && Objects.equals(other.mappings, this.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.docs, this.mappings);
    }
}

