/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.indices.AnalyzeResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DetailAnalyzeResponse {
    private final boolean customAnalyzer;
    private final AnalyzeTokenList analyzer;
    private final CharFilteredText[] charfilters;
    private final AnalyzeTokenList tokenizer;
    private final AnalyzeTokenList[] tokenfilters;
    static final ConstructingObjectParser<DetailAnalyzeResponse, Void> PARSER = new ConstructingObjectParser("detail", true, args -> new DetailAnalyzeResponse((Boolean)args[0], (AnalyzeTokenList)args[1], (List)args[2], (AnalyzeTokenList)args[3], (List)args[4]));

    private DetailAnalyzeResponse(boolean customAnalyzer, AnalyzeTokenList analyzer, List<CharFilteredText> charfilters, AnalyzeTokenList tokenizer, List<AnalyzeTokenList> tokenfilters) {
        this.customAnalyzer = customAnalyzer;
        this.analyzer = analyzer;
        this.charfilters = charfilters == null ? null : charfilters.toArray(new CharFilteredText[0]);
        this.tokenizer = tokenizer;
        this.tokenfilters = tokenfilters == null ? null : tokenfilters.toArray(new AnalyzeTokenList[0]);
    }

    public AnalyzeTokenList analyzer() {
        return this.analyzer;
    }

    public CharFilteredText[] charfilters() {
        return this.charfilters;
    }

    public AnalyzeTokenList tokenizer() {
        return this.tokenizer;
    }

    public AnalyzeTokenList[] tokenfilters() {
        return this.tokenfilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailAnalyzeResponse that = (DetailAnalyzeResponse)o;
        return this.customAnalyzer == that.customAnalyzer && Objects.equals(this.analyzer, that.analyzer) && Arrays.equals(this.charfilters, that.charfilters) && Objects.equals(this.tokenizer, that.tokenizer) && Arrays.equals(this.tokenfilters, that.tokenfilters);
    }

    public int hashCode() {
        int result = Objects.hash(this.customAnalyzer, this.analyzer, this.tokenizer);
        result = 31 * result + Arrays.hashCode(this.charfilters);
        result = 31 * result + Arrays.hashCode(this.tokenfilters);
        return result;
    }

    public static DetailAnalyzeResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("custom_analyzer", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), AnalyzeTokenList.PARSER, new ParseField("analyzer", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), CharFilteredText.PARSER, new ParseField("charfilters", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), AnalyzeTokenList.PARSER, new ParseField("tokenizer", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), AnalyzeTokenList.PARSER, new ParseField("tokenfilters", new String[0]));
    }

    public static class CharFilteredText {
        private final String name;
        private final String[] texts;
        private static final ConstructingObjectParser<CharFilteredText, Void> PARSER = new ConstructingObjectParser("char_filtered_text", true, args -> new CharFilteredText((String)args[0], ((List)args[1]).toArray(new String[0])));

        CharFilteredText(String name, String[] texts) {
            this.name = name;
            this.texts = texts != null ? texts : Strings.EMPTY_ARRAY;
        }

        public String getName() {
            return this.name;
        }

        public String[] getTexts() {
            return this.texts;
        }

        public static CharFilteredText fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharFilteredText that = (CharFilteredText)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.texts, that.texts);
        }

        public int hashCode() {
            int result = Objects.hash(this.name);
            result = 31 * result + Arrays.hashCode(this.texts);
            return result;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
            PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("filtered_text", new String[0]));
        }
    }

    public static class AnalyzeTokenList {
        private final String name;
        private final AnalyzeResponse.AnalyzeToken[] tokens;
        private static final ConstructingObjectParser<AnalyzeTokenList, Void> PARSER = new ConstructingObjectParser("token_list", true, args -> new AnalyzeTokenList((String)args[0], (List)args[1]));

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnalyzeTokenList that = (AnalyzeTokenList)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.tokens, that.tokens);
        }

        public int hashCode() {
            int result = Objects.hash(this.name);
            result = 31 * result + Arrays.hashCode(this.tokens);
            return result;
        }

        public AnalyzeTokenList(String name, List<AnalyzeResponse.AnalyzeToken> tokens) {
            this.name = name;
            this.tokens = tokens.toArray(new AnalyzeResponse.AnalyzeToken[0]);
        }

        public String getName() {
            return this.name;
        }

        public AnalyzeResponse.AnalyzeToken[] getTokens() {
            return this.tokens;
        }

        public static AnalyzeTokenList fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> AnalyzeResponse.AnalyzeToken.fromXContent(p), new ParseField("tokens", new String[0]));
        }
    }
}

