/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.suggest.document.NRTSuggesterBuilder;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

final class CompletionFieldsConsumer
extends FieldsConsumer {
    private final String delegatePostingsFormatName;
    private final Map<String, CompletionMetaData> seenFields = new HashMap<String, CompletionMetaData>();
    private final SegmentWriteState state;
    private IndexOutput dictOut;
    private FieldsConsumer delegateFieldsConsumer;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CompletionFieldsConsumer(PostingsFormat delegatePostingsFormat, SegmentWriteState state) throws IOException {
        this.delegatePostingsFormatName = delegatePostingsFormat.getName();
        this.state = state;
        String dictFile = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "lkp");
        boolean success = false;
        try {
            this.delegateFieldsConsumer = delegatePostingsFormat.fieldsConsumer(state);
            this.dictOut = state.directory.createOutput(dictFile, state.context);
            CodecUtil.writeIndexHeader(this.dictOut, "completion", 1, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.dictOut, this.delegateFieldsConsumer);
            throw throwable;
        }
    }

    @Override
    public void write(Fields fields, NormsProducer norms) throws IOException {
        this.delegateFieldsConsumer.write(fields, norms);
        for (String field : fields) {
            BytesRef term;
            CompletionTermWriter termWriter = new CompletionTermWriter();
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            TermsEnum termsEnum = terms.iterator();
            while ((term = termsEnum.next()) != null) {
                termWriter.write(term, termsEnum);
            }
            long filePointer = this.dictOut.getFilePointer();
            if (!termWriter.finish(this.dictOut)) continue;
            this.seenFields.put(field, new CompletionMetaData(filePointer, termWriter.minWeight, termWriter.maxWeight, termWriter.type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        String indexFile = IndexFileNames.segmentFileName(this.state.segmentInfo.name, this.state.segmentSuffix, "cmp");
        boolean success = false;
        try {
            try (IndexOutput indexOut = this.state.directory.createOutput(indexFile, this.state.context);){
                this.delegateFieldsConsumer.close();
                CodecUtil.writeIndexHeader(indexOut, "completion", 1, this.state.segmentInfo.getId(), this.state.segmentSuffix);
                indexOut.writeString(this.delegatePostingsFormatName);
                indexOut.writeVInt(this.seenFields.size());
                for (Map.Entry<String, CompletionMetaData> seenField : this.seenFields.entrySet()) {
                    FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(seenField.getKey());
                    indexOut.writeVInt(fieldInfo.number);
                    CompletionMetaData metaData = seenField.getValue();
                    indexOut.writeVLong(metaData.filePointer);
                    indexOut.writeVLong(metaData.minWeight);
                    indexOut.writeVLong(metaData.maxWeight);
                    indexOut.writeByte(metaData.type);
                }
                CodecUtil.writeFooter(indexOut);
                CodecUtil.writeFooter(this.dictOut);
                IOUtils.close(this.dictOut);
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.dictOut, this.delegateFieldsConsumer);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.dictOut, this.delegateFieldsConsumer);
    }

    private static class CompletionTermWriter {
        private PostingsEnum postingsEnum = null;
        private int docCount = 0;
        private long maxWeight = 0L;
        private long minWeight = Long.MAX_VALUE;
        private byte type;
        private boolean first = true;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final NRTSuggesterBuilder builder = new NRTSuggesterBuilder();

        public boolean finish(IndexOutput output) throws IOException {
            boolean stored = this.builder.store(output);
            assert (stored || this.docCount == 0) : "the FST is null but docCount is != 0 actual value: [" + this.docCount + "]";
            if (this.docCount == 0) {
                this.minWeight = 0L;
            }
            return stored;
        }

        public void write(BytesRef term, TermsEnum termsEnum) throws IOException {
            this.postingsEnum = termsEnum.postings(this.postingsEnum, 88);
            this.builder.startTerm(term);
            int docFreq = 0;
            while (this.postingsEnum.nextDoc() != Integer.MAX_VALUE) {
                int docID = this.postingsEnum.docID();
                for (int i = 0; i < this.postingsEnum.freq(); ++i) {
                    this.postingsEnum.nextPosition();
                    assert (this.postingsEnum.getPayload() != null);
                    BytesRef payload = this.postingsEnum.getPayload();
                    ByteArrayDataInput input = new ByteArrayDataInput(payload.bytes, payload.offset, payload.length);
                    int len = input.readVInt();
                    this.scratch.grow(len);
                    this.scratch.setLength(len);
                    input.readBytes(this.scratch.bytes(), 0, this.scratch.length());
                    long weight = input.readVInt() - 1;
                    this.maxWeight = Math.max(this.maxWeight, weight);
                    this.minWeight = Math.min(this.minWeight, weight);
                    byte type = input.readByte();
                    if (this.first) {
                        this.type = type;
                        this.first = false;
                    } else if (this.type != type) {
                        throw new IllegalArgumentException("single field name has mixed types");
                    }
                    this.builder.addEntry(docID, this.scratch.get(), weight);
                }
                this.docCount = Math.max(this.docCount, ++docFreq + 1);
            }
            this.builder.finishTerm();
        }
    }

    private static class CompletionMetaData {
        private final long filePointer;
        private final long minWeight;
        private final long maxWeight;
        private final byte type;

        private CompletionMetaData(long filePointer, long minWeight, long maxWeight, byte type) {
            this.filePointer = filePointer;
            this.minWeight = minWeight;
            this.maxWeight = maxWeight;
            this.type = type;
        }
    }
}

