/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

public class TermGroupSelector
extends GroupSelector<BytesRef> {
    private final String field;
    private final BytesRefHash values = new BytesRefHash();
    private final Map<Integer, Integer> ordsToGroupIds = new HashMap<Integer, Integer>();
    private SortedDocValues docValues;
    private int groupId;
    private boolean secondPass;
    private boolean includeEmpty;
    private BytesRef scratch = new BytesRef();

    public TermGroupSelector(String field) {
        this.field = field;
    }

    @Override
    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        this.docValues = DocValues.getSorted(readerContext.reader(), this.field);
        this.ordsToGroupIds.clear();
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.get(i, scratch);
            int ord = this.docValues.lookupTerm(scratch);
            if (ord < 0) continue;
            this.ordsToGroupIds.put(ord, i);
        }
    }

    @Override
    public GroupSelector.State advanceTo(int doc) throws IOException {
        if (!this.docValues.advanceExact(doc)) {
            this.groupId = -1;
            return this.includeEmpty ? GroupSelector.State.ACCEPT : GroupSelector.State.SKIP;
        }
        int ord = this.docValues.ordValue();
        if (this.ordsToGroupIds.containsKey(ord)) {
            this.groupId = this.ordsToGroupIds.get(ord);
            return GroupSelector.State.ACCEPT;
        }
        if (this.secondPass) {
            return GroupSelector.State.SKIP;
        }
        this.groupId = this.values.add(this.docValues.binaryValue());
        this.ordsToGroupIds.put(ord, this.groupId);
        return GroupSelector.State.ACCEPT;
    }

    @Override
    public BytesRef currentValue() {
        if (this.groupId == -1) {
            return null;
        }
        this.values.get(this.groupId, this.scratch);
        return this.scratch;
    }

    @Override
    public BytesRef copyValue() {
        if (this.groupId == -1) {
            return null;
        }
        return BytesRef.deepCopyOf(this.currentValue());
    }

    @Override
    public void setGroups(Collection<SearchGroup<BytesRef>> searchGroups) {
        this.values.clear();
        this.values.reinit();
        for (SearchGroup<BytesRef> sg : searchGroups) {
            if (sg.groupValue == null) {
                this.includeEmpty = true;
                continue;
            }
            this.values.add((BytesRef)sg.groupValue);
        }
        this.secondPass = true;
    }
}

