/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.CollectedSearchGroup;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;

public class FirstPassGroupingCollector<T>
extends SimpleCollector {
    private final GroupSelector<T> groupSelector;
    private final FieldComparator<?>[] comparators;
    private final LeafFieldComparator[] leafComparators;
    private final int[] reversed;
    private final int topNGroups;
    private final boolean needsScores;
    private final HashMap<T, CollectedSearchGroup<T>> groupMap;
    private final int compIDXEnd;
    protected TreeSet<CollectedSearchGroup<T>> orderedGroups;
    private int docBase;
    private int spareSlot;

    public FirstPassGroupingCollector(GroupSelector<T> groupSelector, Sort groupSort, int topNGroups) {
        this.groupSelector = groupSelector;
        if (topNGroups < 1) {
            throw new IllegalArgumentException("topNGroups must be >= 1 (got " + topNGroups + ")");
        }
        this.topNGroups = topNGroups;
        this.needsScores = groupSort.needsScores();
        SortField[] sortFields = groupSort.getSort();
        this.comparators = new FieldComparator[sortFields.length];
        this.leafComparators = new LeafFieldComparator[sortFields.length];
        this.compIDXEnd = this.comparators.length - 1;
        this.reversed = new int[sortFields.length];
        for (int i = 0; i < sortFields.length; ++i) {
            SortField sortField = sortFields[i];
            this.comparators[i] = sortField.getComparator(topNGroups + 1, i);
            this.reversed[i] = sortField.getReverse() ? -1 : 1;
        }
        this.spareSlot = topNGroups;
        this.groupMap = new HashMap(topNGroups);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.needsScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public Collection<SearchGroup<T>> getTopGroups(int groupOffset) throws IOException {
        if (groupOffset < 0) {
            throw new IllegalArgumentException("groupOffset must be >= 0 (got " + groupOffset + ")");
        }
        if (this.groupMap.size() <= groupOffset) {
            return null;
        }
        if (this.orderedGroups == null) {
            this.buildSortedSet();
        }
        ArrayList<SearchGroup<T>> result = new ArrayList<SearchGroup<T>>();
        int upto = 0;
        int sortFieldCount = this.comparators.length;
        for (CollectedSearchGroup<T> group : this.orderedGroups) {
            if (upto++ < groupOffset) continue;
            SearchGroup searchGroup = new SearchGroup();
            searchGroup.groupValue = group.groupValue;
            searchGroup.sortValues = new Object[sortFieldCount];
            for (int sortFieldIDX = 0; sortFieldIDX < sortFieldCount; ++sortFieldIDX) {
                searchGroup.sortValues[sortFieldIDX] = this.comparators[sortFieldIDX].value(group.comparatorSlot);
            }
            result.add(searchGroup);
        }
        return result;
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        for (LeafFieldComparator comparator : this.leafComparators) {
            comparator.setScorer(scorer);
        }
    }

    private boolean isCompetitive(int doc) throws IOException {
        if (this.orderedGroups != null) {
            int compIDX = 0;
            while (true) {
                int c;
                if ((c = this.reversed[compIDX] * this.leafComparators[compIDX].compareBottom(doc)) < 0) {
                    return false;
                }
                if (c > 0) break;
                if (compIDX == this.compIDXEnd) {
                    return false;
                }
                ++compIDX;
            }
        }
        return true;
    }

    @Override
    public void collect(int doc) throws IOException {
        CollectedSearchGroup<T> prevLast;
        if (!this.isCompetitive(doc)) {
            return;
        }
        this.groupSelector.advanceTo(doc);
        T groupValue = this.groupSelector.currentValue();
        CollectedSearchGroup<T> group = this.groupMap.get(groupValue);
        if (group == null) {
            if (this.groupMap.size() < this.topNGroups) {
                CollectedSearchGroup sg = new CollectedSearchGroup();
                sg.groupValue = this.groupSelector.copyValue();
                sg.comparatorSlot = this.groupMap.size();
                sg.topDoc = this.docBase + doc;
                for (LeafFieldComparator fc : this.leafComparators) {
                    fc.copy(sg.comparatorSlot, doc);
                }
                this.groupMap.put(sg.groupValue, sg);
                if (this.groupMap.size() == this.topNGroups) {
                    this.buildSortedSet();
                }
                return;
            }
            CollectedSearchGroup<T> bottomGroup = this.orderedGroups.pollLast();
            assert (this.orderedGroups.size() == this.topNGroups - 1);
            this.groupMap.remove(bottomGroup.groupValue);
            bottomGroup.groupValue = this.groupSelector.copyValue();
            bottomGroup.topDoc = this.docBase + doc;
            for (LeafFieldComparator fc : this.leafComparators) {
                fc.copy(bottomGroup.comparatorSlot, doc);
            }
            this.groupMap.put(bottomGroup.groupValue, bottomGroup);
            this.orderedGroups.add(bottomGroup);
            assert (this.orderedGroups.size() == this.topNGroups);
            int lastComparatorSlot = this.orderedGroups.last().comparatorSlot;
            for (LeafFieldComparator fc : this.leafComparators) {
                fc.setBottom(lastComparatorSlot);
            }
            return;
        }
        int compIDX = 0;
        while (true) {
            this.leafComparators[compIDX].copy(this.spareSlot, doc);
            int c = this.reversed[compIDX] * this.comparators[compIDX].compare(group.comparatorSlot, this.spareSlot);
            if (c < 0) {
                return;
            }
            if (c > 0) {
                for (int compIDX2 = compIDX + 1; compIDX2 < this.comparators.length; ++compIDX2) {
                    this.leafComparators[compIDX2].copy(this.spareSlot, doc);
                }
                break;
            }
            if (compIDX == this.compIDXEnd) {
                return;
            }
            ++compIDX;
        }
        if (this.orderedGroups != null) {
            prevLast = this.orderedGroups.last();
            this.orderedGroups.remove(group);
            assert (this.orderedGroups.size() == this.topNGroups - 1);
        } else {
            prevLast = null;
        }
        group.topDoc = this.docBase + doc;
        int tmp = this.spareSlot;
        this.spareSlot = group.comparatorSlot;
        group.comparatorSlot = tmp;
        if (this.orderedGroups != null) {
            this.orderedGroups.add(group);
            assert (this.orderedGroups.size() == this.topNGroups);
            CollectedSearchGroup<T> newLast = this.orderedGroups.last();
            if (group == newLast || prevLast != newLast) {
                for (LeafFieldComparator fc : this.leafComparators) {
                    fc.setBottom(newLast.comparatorSlot);
                }
            }
        }
    }

    private void buildSortedSet() throws IOException {
        Comparator comparator = new Comparator<CollectedSearchGroup<?>>(){

            @Override
            public int compare(CollectedSearchGroup<?> o1, CollectedSearchGroup<?> o2) {
                int compIDX = 0;
                while (true) {
                    FieldComparator fc = FirstPassGroupingCollector.this.comparators[compIDX];
                    int c = FirstPassGroupingCollector.this.reversed[compIDX] * fc.compare(o1.comparatorSlot, o2.comparatorSlot);
                    if (c != 0) {
                        return c;
                    }
                    if (compIDX == FirstPassGroupingCollector.this.compIDXEnd) {
                        return o1.topDoc - o2.topDoc;
                    }
                    ++compIDX;
                }
            }
        };
        this.orderedGroups = new TreeSet(comparator);
        this.orderedGroups.addAll(this.groupMap.values());
        assert (this.orderedGroups.size() > 0);
        for (LeafFieldComparator fc : this.leafComparators) {
            fc.setBottom(this.orderedGroups.last().comparatorSlot);
        }
    }

    @Override
    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        this.docBase = readerContext.docBase;
        for (int i = 0; i < this.comparators.length; ++i) {
            this.leafComparators[i] = this.comparators[i].getLeafComparator(readerContext);
        }
        this.groupSelector.setNextReader(readerContext);
    }

    public GroupSelector<T> getGroupSelector() {
        return this.groupSelector;
    }
}

