/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.util.NumericUtils;

public final class XYEncodingUtils {
    public static final double MIN_VAL_INCL = -3.4028234663852886E38;
    public static final double MAX_VAL_INCL = 3.4028234663852886E38;

    private XYEncodingUtils() {
    }

    public static void checkVal(double x) {
        if (Double.isNaN(x) || x < -3.4028234663852886E38 || x > 3.4028234663852886E38) {
            throw new IllegalArgumentException("invalid value " + x + "; must be between " + -3.4028234663852886E38 + " and " + 3.4028234663852886E38);
        }
    }

    public static int encode(double x) {
        XYEncodingUtils.checkVal(x);
        return NumericUtils.floatToSortableInt((float)x);
    }

    public static double decode(int encoded) {
        double result = NumericUtils.sortableIntToFloat(encoded);
        assert (result >= -3.4028234663852886E38 && result <= 3.4028234663852886E38);
        return result;
    }

    public static double decode(byte[] src, int offset) {
        return XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(src, offset));
    }
}

