/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.connectors.elasticsearch.table.AbstractTimeIndexGenerator;
import org.apache.flink.streaming.connectors.elasticsearch.table.IndexGenerator;
import org.apache.flink.streaming.connectors.elasticsearch.table.IndexGeneratorBase;
import org.apache.flink.streaming.connectors.elasticsearch.table.StaticIndexGenerator;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
final class IndexGeneratorFactory {
    private IndexGeneratorFactory() {
    }

    public static IndexGenerator createIndexGenerator(String index, TableSchema schema) {
        IndexHelper indexHelper = new IndexHelper();
        if (indexHelper.checkIsDynamicIndex(index)) {
            return IndexGeneratorFactory.createRuntimeIndexGenerator(index, schema.getFieldNames(), schema.getFieldDataTypes(), indexHelper);
        }
        return new StaticIndexGenerator(index);
    }

    private static IndexGenerator createRuntimeIndexGenerator(String index, String[] fieldNames, DataType[] fieldTypes, IndexHelper indexHelper) {
        String dynamicIndexPatternStr = indexHelper.extractDynamicIndexPatternStr(index);
        final String indexPrefix = index.substring(0, index.indexOf(dynamicIndexPatternStr));
        final String indexSuffix = index.substring(indexPrefix.length() + dynamicIndexPatternStr.length());
        boolean isDynamicIndexWithFormat = indexHelper.checkIsDynamicIndexWithFormat(index);
        int indexFieldPos = indexHelper.extractIndexFieldPos(index, fieldNames, isDynamicIndexWithFormat);
        LogicalType indexFieldType = fieldTypes[indexFieldPos].getLogicalType();
        LogicalTypeRoot indexFieldLogicalTypeRoot = indexFieldType.getTypeRoot();
        indexHelper.validateIndexFieldType(indexFieldLogicalTypeRoot);
        final RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)indexFieldType, (int)indexFieldPos);
        if (isDynamicIndexWithFormat) {
            String dateTimeFormat = indexHelper.extractDateFormat(index, indexFieldLogicalTypeRoot);
            final DynamicFormatter formatFunction = IndexGeneratorFactory.createFormatFunction(indexFieldType, indexFieldLogicalTypeRoot);
            return new AbstractTimeIndexGenerator(index, dateTimeFormat){

                @Override
                public String generate(RowData row) {
                    Object fieldOrNull = fieldGetter.getFieldOrNull(row);
                    String formattedField = fieldOrNull != null ? formatFunction.format(fieldOrNull, this.dateTimeFormatter) : "null";
                    return indexPrefix.concat(formattedField).concat(indexSuffix);
                }
            };
        }
        return new IndexGeneratorBase(index){

            @Override
            public String generate(RowData row) {
                Object indexField = fieldGetter.getFieldOrNull(row);
                return indexPrefix.concat(indexField == null ? "null" : indexField.toString()).concat(indexSuffix);
            }
        };
    }

    private static DynamicFormatter createFormatFunction(LogicalType indexFieldType, LogicalTypeRoot indexFieldLogicalTypeRoot) {
        switch (indexFieldLogicalTypeRoot) {
            case DATE: {
                return (value, dateTimeFormatter) -> {
                    Integer indexField = (Integer)value;
                    return LocalDate.ofEpochDay(indexField.intValue()).format(dateTimeFormatter);
                };
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (value, dateTimeFormatter) -> {
                    Integer indexField = (Integer)value;
                    return LocalTime.ofNanoOfDay((long)indexField.intValue() * 1000000L).format(dateTimeFormatter);
                };
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return (value, dateTimeFormatter) -> {
                    TimestampData indexField = (TimestampData)value;
                    return indexField.toLocalDateTime().format(dateTimeFormatter);
                };
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException("TIMESTAMP_WITH_TIME_ZONE is not supported yet");
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return (value, dateTimeFormatter) -> {
                    TimestampData indexField = (TimestampData)value;
                    return indexField.toInstant().atZone(ZoneOffset.UTC).format(dateTimeFormatter);
                };
            }
        }
        throw new TableException(String.format("Unsupported type '%s' found in Elasticsearch dynamic index field, time-related pattern only support types are: DATE,TIME,TIMESTAMP.", indexFieldType));
    }

    private static class IndexHelper {
        private static final Pattern dynamicIndexPattern = Pattern.compile("\\{[^\\{\\}]+\\}?");
        private static final Pattern dynamicIndexTimeExtractPattern = Pattern.compile(".*\\{.+\\|.*\\}.*");
        private static final List<LogicalTypeRoot> supportedTypes = new ArrayList<LogicalTypeRoot>();
        private static final Map<LogicalTypeRoot, String> defaultFormats = new HashMap<LogicalTypeRoot, String>();

        private IndexHelper() {
        }

        void validateIndexFieldType(LogicalTypeRoot logicalType) {
            if (!supportedTypes.contains(logicalType)) {
                throw new IllegalArgumentException(String.format("Unsupported type %s of index field, Supported types are: %s", logicalType, supportedTypes));
            }
        }

        String getDefaultFormat(LogicalTypeRoot logicalType) {
            return defaultFormats.get(logicalType);
        }

        boolean checkIsDynamicIndex(String index) {
            Matcher matcher = dynamicIndexPattern.matcher(index);
            int count = 0;
            while (matcher.find()) {
                ++count;
            }
            if (count > 1) {
                throw new TableException(String.format("Chaining dynamic index pattern %s is not supported, only support single dynamic index pattern.", index));
            }
            return count == 1;
        }

        boolean checkIsDynamicIndexWithFormat(String index) {
            return dynamicIndexTimeExtractPattern.matcher(index).matches();
        }

        String extractDynamicIndexPatternStr(String index) {
            int start = index.indexOf("{");
            int end = index.lastIndexOf("}");
            return index.substring(start, end + 1);
        }

        int extractIndexFieldPos(String index, String[] fieldNames, boolean isDynamicIndexWithFormat) {
            String indexFieldName;
            List<String> fieldList = Arrays.asList(fieldNames);
            if (!fieldList.contains(indexFieldName = isDynamicIndexWithFormat ? index.substring(index.indexOf("{") + 1, index.indexOf("|")) : index.substring(index.indexOf("{") + 1, index.indexOf("}")))) {
                throw new TableException(String.format("Unknown field '%s' in index pattern '%s', please check the field name.", indexFieldName, index));
            }
            return fieldList.indexOf(indexFieldName);
        }

        private String extractDateFormat(String index, LogicalTypeRoot logicalType) {
            String format = index.substring(index.indexOf("|") + 1, index.indexOf("}"));
            if ("".equals(format)) {
                format = this.getDefaultFormat(logicalType);
            }
            return format;
        }

        static {
            supportedTypes.add(LogicalTypeRoot.DATE);
            supportedTypes.add(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE);
            supportedTypes.add(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE);
            supportedTypes.add(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE);
            supportedTypes.add(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
            supportedTypes.add(LogicalTypeRoot.VARCHAR);
            supportedTypes.add(LogicalTypeRoot.CHAR);
            supportedTypes.add(LogicalTypeRoot.TINYINT);
            supportedTypes.add(LogicalTypeRoot.INTEGER);
            supportedTypes.add(LogicalTypeRoot.BIGINT);
            defaultFormats.put(LogicalTypeRoot.DATE, "yyyy_MM_dd");
            defaultFormats.put(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, "HH_mm_ss");
            defaultFormats.put(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, "yyyy_MM_dd_HH_mm_ss");
            defaultFormats.put(LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, "yyyy_MM_dd_HH_mm_ss");
            defaultFormats.put(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, "yyyy_MM_dd_HH_mm_ssX");
        }
    }

    static interface DynamicFormatter
    extends Serializable {
        public String format(@Nonnull Object var1, DateTimeFormatter var2);
    }
}

