/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.io.Closeable;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.pubkey.KeyPairIdentity;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.kex.extension.DefaultClientKexExtensionHandler;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesHolder;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class UserAuthPublicKey
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "publickey";
    protected final Deque<String> currentAlgorithms = new LinkedList<String>();
    protected Iterator<PublicKeyIdentity> keys;
    protected PublicKeyIdentity current;
    protected List<NamedFactory<Signature>> factories;
    protected String chosenAlgorithm;

    public UserAuthPublicKey() {
        this((List<NamedFactory<Signature>>)null);
    }

    public UserAuthPublicKey(List<NamedFactory<Signature>> factories) {
        super(NAME);
        this.factories = factories;
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.releaseKeys();
        try {
            this.keys = new UserAuthPublicKeyIterator(session, this);
        }
        catch (Error e) {
            this.warn("init({})[{}] failed ({}) to initialize session keys: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        KeyPair keyPair;
        boolean debugEnabled = this.log.isDebugEnabled();
        String currentAlgorithm = null;
        if (this.current == null) {
            this.currentAlgorithms.clear();
            this.chosenAlgorithm = null;
        } else if (!this.currentAlgorithms.isEmpty()) {
            Set<String> knownServerAlgorithms;
            currentAlgorithm = this.currentAlgorithms.poll();
            if (this.chosenAlgorithm != null && (knownServerAlgorithms = session.getAttribute(DefaultClientKexExtensionHandler.SERVER_ALGORITHMS)) != null && knownServerAlgorithms.contains(this.chosenAlgorithm)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("sendAuthDataRequest({})[{}] server rejected publickey authentication with known signature algorithm {}", session, service, this.chosenAlgorithm);
                }
                currentAlgorithm = null;
            }
        }
        PublicKeyAuthenticationReporter reporter = session.getPublicKeyAuthenticationReporter();
        if (currentAlgorithm == null) {
            try {
                this.current = this.resolveAttemptedPublicKeyIdentity(session, service);
            }
            catch (Error e) {
                this.warn("sendAuthDataRequest({})[{}] failed ({}) to get next key: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
                throw new RuntimeSshException(e);
            }
            this.chosenAlgorithm = null;
            if (this.current == null) {
                if (debugEnabled) {
                    this.log.debug("resolveAttemptedPublicKeyIdentity({})[{}] no more keys to send", (Object)session, (Object)service);
                }
                if (reporter != null) {
                    reporter.signalAuthenticationExhausted(session, service);
                }
                return false;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendAuthDataRequest({})[{}] current key details: {}", session, service, this.current);
        }
        try {
            keyPair = this.current.getKeyIdentity();
        }
        catch (Error e) {
            this.warn("sendAuthDataRequest({})[{}] failed ({}) to retrieve key identity: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        PublicKey pubKey = keyPair.getPublic();
        if (currentAlgorithm == null) {
            String keyType = KeyUtils.getKeyType(pubKey);
            TreeSet<String> aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            aliases.addAll(KeyUtils.getAllEquivalentKeyTypes(keyType));
            aliases.add(keyType);
            List<NamedFactory<Signature>> existingFactories = this.current instanceof SignatureFactoriesHolder ? ((SignatureFactoriesHolder)((Object)this.current)).getSignatureFactories() : this.getSignatureFactories();
            if (existingFactories != null) {
                existingFactories.forEach(f -> {
                    if (aliases.contains(f.getName())) {
                        this.currentAlgorithms.add(f.getName());
                    }
                });
            }
            currentAlgorithm = this.currentAlgorithms.isEmpty() ? keyType : this.currentAlgorithms.poll();
        }
        String name = this.getName();
        if (debugEnabled) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST request {} type={} - fingerprint={}", session, service, name, currentAlgorithm, KeyUtils.getFingerPrint(pubKey));
        }
        if (reporter != null) {
            reporter.signalAuthenticationAttempt(session, service, keyPair, currentAlgorithm);
        }
        this.chosenAlgorithm = currentAlgorithm;
        Buffer buffer = session.createBuffer((byte)50);
        buffer.putString(session.getUsername());
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(false);
        buffer.putString(currentAlgorithm);
        buffer.putPublicKey(pubKey);
        session.writePacket(buffer);
        return true;
    }

    protected PublicKeyIdentity resolveAttemptedPublicKeyIdentity(ClientSession session, String service) throws Exception {
        if (this.keys != null && this.keys.hasNext()) {
            return this.keys.next();
        }
        UserInteraction ui = session.getUserInteraction();
        if (ui == null || !ui.isInteractionAllowed(session)) {
            return null;
        }
        KeyPair kp = ui.resolveAuthPublicKeyIdentityAttempt(session);
        if (kp == null) {
            return null;
        }
        return new KeyPairIdentity(this, session, kp);
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        KeyPair keyPair;
        String name = this.getName();
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        try {
            keyPair = this.current.getKeyIdentity();
        }
        catch (Error e) {
            this.warn("processAuthDataRequest({})[{}][{}] failed ({}) to retrieve key identity: {}", session, service, name, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        PublicKey pubKey = keyPair.getPublic();
        String rspKeyType = buffer.getString();
        PublicKey rspKey = buffer.getPublicKey();
        if (debugEnabled) {
            this.log.debug("processAuthDataRequest({})[{}][{}] SSH_MSG_USERAUTH_PK_OK type={}, fingerprint={}", session, service, name, rspKeyType, KeyUtils.getFingerPrint(rspKey));
        }
        if (!KeyUtils.compareKeys(rspKey, pubKey)) {
            throw new InvalidKeySpecException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] mismatched " + rspKeyType + " keys: expected=" + KeyUtils.getFingerPrint(pubKey) + ", actual=" + KeyUtils.getFingerPrint(rspKey));
        }
        if (!this.chosenAlgorithm.equalsIgnoreCase(rspKeyType)) {
            this.log.warn("processAuthDataRequest({})[{}][{}] sent algorithm {} but got back {} from {}", session, service, name, this.chosenAlgorithm, rspKeyType, session.getServerVersion());
        }
        String username = session.getUsername();
        String algo = this.chosenAlgorithm;
        buffer = session.createBuffer((byte)50, GenericUtils.length(username) + GenericUtils.length(service) + GenericUtils.length(name) + GenericUtils.length(algo) + 256 + 64);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(true);
        buffer.putString(algo);
        buffer.putPublicKey(pubKey);
        if (debugEnabled) {
            this.log.debug("processAuthDataRequest({})[{}][{}]: signing with algorithm {}", session, service, name, algo);
        }
        byte[] sig = this.appendSignature(session, service, name, username, algo, pubKey, buffer);
        PublicKeyAuthenticationReporter reporter = session.getPublicKeyAuthenticationReporter();
        if (reporter != null) {
            reporter.signalSignatureAttempt(session, service, keyPair, algo, sig);
        }
        session.writePacket(buffer);
        return true;
    }

    protected byte[] appendSignature(ClientSession session, String service, String name, String username, String algo, PublicKey key, Buffer buffer) throws Exception {
        byte[] sig;
        byte[] id = session.getSessionId();
        ByteArrayBuffer bs = new ByteArrayBuffer(id.length + username.length() + service.length() + name.length() + algo.length() + 256 + 64, false);
        bs.putBytes(id);
        ((Buffer)bs).putByte((byte)50);
        bs.putString(username);
        bs.putString(service);
        bs.putString(name);
        bs.putBoolean(true);
        bs.putString(algo);
        bs.putPublicKey(key);
        byte[] contents = bs.getCompactData();
        try {
            Map.Entry<String, byte[]> result = this.current.sign(session, algo, contents);
            String factoryName = result.getKey();
            ValidateUtils.checkState(algo.equalsIgnoreCase(factoryName), "Mismatched signature type generated: requested=%s, used=%s", algo, factoryName);
            sig = result.getValue();
        }
        catch (Error e) {
            this.warn("appendSignature({})[{}][{}] failed ({}) to sign contents using {}: {}", session, service, name, e.getClass().getSimpleName(), algo, e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - verification data={}", session, service, name, algo, KeyUtils.getFingerPrint(key), BufferUtils.toHex(contents));
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - generated signature={}", session, service, name, algo, KeyUtils.getFingerPrint(key), BufferUtils.toHex(sig));
        }
        bs.clear();
        bs.putString(algo);
        bs.putBytes(sig);
        buffer.putBytes(((Buffer)bs).array(), ((Buffer)bs).rpos(), bs.available());
        return sig;
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession session, String service, Buffer buffer) throws Exception {
        PublicKeyAuthenticationReporter reporter = session.getPublicKeyAuthenticationReporter();
        if (reporter != null) {
            reporter.signalAuthenticationSuccess(session, service, this.current == null ? null : this.current.getKeyIdentity());
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession session, String service, boolean partial, List<String> serverMethods, Buffer buffer) throws Exception {
        PublicKeyAuthenticationReporter reporter = session.getPublicKeyAuthenticationReporter();
        if (reporter != null) {
            KeyPair identity = this.current == null ? null : this.current.getKeyIdentity();
            reporter.signalAuthenticationFailure(session, service, identity, partial, serverMethods);
        }
    }

    @Override
    public void destroy() {
        try {
            this.releaseKeys();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed (" + e.getClass().getSimpleName() + ") to close agent: " + e.getMessage(), e);
        }
        super.destroy();
    }

    protected void releaseKeys() throws IOException {
        this.currentAlgorithms.clear();
        this.current = null;
        this.chosenAlgorithm = null;
        try {
            if (this.keys instanceof Closeable) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("releaseKeys({}) closing {}", (Object)this.getClientSession(), (Object)this.keys);
                }
                ((Closeable)((Object)this.keys)).close();
            }
        }
        finally {
            this.keys = null;
        }
    }
}

