/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kafka010.CacheKey;
import org.apache.spark.streaming.kafka010.InternalKafkaConsumer;
import org.apache.spark.streaming.kafka010.KafkaDataConsumer;
import org.apache.spark.streaming.kafka010.KafkaDataConsumer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class KafkaDataConsumer$
implements Logging {
    public static final KafkaDataConsumer$ MODULE$;
    private Map<CacheKey, InternalKafkaConsumer<?, ?>> cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KafkaDataConsumer$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Map<CacheKey, InternalKafkaConsumer<?, ?>> cache() {
        return this.cache;
    }

    public void cache_$eq(Map<CacheKey, InternalKafkaConsumer<?, ?>> x$1) {
        this.cache = x$1;
    }

    public synchronized void init(int initialCapacity, int maxCapacity, float loadFactor) {
        if (this.cache() == null) {
            this.logInfo((Function0<String>)((Object)new Serializable(initialCapacity, maxCapacity, loadFactor){
                public static final long serialVersionUID = 0L;
                private final int initialCapacity$1;
                private final int maxCapacity$1;
                private final float loadFactor$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing cache ", " ", " ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.initialCapacity$1), BoxesRunTime.boxToInteger(this.maxCapacity$1), BoxesRunTime.boxToFloat(this.loadFactor$1)}));
                }
                {
                    this.initialCapacity$1 = initialCapacity$1;
                    this.maxCapacity$1 = maxCapacity$1;
                    this.loadFactor$1 = loadFactor$1;
                }
            }));
            this.cache_$eq(new LinkedHashMap<CacheKey, InternalKafkaConsumer<?, ?>>(initialCapacity, maxCapacity, loadFactor){
                public final int maxCapacity$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean removeEldestEntry(Map.Entry<CacheKey, InternalKafkaConsumer<?, ?>> entry) {
                    if (entry.getValue().inUse()) return false;
                    if (this.size() <= this.maxCapacity$1) return false;
                    KafkaDataConsumer$.MODULE$.logWarning((Function0<String>)((Object)new Serializable(this, entry){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.1 $outer;
                        private final Map.Entry entry$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaConsumer cache hitting max capacity of ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.maxCapacity$1)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing consumer for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.entry$1.getKey()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.entry$1 = entry$1;
                        }
                    }));
                    try {
                        entry.getValue().close();
                        return true;
                    }
                    catch (KafkaException kafkaException) {
                        KafkaDataConsumer$.MODULE$.logError((Function0<String>)((Object)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Error closing oldest Kafka consumer";
                            }
                        }), kafkaException);
                    }
                    return true;
                }
                {
                    this.maxCapacity$1 = maxCapacity$1;
                    super(initialCapacity$1, loadFactor$1, true);
                }
            });
        }
    }

    public synchronized <K, V> KafkaDataConsumer<K, V> acquire(TopicPartition topicPartition, Map<String, Object> kafkaParams, TaskContext context, boolean useCache) {
        Serializable serializable;
        ObjectRef<Object> newInternalConsumer$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String groupId = (String)kafkaParams.get("group.id");
        CacheKey key = new CacheKey(groupId, topicPartition);
        InternalKafkaConsumer<?, ?> existingInternalConsumer = this.cache().get(key);
        if (context != null && context.attemptNumber() >= 1) {
            Object object;
            this.logDebug((Function0<String>)((Object)new Serializable(existingInternalConsumer){
                public static final long serialVersionUID = 0L;
                private final InternalKafkaConsumer existingInternalConsumer$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reattempt detected, invalidating cached consumer ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.existingInternalConsumer$1}));
                }
                {
                    this.existingInternalConsumer$1 = existingInternalConsumer$1;
                }
            }));
            if (existingInternalConsumer == null) {
                object = BoxedUnit.UNIT;
            } else if (existingInternalConsumer.inUse()) {
                existingInternalConsumer.markedForClose_$eq(true);
                object = BoxedUnit.UNIT;
            } else {
                existingInternalConsumer.close();
                object = this.cache().remove(key);
            }
            this.logDebug((Function0<String>)((Object)new Serializable(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Map kafkaParams$1;
                private final ObjectRef newInternalConsumer$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Reattempt detected, new non-cached consumer will be allocated ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{KafkaDataConsumer$.MODULE$.org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(this.topicPartition$1, this.kafkaParams$1, this.newInternalConsumer$lzy$1, this.bitmap$0$1)}))).toString();
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.kafkaParams$1 = kafkaParams$1;
                    this.newInternalConsumer$lzy$1 = newInternalConsumer$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }));
            serializable = new KafkaDataConsumer.NonCachedKafkaDataConsumer(this.org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
        } else if (useCache) {
            if (existingInternalConsumer == null) {
                this.logDebug((Function0<String>)((Object)new Serializable(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;
                    private final Map kafkaParams$1;
                    private final ObjectRef newInternalConsumer$lzy$1;
                    private final VolatileByteRef bitmap$0$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"No cached consumer, new cached consumer will be allocated ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{KafkaDataConsumer$.MODULE$.org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(this.topicPartition$1, this.kafkaParams$1, this.newInternalConsumer$lzy$1, this.bitmap$0$1)}))).toString();
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                        this.kafkaParams$1 = kafkaParams$1;
                        this.newInternalConsumer$lzy$1 = newInternalConsumer$lzy$1;
                        this.bitmap$0$1 = bitmap$0$1;
                    }
                }));
                this.cache().put(key, this.org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
                serializable = new KafkaDataConsumer.CachedKafkaDataConsumer(this.org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
            } else if (existingInternalConsumer.inUse()) {
                this.logDebug((Function0<String>)((Object)new Serializable(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;
                    private final Map kafkaParams$1;
                    private final ObjectRef newInternalConsumer$lzy$1;
                    private final VolatileByteRef bitmap$0$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Used cached consumer found, new non-cached consumer will be allocated ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{KafkaDataConsumer$.MODULE$.org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(this.topicPartition$1, this.kafkaParams$1, this.newInternalConsumer$lzy$1, this.bitmap$0$1)}))).toString();
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                        this.kafkaParams$1 = kafkaParams$1;
                        this.newInternalConsumer$lzy$1 = newInternalConsumer$lzy$1;
                        this.bitmap$0$1 = bitmap$0$1;
                    }
                }));
                serializable = new KafkaDataConsumer.NonCachedKafkaDataConsumer(this.org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
            } else {
                this.logDebug((Function0<String>)((Object)new Serializable(existingInternalConsumer){
                    public static final long serialVersionUID = 0L;
                    private final InternalKafkaConsumer existingInternalConsumer$1;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not used cached consumer found, re-using it ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.existingInternalConsumer$1}));
                    }
                    {
                        this.existingInternalConsumer$1 = existingInternalConsumer$1;
                    }
                }));
                existingInternalConsumer.inUse_$eq(true);
                serializable = new KafkaDataConsumer.CachedKafkaDataConsumer(existingInternalConsumer);
            }
        } else {
            this.logDebug((Function0<String>)((Object)new Serializable(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Map kafkaParams$1;
                private final ObjectRef newInternalConsumer$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cache usage turned off, new non-cached consumer will be allocated ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{KafkaDataConsumer$.MODULE$.org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(this.topicPartition$1, this.kafkaParams$1, this.newInternalConsumer$lzy$1, this.bitmap$0$1)}))).toString();
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.kafkaParams$1 = kafkaParams$1;
                    this.newInternalConsumer$lzy$1 = newInternalConsumer$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }));
            serializable = new KafkaDataConsumer.NonCachedKafkaDataConsumer(this.org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
        }
        return serializable;
    }

    public void org$apache$spark$streaming$kafka010$KafkaDataConsumer$$release(InternalKafkaConsumer<?, ?> internalConsumer) {
        KafkaDataConsumer$ kafkaDataConsumer$ = this;
        synchronized (kafkaDataConsumer$) {
            Object object;
            CacheKey key = new CacheKey(internalConsumer.groupId(), internalConsumer.topicPartition());
            InternalKafkaConsumer<?, ?> cachedInternalConsumer = this.cache().get(key);
            if (internalConsumer == cachedInternalConsumer) {
                if (internalConsumer.markedForClose()) {
                    internalConsumer.close();
                    object = this.cache().remove(key);
                } else {
                    internalConsumer.inUse_$eq(false);
                    object = BoxedUnit.UNIT;
                }
            } else {
                internalConsumer.close();
                this.logInfo((Function0<String>)((Object)new Serializable(internalConsumer){
                    public static final long serialVersionUID = 0L;
                    private final InternalKafkaConsumer internalConsumer$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Released a supposedly cached consumer that was not found in the cache "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.internalConsumer$1}))).toString();
                    }
                    {
                        this.internalConsumer$1 = internalConsumer$1;
                    }
                }));
                object = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private final InternalKafkaConsumer newInternalConsumer$lzycompute$1(TopicPartition topicPartition$1, Map kafkaParams$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        KafkaDataConsumer$ kafkaDataConsumer$ = this;
        synchronized (kafkaDataConsumer$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                newInternalConsumer$lzy$1.elem = new InternalKafkaConsumer(topicPartition$1, kafkaParams$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (InternalKafkaConsumer)newInternalConsumer$lzy$1.elem;
        }
    }

    public final InternalKafkaConsumer org$apache$spark$streaming$kafka010$KafkaDataConsumer$$newInternalConsumer$1(TopicPartition topicPartition$1, Map kafkaParams$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.newInternalConsumer$lzycompute$1(topicPartition$1, kafkaParams$1, newInternalConsumer$lzy$1, bitmap$0$1) : (InternalKafkaConsumer)newInternalConsumer$lzy$1.elem;
    }

    private KafkaDataConsumer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.cache = null;
    }
}

