/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.CanCommitOffsets;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.DirectKafkaInputDStream$;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.OffsetRange$;
import org.apache.spark.streaming.kafka010.PerPartitionConfig;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$DoubleIsFractional$;
import scala.math.Numeric$LongIsIntegral$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}f!B\u0001\u0003\u0001\u0019a!a\u0006#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014x-F\u0002\u000eA9\u001aB\u0001\u0001\b1mA\u0019qB\u0005\u000b\u000e\u0003AQ!!\u0005\u0003\u0002\u000f\u0011\u001cHO]3b[&\u00111\u0003\u0005\u0002\r\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0005+qqR&D\u0001\u0017\u0015\t9\u0002$\u0001\u0005d_:\u001cX/\\3s\u0015\tI\"$A\u0004dY&,g\u000e^:\u000b\u0005mA\u0011!B6bM.\f\u0017BA\u000f\u0017\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0004\"a\b\u0011\r\u0001\u0011)\u0011\u0005\u0001b\u0001G\t\t1j\u0001\u0001\u0012\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#a\u0002(pi\"Lgn\u001a\t\u0003K-J!\u0001\f\u0014\u0003\u0007\u0005s\u0017\u0010\u0005\u0002 ]\u0011)q\u0006\u0001b\u0001G\t\ta\u000b\u0005\u00022i5\t!G\u0003\u00024\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0007CA\u001c9\u001b\u0005\u0011\u0011BA\u001d\u0003\u0005A\u0019\u0015M\\\"p[6LGo\u00144gg\u0016$8\u000f\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0003\u0011y6o]2\u0011\u0005urT\"\u0001\u0003\n\u0005}\"!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0015\u0001\u00057pG\u0006$\u0018n\u001c8TiJ\fG/Z4z!\t94)\u0003\u0002E\u0005\t\u0001Bj\\2bi&|gn\u0015;sCR,w-\u001f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\u0006\u00012m\u001c8tk6,'o\u0015;sCR,w-\u001f\t\u0005o!sR&\u0003\u0002J\u0005\t\u00012i\u001c8tk6,'o\u0015;sCR,w-\u001f\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\u0006\u0019\u0001\u000f]2\u0011\u0005]j\u0015B\u0001(\u0003\u0005I\u0001VM\u001d)beRLG/[8o\u0007>tg-[4\t\u000bA\u0003A\u0011A)\u0002\rqJg.\u001b;?)\u0015\u00116\u000bV+W!\u00119\u0004AH\u0017\t\u000bmz\u0005\u0019\u0001\u001f\t\u000b\u0005{\u0005\u0019\u0001\"\t\u000b\u0019{\u0005\u0019A$\t\u000b-{\u0005\u0019\u0001'\t\u000fa\u0003!\u0019!C\u00053\u0006Y\u0011N\\5uS\u0006d'+\u0019;f+\u0005Q\u0006CA\u0013\\\u0013\tafE\u0001\u0003M_:<\u0007B\u00020\u0001A\u0003%!,\u0001\u0007j]&$\u0018.\u00197SCR,\u0007\u0005C\u0004a\u0001\t\u0007I\u0011A1\u0002'\u0015DXmY;u_J\\\u0015MZ6b!\u0006\u0014\u0018-\\:\u0016\u0003\t\u0004Ba\u00195kc6\tAM\u0003\u0002fM\u0006!Q\u000f^5m\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\u000f!\u000b7\u000f['baB\u00111N\u001c\b\u0003K1L!!\u001c\u0014\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[\u001a\u0002\"A];\u000e\u0003MT!\u0001\u001e4\u0002\t1\fgnZ\u0005\u0003mN\u0014aa\u00142kK\u000e$\bB\u0002=\u0001A\u0003%!-\u0001\u000bfq\u0016\u001cW\u000f^8s\u0017\u000647.\u0019)be\u0006l7\u000f\t\u0005\bu\u0002\u0001\r\u0011\"\u0005|\u00039\u0019WO\u001d:f]R|eMZ:fiN,\u0012\u0001 \t\u0007{\u0006\u0015\u0011\u0011\u0002.\u000e\u0003yT1a`A\u0001\u0003%IW.\\;uC\ndWMC\u0002\u0002\u0004\u0019\n!bY8mY\u0016\u001cG/[8o\u0013\r\t9A \u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=!$\u0001\u0004d_6lwN\\\u0005\u0005\u0003'\tiA\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0013\u0005]\u0001\u00011A\u0005\u0012\u0005e\u0011AE2veJ,g\u000e^(gMN,Go]0%KF$B!a\u0007\u0002\"A\u0019Q%!\b\n\u0007\u0005}aE\u0001\u0003V]&$\b\"CA\u0012\u0003+\t\t\u00111\u0001}\u0003\rAH%\r\u0005\b\u0003O\u0001\u0001\u0015)\u0003}\u0003=\u0019WO\u001d:f]R|eMZ:fiN\u0004\u0003\"CA\u0016\u0001\u0001\u0007I\u0011BA\u0017\u0003\tY7-\u0006\u0002\u00020A)Q#!\r\u001f[%\u0019\u00111\u0007\f\u0003\u0011\r{gn];nKJD\u0011\"a\u000e\u0001\u0001\u0004%I!!\u000f\u0002\r-\u001cw\fJ3r)\u0011\tY\"a\u000f\t\u0015\u0005\r\u0012QGA\u0001\u0002\u0004\ty\u0003\u0003\u0005\u0002@\u0001\u0001\u000b\u0015BA\u0018\u0003\rY7\r\t\u0015\u0005\u0003{\t\u0019\u0005E\u0002&\u0003\u000bJ1!a\u0012'\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0004\u0018\u0001\u0011\u0005\u00111\n\u000b\u0003\u0003_Aq!a\u0014\u0001\t\u0003\n\t&A\u0004qKJ\u001c\u0018n\u001d;\u0015\t\u0005M\u0013\u0011\f\t\u0005\u001f\u0005UC#C\u0002\u0002XA\u0011q\u0001R*ue\u0016\fW\u000e\u0003\u0005\u0002\\\u00055\u0003\u0019AA/\u0003!qWm\u001e'fm\u0016d\u0007\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rd!A\u0004ti>\u0014\u0018mZ3\n\t\u0005\u001d\u0014\u0011\r\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u0005\b\u0003W\u0002A\u0011CA7\u0003)9W\r\u001e\"s_.,'o]\u000b\u0003\u0003_\u0002Ra\u00195\u0002\n)Dq!a\u001d\u0001\t#\t)(A\thKR\u0004&/\u001a4feJ,G\rS8tiN,\"!a\u001e\u0011\r\r\fI(!\u0003k\u0013\r\t9\u0001\u001a\u0005\t\u0003{\u0002A\u0011\t\u0003\u0002\u0000\u0005!a.Y7f+\u0005Q\u0007BCAB\u0001\t\u0007I\u0011\u000b\u0003\u0002\u0006\u0006q1\r[3dWB|\u0017N\u001c;ECR\fWCAAD!\u0011\tI)a#\u000e\u0003\u00011q!!$\u0001\u0001\u0011\tyIA\u0013ESJ,7\r^&bM.\f\u0017J\u001c9vi\u0012\u001bFO]3b[\u000eCWmY6q_&tG\u000fR1uCN!\u00111RAI!\u0011y\u00111\u0013\u000b\n\u0007\u0005U\u0005CA\u000bE'R\u0014X-Y7DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\t\u000fA\u000bY\t\"\u0001\u0002\u001aR\u0011\u0011q\u0011\u0005\t\u0003;\u000bY\t\"\u0001\u0002 \u0006a!-\u0019;dQ\u001a{'\u000fV5nKV\u0011\u0011\u0011\u0015\t\t\u0003G\u000bI+a+\u000226\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000b\t!A\u0004nkR\f'\r\\3\n\u0007%\f)\u000bE\u0002>\u0003[K1!a,\u0005\u0005\u0011!\u0016.\\3\u0011\u000b\u0015\n\u0019,a.\n\u0007\u0005UfEA\u0003BeJ\f\u0017\u0010\u0005\u0005&\u0003sS\u0017Q\u0018.[\u0013\r\tYL\n\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u0007\u0015\ny,C\u0002\u0002B\u001a\u00121!\u00138u\u0011!\t)-a#\u0005B\u0005\u001d\u0017AB;qI\u0006$X\r\u0006\u0003\u0002\u001c\u0005%\u0007\u0002CAf\u0003\u0007\u0004\r!a+\u0002\tQLW.\u001a\u0005\t\u0003\u001f\fY\t\"\u0011\u0002R\u000691\r\\3b]V\u0004H\u0003BA\u000e\u0003'D\u0001\"a3\u0002N\u0002\u0007\u00111\u0016\u0005\t\u0003/\fY\t\"\u0011\u0002Z\u00069!/Z:u_J,GCAA\u000e\u0011!\ti\u000e\u0001Q\u0001\n\u0005\u001d\u0015aD2iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u0011\t\u0015\u0005\u0005\bA1A\u0005R\u0011\t\u0019/\u0001\bsCR,7i\u001c8ue>dG.\u001a:\u0016\u0005\u0005\u0015\b#B\u0013\u0002h\u0006-\u0018bAAuM\t1q\n\u001d;j_:\u0004B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0004\u0003c$\u0011!C:dQ\u0016$W\u000f\\3s\u0013\u0011\t)0a<\u0003\u001dI\u000bG/Z\"p]R\u0014x\u000e\u001c7fe\"A\u0011\u0011 \u0001!\u0002\u0013\t)/A\bsCR,7i\u001c8ue>dG.\u001a:!\u0011!\ti\u0010\u0001C\t\t\u0005}\u0018aF7bq6+7o]1hKN\u0004VM\u001d)beRLG/[8o)\u0011\u0011\tAa\u0002\u0011\u000b\u0015\n9Oa\u0001\u0011\r-\u0014)!!\u0003[\u0013\r\t9\u0001\u001d\u0005\t\u0005\u0013\tY\u00101\u0001\u0003\u0004\u00059qN\u001a4tKR\u001c\bb\u0002B\u0007\u0001\u0011%!qB\u0001\ra\u0006\u0014\u0018M\\8jIB{G\u000e\u001c\u000b\u0005\u00037\u0011\t\u0002\u0003\u0005\u0003\u0014\t-\u0001\u0019AA\u0018\u0003\u0005\u0019\u0007b\u0002B\f\u0001\u0011E!\u0011D\u0001\u000eY\u0006$Xm\u001d;PM\u001a\u001cX\r^:\u0015\u0005\t\r\u0001b\u0002B\u000f\u0001\u0011E!qD\u0001\u0006G2\fW\u000e\u001d\u000b\u0005\u0005\u0007\u0011\t\u0003\u0003\u0005\u0003\n\tm\u0001\u0019\u0001B\u0002\u0011\u001d\u0011)\u0003\u0001C!\u0005O\tqaY8naV$X\r\u0006\u0003\u0003*\tE\u0002#B\u0013\u0002h\n-\u0002#B\u001c\u0003.yi\u0013b\u0001B\u0018\u0005\tA1*\u00194lCJ#E\t\u0003\u0005\u00034\t\r\u0002\u0019AAV\u0003%1\u0018\r\\5e)&lW\rC\u0004\u00038\u0001!\t%!7\u0002\u000bM$\u0018M\u001d;\t\u000f\tm\u0002\u0001\"\u0011\u0002Z\u0006!1\u000f^8q\u0011%\u0011y\u0004\u0001b\u0001\n#\u0011\t%A\u0006d_6l\u0017\u000e^)vKV,WC\u0001B\"!\u0019\u0011)Ea\u0013\u0003P5\u0011!q\t\u0006\u0004\u0005\u0013\"\u0017AC2p]\u000e,(O]3oi&!!Q\nB$\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\u00042a\u000eB)\u0013\r\u0011\u0019F\u0001\u0002\f\u001f\u001a47/\u001a;SC:<W\r\u0003\u0005\u0003X\u0001\u0001\u000b\u0011\u0002B\"\u00031\u0019w.\\7jiF+X-^3!\u0011%\u0011Y\u0006\u0001b\u0001\n#\u0011i&\u0001\bd_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0016\u0005\t}\u0003C\u0002B1\u0005O\u0012Y'\u0004\u0002\u0003d)!!Q\rB$\u0003\u0019\tGo\\7jG&!!\u0011\u000eB2\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007cA\u000b\u0003n%\u0019!q\u000e\f\u0003)=3gm]3u\u0007>lW.\u001b;DC2d'-Y2l\u0011!\u0011\u0019\b\u0001Q\u0001\n\t}\u0013aD2p[6LGoQ1mY\n\f7m\u001b\u0011\t\u000f\t]\u0004\u0001\"\u0001\u0003z\u0005Y1m\\7nSR\f5/\u001f8d)\u0011\tYBa\u001f\t\u0011\tu$Q\u000fa\u0001\u0005\u007f\nAb\u001c4gg\u0016$(+\u00198hKN\u0004R!JAZ\u0005\u001fBqAa\u001e\u0001\t\u0003\u0011\u0019\t\u0006\u0004\u0002\u001c\t\u0015%q\u0011\u0005\t\u0005{\u0012\t\t1\u0001\u0003\u0000!A!\u0011\u0012BA\u0001\u0004\u0011Y'\u0001\u0005dC2d'-Y2l\u0011\u001d\u0011i\t\u0001C\t\u00033\f\u0011bY8n[&$\u0018\t\u001c7\u0007\u000f\tE\u0005\u0001\u0001\u0003\u0003\u0014\nIB)\u001b:fGR\\\u0015MZ6b%\u0006$XmQ8oiJ|G\u000e\\3s'\u0011\u0011y)a;\t\u001b\t]%q\u0012B\u0001B\u0003%\u0011Q\u0018BM\u0003\tIG-\u0003\u0003\u0003\u001c\u0006M\u0018!C:ue\u0016\fW.V%E\u0011-\u0011yJa$\u0003\u0002\u0003\u0006IA!)\u0002\u0013\u0015\u001cH/[7bi>\u0014\b\u0003\u0002BR\u0005Sk!A!*\u000b\t\t\u001d\u0016q^\u0001\u0005e\u0006$X-\u0003\u0003\u0003,\n\u0015&!\u0004*bi\u0016,5\u000f^5nCR|'\u000fC\u0004Q\u0005\u001f#\tAa,\u0015\r\tE&1\u0017B[!\u0011\tIIa$\t\u0011\t]%Q\u0016a\u0001\u0003{C\u0001Ba(\u0003.\u0002\u0007!\u0011\u0015\u0005\t\u0005s\u0013y\t\"\u0011\u0003<\u00069\u0001/\u001e2mSNDG\u0003BA\u000e\u0005{CqAa*\u00038\u0002\u0007!\f")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    public final PerPartitionConfig org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$ppc;
    private final long org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$initialRate;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    public long org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$initialRate() {
        return this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$initialRate;
    }

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        if (this.kc() == null) {
            this.kc_$eq(this.consumerStrategy.onStart(JavaConverters$.MODULE$.mapAsJavaMapConverter(this.currentOffsets().mapValues(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Long apply(long l) {
                    return new Long(l);
                }
            })).asJava()));
        }
        return this.kc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        }));
        return super.persist(newLevel);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<TopicPartition, String> getBrokers() {
        void var2_2;
        Consumer<K, V> c = this.consumer();
        HashMap result2 = new HashMap();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result2.put(tp, hosts.get(tp));
        }
        return var2_2;
    }

    public Map<TopicPartition, String> getPreferredHosts() {
        LocationStrategy locationStrategy;
        block5: {
            Map<TopicPartition, String> map2;
            block3: {
                block4: {
                    block2: {
                        locationStrategy = this.locationStrategy;
                        if (!PreferBrokers$.MODULE$.equals(locationStrategy)) break block2;
                        map2 = this.getBrokers();
                        break block3;
                    }
                    if (!PreferConsistent$.MODULE$.equals(locationStrategy)) break block4;
                    map2 = Collections.emptyMap();
                    break block3;
                }
                if (!(locationStrategy instanceof PreferFixed)) break block5;
                PreferFixed preferFixed = (PreferFixed)locationStrategy;
                Map<TopicPartition, String> hostMap = preferFixed.hostMap();
                map2 = hostMap;
            }
            return map2;
        }
        throw new MatchError(locationStrategy);
    }

    public String name() {
        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kafka 0.10 direct stream [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.id())}));
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        Option<Object> option;
        block7: {
            Option option2;
            scala.collection.immutable.Map map2;
            block6: {
                block5: {
                    Option<Object> estimatedRateLimit = this.rateController().map(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;

                        public final long apply(RateController x) {
                            long lr = x.getLatestRate();
                            return lr > 0L ? lr : this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$initialRate();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    option = estimatedRateLimit.filter((Function1<Object, Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(long x$1) {
                            return this.apply$mcZJ$sp(x$1);
                        }

                        public boolean apply$mcZJ$sp(long x$1) {
                            return x$1 > 0L;
                        }
                    }));
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    long rate = BoxesRunTime.unboxToLong(some.x());
                    scala.collection.immutable.Map lagPerPartition = offsets.map((Function1<TopicPartition, Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$1) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                TopicPartition tp = tuple2._1();
                                long offset = tuple2._2$mcJ$sp();
                                Tuple2<TopicPartition, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToLong(Math.max(offset - BoxesRunTime.unboxToLong(this.$outer.currentOffsets().apply(tp)), 0L)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }), Map$.MODULE$.canBuildFrom());
                    long totalLag = BoxesRunTime.unboxToLong(lagPerPartition.values().sum(Numeric$LongIsIntegral$.MODULE$));
                    map2 = lagPerPartition.map(new Serializable(this, rate, totalLag){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;
                        private final long rate$1;
                        private final long totalLag$1;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$2) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                TopicPartition tp = tuple2._1();
                                long lag = tuple2._2$mcJ$sp();
                                long maxRateLimitPerPartition = this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$ppc.maxRatePerPartition(tp);
                                double backpressureRate = (double)lag / (double)this.totalLag$1 * (double)this.rate$1;
                                Tuple2<TopicPartition, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), maxRateLimitPerPartition > 0L ? BoxesRunTime.boxToDouble(Math.min(backpressureRate, (double)maxRateLimitPerPartition)) : BoxesRunTime.boxToDouble(backpressureRate));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rate$1 = rate$1;
                            this.totalLag$1 = totalLag$1;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                map2 = offsets.map((Function1<TopicPartition, Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DirectKafkaInputDStream $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$3) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition tp = tuple2._1();
                            Tuple2<TopicPartition, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToDouble(this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$ppc.maxRatePerPartition(tp)));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }), Map$.MODULE$.canBuildFrom());
            }
            scala.collection.immutable.Map effectiveRateLimitPerPartition = map2;
            if (BoxesRunTime.unboxToDouble(effectiveRateLimitPerPartition.values().sum(Numeric$DoubleIsFractional$.MODULE$)) > 0.0) {
                double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
                option2 = new Some(effectiveRateLimitPerPartition.map(new Serializable(this, secsPerBatch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DirectKafkaInputDStream $outer;
                    private final double secsPerBatch$1;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$4) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition tp = tuple2._1();
                            double limit = tuple2._2$mcD$sp();
                            Tuple2<TopicPartition, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToLong(Math.max((long)(this.secsPerBatch$1 * limit), this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$ppc.minRatePerPartition(tp))));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.secsPerBatch$1 = secsPerBatch$1;
                    }
                }, Map$.MODULE$.canBuildFrom()));
            } else {
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    private void paranoidPoll(Consumer<K, V> c) {
        c.pause(c.assignment());
        ConsumerRecords<K, V> msgs = c.poll(0L);
        if (!msgs.isEmpty()) {
            ((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(msgs).asScala()).foldLeft(Predef$.MODULE$.Map().apply(Nil$.MODULE$), new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Map<TopicPartition, Object> apply(scala.collection.immutable.Map<TopicPartition, Object> acc, ConsumerRecord<K, V> m) {
                    TopicPartition tp = new TopicPartition(m.topic(), m.partition());
                    long off = BoxesRunTime.unboxToLong(acc.get(tp).map(new Serializable(this, m){
                        public static final long serialVersionUID = 0L;
                        private final ConsumerRecord m$1;

                        public final long apply(long o) {
                            return this.apply$mcJJ$sp(o);
                        }

                        public long apply$mcJJ$sp(long o) {
                            return Math.min(o, this.m$1.offset());
                        }
                        {
                            this.m$1 = m$1;
                        }
                    }).getOrElse(new Serializable(this, m){
                        public static final long serialVersionUID = 0L;
                        private final ConsumerRecord m$1;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return this.m$1.offset();
                        }
                        {
                            this.m$1 = m$1;
                        }
                    }));
                    return acc.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToLong(off)));
                }
            })).foreach(new Serializable(this, c){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStream $outer;
                private final Consumer c$1;

                public final void apply(Tuple2<TopicPartition, Object> x0$5) {
                    Tuple2<TopicPartition, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        TopicPartition tp = tuple2._1();
                        long off = tuple2._2$mcJ$sp();
                        this.$outer.logInfo((Function0)((Object)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final TopicPartition tp$1;
                            private final long off$1;

                            public final String apply() {
                                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"poll(0) returned messages, seeking ", " to ", " to compensate"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.tp$1, BoxesRunTime.boxToLong(this.off$1)}));
                            }
                            {
                                this.tp$1 = tp$1;
                                this.off$1 = off$1;
                            }
                        }));
                        this.c$1.seek(tp, off);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.c$1 = c$1;
                }
            });
        }
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        Consumer<K, V> c = this.consumer();
        this.paranoidPoll(c);
        Set<TopicPartition> parts = JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala();
        Set newPartitions = (Set)parts.diff(this.currentOffsets().keySet());
        scala.collection.immutable.Set revokedPartitions = (scala.collection.immutable.Set)this.currentOffsets().keySet().diff(parts);
        if (revokedPartitions.nonEmpty()) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Previously tracked partitions "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " been revoked by Kafka because of consumer "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{revokedPartitions.mkString("[", ",", "]")}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rebalance. This is mostly due to another stream with same group id joined, "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"please check if there're different streaming application misconfigure to use same "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"group id. Fundamentally different stream should use different group id"})).s(Nil$.MODULE$)).toString());
        }
        this.currentOffsets_$eq(this.currentOffsets().$plus$plus(((TraversableOnce)newPartitions.map(new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final Consumer c$2;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToLong(this.c$2.position(tp)));
            }
            {
                this.c$2 = c$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
        c.seekToEnd(JavaConverters$.MODULE$.setAsJavaSetConverter(this.currentOffsets().keySet()).asJava());
        return ((TraversableOnce)parts.map(new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final Consumer c$2;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToLong(this.c$2.position(tp)));
            }
            {
                this.c$2 = c$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return this.maxMessagesPerPartition(offsets).map(new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;
            public final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(scala.collection.immutable.Map<TopicPartition, Object> mmp) {
                return mmp.map((Function1<TopicPartition, Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$clamp$1 $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$6) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$6;
                        if (tuple2 != null) {
                            TopicPartition tp = tuple2._1();
                            long messages = tuple2._2$mcJ$sp();
                            long uo = BoxesRunTime.unboxToLong(this.$outer.offsets$1.apply(tp));
                            Tuple2<TopicPartition, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToLong(Math.min(BoxesRunTime.unboxToLong(this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$anonfun$$$outer().currentOffsets().apply(tp)) + messages, uo)));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }), Map$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsets$1 = offsets$1;
            }
        }).getOrElse(new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply() {
                return this.offsets$1;
            }
            {
                this.offsets$1 = offsets$1;
            }
        });
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable<OffsetRange> offsetRanges = untilOffsets.map((Function1<TopicPartition, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;

            public final OffsetRange apply(Tuple2<TopicPartition, Object> x0$7) {
                Tuple2<TopicPartition, Object> tuple2 = x0$7;
                if (tuple2 != null) {
                    TopicPartition tp = tuple2._1();
                    long uo = tuple2._2$mcJ$sp();
                    long fo = BoxesRunTime.unboxToLong(this.$outer.currentOffsets().apply(tp));
                    OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
                    return offsetRange;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), Iterable$.MODULE$.canBuildFrom());
        boolean useConsumerCache = this.context().conf().getBoolean("spark.streaming.kafka.consumer.cache.enabled", true);
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), useConsumerCache);
        String description = ((TraversableOnce)((TraversableLike)offsetRanges.filter((Function1<OffsetRange, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OffsetRange offsetRange) {
                return offsetRange.fromOffset() != offsetRange.untilOffset();
            }
        }))).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(OffsetRange offsetRange) {
                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic: ", "\\tpartition: ", "\\t"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{offsetRange.topic(), BoxesRunTime.boxToInteger(offsetRange.partition())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offsets: ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(offsetRange.fromOffset()), BoxesRunTime.boxToLong(offsetRange.untilOffset())}))).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("offsets"), offsetRanges.toList()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        Consumer<K, V> c = this.consumer();
        this.paranoidPoll(c);
        if (this.currentOffsets().isEmpty()) {
            this.currentOffsets_$eq(((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map(new Serializable(this, c){
                public static final long serialVersionUID = 0L;
                private final Consumer c$3;

                public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToLong(this.c$3.position(tp)));
                }
                {
                    this.c$3 = c$3;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
    }

    public synchronized void stop() {
        if (this.kc() != null) {
            this.kc().close();
        }
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
        OffsetRange osr = this.commitQueue().poll();
        while (true) {
            if (osr == null) {
                if (!m.isEmpty()) {
                    this.consumer().commitAsync(m, this.commitCallback().get());
                }
                return;
            }
            TopicPartition tp = osr.topicPartition();
            OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
            long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
            m.put(tp, new OffsetAndMetadata(offset));
            osr = this.commitQueue().poll();
        }
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig ppc) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$ppc = ppc;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$initialRate = this.context().sparkContext().getConf().getLong("spark.streaming.backpressure.initialRate", 0L);
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(Nil$.MODULE$);
        this.kc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some<DirectKafkaRateController>(new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> apply(Tuple2<Time, RDD<ConsumerRecord<K, V>>> kv) {
                    Tuple4[] a = (Tuple4[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges()).map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple4<String, Object, Object, Object> apply(OffsetRange x$2) {
                            return x$2.toTuple();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                    return this.$outer.batchForTime().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), a));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Time apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x$3) {
                    return x$3._1();
                }
            }, Time$.MODULE$.ordering())).foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.HashMap<Time, RDD<ConsumerRecord<K, V>>> apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x0$8) {
                    Tuple2<Time, Tuple4<String, Object, Object, Object>[]> tuple2 = x0$8;
                    if (tuple2 != null) {
                        Time t = tuple2._1();
                        Tuple4[] b = tuple2._2();
                        this.$outer.logInfo((Function0)((Object)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final Time t$1;
                            private final Tuple4[] b$1;

                            public final String apply() {
                                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restoring KafkaRDD for time ", " ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.t$1, Predef$.MODULE$.refArrayOps((Object[])this.b$1).mkString("[", ", ", "]")}));
                            }
                            {
                                this.t$1 = t$1;
                                this.b$1 = b$1;
                            }
                        }));
                        MapLike mapLike = this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), new KafkaRDD<K, V>(this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])Predef$.MODULE$.refArrayOps((Object[])b).map(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final OffsetRange apply(Tuple4<String, Object, Object, Object> x$4) {
                                return OffsetRange$.MODULE$.apply(x$4);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                        return mapLike;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }
}

