/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark.kafka.source;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigMergeable;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.spark.BaseSparkSource;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.seatunnel.spark.stream.SparkStreamingSource;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.CanCommitOffsets;
import org.apache.spark.streaming.kafka010.ConsumerStrategies$;
import org.apache.spark.streaming.kafka010.HasOffsetRanges;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategies$;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u0001=\u00111bS1gW\u0006\u001cFO]3b[*\u00111\u0001B\u0001\u0007g>,(oY3\u000b\u0005\u00151\u0011!B6bM.\f'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"A\u0005tK\u0006$XO\u001c8fY*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t+!\r\t\"\u0003F\u0007\u0002\r%\u00111C\u0002\u0002\u0010\u0005\u0006\u001cXm\u00159be.\u001cv.\u001e:dKB\u0019QcG\u000f\u000e\u0003YQ!a\u0006\r\u0002\u000f\u0011\u001cHO]3b[*\u0011\u0011DG\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0006\n\u0005q1\"a\u0002#TiJ,\u0017-\u001c\t\u0005=\u0005\u001a3%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019!V\u000f\u001d7feA\u0011Ae\n\b\u0003=\u0015J!AJ\u0010\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003M}\u00012a\u000b\u0018\u001e\u001b\u0005a#BA\u0017\u0007\u0003\u0019\u0019HO]3b[&\u0011q\u0006\f\u0002\u0015'B\f'o[*ue\u0016\fW.\u001b8h'>,(oY3\t\u000bE\u0002A\u0011\u0001\u001a\u0002\rqJg.\u001b;?)\u0005\u0019\u0004C\u0001\u001b\u0001\u001b\u0005\u0011\u0001b\u0002\u001c\u0001\u0005\u0004%IaN\u0001\u0007\u0019>;u)\u0012*\u0016\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0007\u0002\u000bMdg\r\u000e6\n\u0005uR$A\u0002'pO\u001e,'\u000f\u0003\u0004@\u0001\u0001\u0006I\u0001O\u0001\b\u0019>;u)\u0012*!\u0011%\t\u0005\u00011AA\u0002\u0013%!)\u0001\u0004tG\",W.Y\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0006if\u0004Xm\u001d\u0006\u0003\u0011j\t1a]9m\u0013\tQUI\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0011\u0002\u0014\u0001A\u0002\u0003\u0007I\u0011B'\u0002\u0015M\u001c\u0007.Z7b?\u0012*\u0017\u000f\u0006\u0002O#B\u0011adT\u0005\u0003!~\u0011A!\u00168ji\"9!kSA\u0001\u0002\u0004\u0019\u0015a\u0001=%c!1A\u000b\u0001Q!\n\r\u000bqa]2iK6\f\u0007\u0005C\u0004W\u0001\t\u0007I\u0011B,\u0002\u0017-\fgm[1QCJ\fWn]\u000b\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005kRLGNC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}S&A\u0003)s_B,'\u000f^5fg\"1\u0011\r\u0001Q\u0001\na\u000bAb[1gW\u0006\u0004\u0016M]1ng\u0002B\u0011b\u0019\u0001A\u0002\u0003\u0007I\u0011\u00023\u0002\u0019=4gm]3u%\u0006tw-Z:\u0016\u0003\u0015\u00042A\b4i\u0013\t9wDA\u0003BeJ\f\u0017\u0010\u0005\u0002jY6\t!N\u0003\u0002l1\u0005A1.\u00194lCB\n\u0004'\u0003\u0002nU\nYqJ\u001a4tKR\u0014\u0016M\\4f\u0011%y\u0007\u00011AA\u0002\u0013%\u0001/\u0001\tpM\u001a\u001cX\r\u001e*b]\u001e,7o\u0018\u0013fcR\u0011a*\u001d\u0005\b%:\f\t\u00111\u0001f\u0011\u0019\u0019\b\u0001)Q\u0005K\u0006iqN\u001a4tKR\u0014\u0016M\\4fg\u0002B\u0011\"\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002<\u0002\u0019%t\u0007/\u001e;E'R\u0014X-Y7\u0016\u0003]\u00042!\u0006={\u0013\tIhC\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000eE\u0003|\u0003\u0007\u00193%D\u0001}\u0015\tih0\u0001\u0005d_:\u001cX/\\3s\u0015\ry\u0018\u0011A\u0001\bG2LWM\u001c;t\u0015\t)!\"C\u0002\u0002\u0006q\u0014abQ8ogVlWM\u001d*fG>\u0014H\rC\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\n\u0005-\u0011\u0001E5oaV$Hi\u0015;sK\u0006lw\fJ3r)\rq\u0015Q\u0002\u0005\t%\u0006\u001d\u0011\u0011!a\u0001o\"9\u0011\u0011\u0003\u0001!B\u00139\u0018!D5oaV$Hi\u0015;sK\u0006l\u0007\u0005C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0018\u0005q1m\u001c8tk6,'\u000f\u0015:fM&DXCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u00109\u0006!A.\u00198h\u0013\rA\u0013Q\u0004\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002\u001a\u0005y1m\u001c8tk6,'\u000f\u0015:fM&D\b\u0005C\u0006\u0002*\u0001\u0001\r\u00111A\u0005\n\u0005-\u0012A\u0002;pa&\u001c7/\u0006\u0002\u0002.A!A%a\f$\u0013\r\t\t$\u000b\u0002\u0004'\u0016$\bbCA\u001b\u0001\u0001\u0007\t\u0019!C\u0005\u0003o\t!\u0002^8qS\u000e\u001cx\fJ3r)\rq\u0015\u0011\b\u0005\n%\u0006M\u0012\u0011!a\u0001\u0003[A\u0001\"!\u0010\u0001A\u0003&\u0011QF\u0001\bi>\u0004\u0018nY:!\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007\nq\u0001\u001d:fa\u0006\u0014X\rF\u0002O\u0003\u000bB\u0001\"a\u0012\u0002@\u0001\u0007\u0011\u0011J\u0001\u0004K:4\bcA\t\u0002L%\u0019\u0011Q\n\u0004\u0003!M\u0003\u0018M]6F]ZL'o\u001c8nK:$\bbBA)\u0001\u0011\u0005\u00131K\u0001\fe\u0012$'\u0007Z1uCN,G\u000f\u0006\u0004\u0002V\u0005\r\u0014Q\u000e\t\u0007\u0003/\nI&!\u0018\u000e\u0003\u001dK1!a\u0017H\u0005\u001d!\u0015\r^1tKR\u0004B!a\u0016\u0002`%\u0019\u0011\u0011M$\u0003\u0007I{w\u000f\u0003\u0005\u0002f\u0005=\u0003\u0019AA4\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\t9&!\u001b\n\u0007\u0005-tI\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e\u0003\u0005\u0002p\u0005=\u0003\u0019AA9\u0003\r\u0011H\r\u001a\t\u0006\u0003g\n9(H\u0007\u0003\u0003kR1!a\u001c\u001b\u0013\u0011\tI(!\u001e\u0003\u0007I#E\tC\u0004\u0002~\u0001!\t%a \u0002\u000f\u001d,G\u000fR1uCR\u0019A#!!\t\u0011\u0005\u001d\u00131\u0010a\u0001\u0003\u0013Bq!!\"\u0001\t\u0003\n9)A\u0006dQ\u0016\u001c7nQ8oM&<GCAAE!\u0011\tY)!&\u000e\u0005\u00055%\u0002BAH\u0003#\u000baaY8oM&<'bAAJ\u0011\u000511m\\7n_:LA!a&\u0002\u000e\nY1\t[3dWJ+7/\u001e7u\u0011\u001d\tY\n\u0001C!\u0003;\u000b1\"\u00194uKJ|U\u000f\u001e9viR\ta\nC\u0004\u0002\"\u0002!\t%a)\u0002\u001b\u001d,G\u000f\u00157vO&tg*Y7f)\u0005\u0019\u0003")
public class KafkaStream
extends BaseSparkSource<DStream<Tuple2<String, String>>>
implements SparkStreamingSource<Tuple2<String, String>> {
    private final Logger org$apache$seatunnel$spark$kafka$source$KafkaStream$$LOGGER;
    private StructType schema;
    private final Properties org$apache$seatunnel$spark$kafka$source$KafkaStream$$kafkaParams;
    private OffsetRange[] org$apache$seatunnel$spark$kafka$source$KafkaStream$$offsetRanges;
    private InputDStream<ConsumerRecord<String, String>> inputDStream;
    private final String consumerPrefix;
    private Set<String> topics;

    public void beforeOutput() {
        SparkStreamingSource.class.beforeOutput((SparkStreamingSource)this);
    }

    public void start(SparkEnvironment env, Function1<Dataset<Row>, BoxedUnit> handler) {
        SparkStreamingSource.class.start((SparkStreamingSource)this, (SparkEnvironment)env, handler);
    }

    public Logger org$apache$seatunnel$spark$kafka$source$KafkaStream$$LOGGER() {
        return this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$LOGGER;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    public Properties org$apache$seatunnel$spark$kafka$source$KafkaStream$$kafkaParams() {
        return this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$kafkaParams;
    }

    private OffsetRange[] org$apache$seatunnel$spark$kafka$source$KafkaStream$$offsetRanges() {
        return this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$offsetRanges;
    }

    public void org$apache$seatunnel$spark$kafka$source$KafkaStream$$offsetRanges_$eq(OffsetRange[] x$1) {
        this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$offsetRanges = x$1;
    }

    private InputDStream<ConsumerRecord<String, String>> inputDStream() {
        return this.inputDStream;
    }

    private void inputDStream_$eq(InputDStream<ConsumerRecord<String, String>> x$1) {
        this.inputDStream = x$1;
    }

    private String consumerPrefix() {
        return this.consumerPrefix;
    }

    private Set<String> topics() {
        return this.topics;
    }

    private void topics_$eq(Set<String> x$1) {
        this.topics = x$1;
    }

    public void prepare(SparkEnvironment env) {
        Config defaultConfig = ConfigFactory.parseMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringBuilder().append((Object)this.consumerPrefix()).append((Object)"key.deserializer").toString()), StringDeserializer.class.getName()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringBuilder().append((Object)this.consumerPrefix()).append((Object)"value.deserializer").toString()), StringDeserializer.class.getName()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringBuilder().append((Object)this.consumerPrefix()).append((Object)"enable.auto.commit").toString()), BoxesRunTime.boxToBoolean(false))}))));
        this.config = this.config.withFallback((ConfigMergeable)defaultConfig);
        this.schema_$eq(new StructType((StructField[])((Object[])new StructField[]{new StructField("topic", DataTypes.StringType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("raw_message", DataTypes.StringType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        this.topics_$eq(Predef$.MODULE$.refArrayOps((Object[])this.config.getString("topics").split(",")).toSet());
        Config consumerConfig = TypesafeConfigUtils.extractSubConfig((Config)this.config, (String)this.consumerPrefix(), (boolean)false);
        JavaConversions$.MODULE$.asScalaSet(consumerConfig.entrySet()).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaStream $outer;

            public final Object apply(Map.Entry<String, ConfigValue> entry) {
                String key = entry.getKey();
                Object value = entry.getValue().unwrapped();
                return this.$outer.org$apache$seatunnel$spark$kafka$source$KafkaStream$$kafkaParams().put(key, String.valueOf(value));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$LOGGER().info("Input Kafka Params:");
        JavaConversions$.MODULE$.propertiesAsScalaMap(this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$kafkaParams()).withFilter((Function1<String, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaStream $outer;

            public final void apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String key = tuple2._1();
                    String value = tuple2._2();
                    this.$outer.org$apache$seatunnel$spark$kafka$source$KafkaStream$$LOGGER().info(new StringBuilder().append((Object)"\t").append((Object)key).append((Object)" = ").append((Object)value).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Dataset<Row> rdd2dataset(SparkSession sparkSession, RDD<Tuple2<String, String>> rdd) {
        RDD value = rdd.map((Function1)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<String, String> record) {
                return Row$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{record._1(), record._2()}));
            }
        }), ClassTag$.MODULE$.apply(Row.class));
        return sparkSession.createDataFrame(value, this.schema());
    }

    public DStream<Tuple2<String, String>> getData(SparkEnvironment env) {
        this.inputDStream_$eq(KafkaUtils$.MODULE$.createDirectStream(env.getStreamingContext(), LocationStrategies$.MODULE$.PreferConsistent(), ConsumerStrategies$.MODULE$.Subscribe(this.topics(), JavaConversions$.MODULE$.propertiesAsScalaMap(this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$kafkaParams()))));
        return this.inputDStream().transform((Function1)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaStream $outer;

            public final RDD<Tuple2<String, String>> apply(RDD<ConsumerRecord<String, String>> rdd) {
                this.$outer.org$apache$seatunnel$spark$kafka$source$KafkaStream$$offsetRanges_$eq(((HasOffsetRanges)rdd).offsetRanges());
                return rdd.map((Function1)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(ConsumerRecord<String, String> record) {
                        String topic = record.topic();
                        String value = record.value();
                        return new Tuple2<String, String>(topic, value);
                    }
                }), ClassTag$.MODULE$.apply(Tuple2.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public CheckResult checkConfig() {
        CheckResult checkResult;
        CheckResult checkResult2 = CheckConfigUtil.checkAllExists((Config)this.config, (String[])new String[]{"topics"});
        if (checkResult2.isSuccess()) {
            Config consumerConfig = TypesafeConfigUtils.extractSubConfig((Config)this.config, (String)this.consumerPrefix(), (boolean)false);
            CheckConfigUtil.checkAllExists((Config)consumerConfig, (String[])new String[]{"bootstrap.servers"});
            checkResult = CheckConfigUtil.checkAllExists((Config)consumerConfig, (String[])new String[]{"group.id"});
        } else {
            checkResult = checkResult2;
        }
        return checkResult;
    }

    public void afterOutput() {
        ((CanCommitOffsets)this.inputDStream()).commitAsync(this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$offsetRanges());
        Predef$.MODULE$.refArrayOps((Object[])this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$offsetRanges()).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaStream $outer;

            public final void apply(OffsetRange offsets) {
                long fromOffset = offsets.fromOffset();
                long untilOffset = offsets.untilOffset();
                if (untilOffset != fromOffset) {
                    this.$outer.org$apache$seatunnel$spark$kafka$source$KafkaStream$$LOGGER().info(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"complete consume topic: ", " partition:"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{offsets.topic()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from ", " until ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(offsets.partition()), BoxesRunTime.boxToLong(fromOffset), BoxesRunTime.boxToLong(untilOffset)}))).toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public String getPluginName() {
        return "KafkaStream";
    }

    public KafkaStream() {
        SparkStreamingSource.class.$init$((SparkStreamingSource)this);
        this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$LOGGER = LoggerFactory.getLogger(KafkaStream.class);
        this.org$apache$seatunnel$spark$kafka$source$KafkaStream$$kafkaParams = new Properties();
        this.consumerPrefix = "consumer.";
    }
}

