/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark.kafka.sink;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigMergeable;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.spark.BaseSparkSink;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.seatunnel.spark.batch.SparkBatchSink;
import org.apache.seatunnel.spark.kafka.sink.Kafka$;
import org.apache.seatunnel.spark.kafka.sink.KafkaProducerUtil;
import org.apache.seatunnel.spark.kafka.sink.KafkaProducerUtil$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u001f\t)1*\u00194lC*\u00111\u0001B\u0001\u0005g&t7N\u0003\u0002\u0006\r\u0005)1.\u00194lC*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\t\u0011b]3biVtg.\u001a7\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0019\tQAY1uG\"L!!\u0006\n\u0003\u001dM\u0003\u0018M]6CCR\u001c\u0007nU5oWB\u0011qcG\u0007\u00021)\u0011\u0011DG\u0001\tS:$XM\u001d8bY*\u0011qAC\u0005\u00039a\u0011q\u0001T8hO&tw\rC\u0003\u001f\u0001\u0011\u0005q$\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002\u0005!91\u0005\u0001b\u0001\n\u0003!\u0013A\u00049s_\u0012,8-\u001a:Qe\u00164\u0017\u000e_\u000b\u0002KA\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0005Y\u0006twMC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#AB*ue&tw\r\u0003\u0004/\u0001\u0001\u0006I!J\u0001\u0010aJ|G-^2feB\u0013XMZ5yA!9\u0001\u0007\u0001a\u0001\n\u0003\t\u0014!C6bM.\f7+\u001b8l+\u0005\u0011\u0004cA\u001a7q5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004PaRLwN\u001c\t\u0004sqrT\"\u0001\u001e\u000b\u0005mR\u0012!\u00032s_\u0006$7-Y:u\u0013\ti$HA\u0005Ce>\fGmY1tiB\u0011\u0011eP\u0005\u0003\u0001\n\u0011\u0011cS1gW\u0006\u0004&o\u001c3vG\u0016\u0014X\u000b^5m\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\r\u000bQb[1gW\u0006\u001c\u0016N\\6`I\u0015\fHC\u0001#H!\t\u0019T)\u0003\u0002Gi\t!QK\\5u\u0011\u001dA\u0015)!AA\u0002I\n1\u0001\u001f\u00132\u0011\u0019Q\u0005\u0001)Q\u0005e\u0005Q1.\u00194lCNKgn\u001b\u0011\t\u000b1\u0003A\u0011I'\u0002\u0017\rDWmY6D_:4\u0017n\u001a\u000b\u0002\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0007G>tg-[4\u000b\u0005MC\u0011AB2p[6|g.\u0003\u0002V!\nY1\t[3dWJ+7/\u001e7u\u0011\u00159\u0006\u0001\"\u0011Y\u0003\u001d\u0001(/\u001a9be\u0016$\"\u0001R-\t\u000bi3\u0006\u0019A.\u0002\u0007\u0015tg\u000f\u0005\u0002];6\ta!\u0003\u0002_\r\t\u00012\u000b]1sW\u0016sg/\u001b:p]6,g\u000e\u001e\u0005\u0006A\u0002!\t%Y\u0001\u0007_V$\b/\u001e;\u0015\u0007\u0011\u0013W\u000eC\u0003d?\u0002\u0007A-\u0001\u0002eMB\u0019Q\r\u001b6\u000e\u0003\u0019T!a\u001a\u000e\u0002\u0007M\fH.\u0003\u0002jM\n9A)\u0019;bg\u0016$\bCA3l\u0013\tagMA\u0002S_^DQA\\0A\u0002m\u000b1\"\u001a8wSJ|g.\\3oi\")\u0001\u000f\u0001C!c\u0006iq-\u001a;QYV<\u0017N\u001c(b[\u0016$\u0012A\u001d\t\u0003gZt!a\r;\n\u0005U$\u0014A\u0002)sK\u0012,g-\u0003\u0002-o*\u0011Q\u000f\u000e")
public class Kafka
extends SparkBatchSink
implements Logging {
    private final String producerPrefix;
    private Option<Broadcast<KafkaProducerUtil>> kafkaSink;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String producerPrefix() {
        return this.producerPrefix;
    }

    public Option<Broadcast<KafkaProducerUtil>> kafkaSink() {
        return this.kafkaSink;
    }

    public void kafkaSink_$eq(Option<Broadcast<KafkaProducerUtil>> x$1) {
        this.kafkaSink = x$1;
    }

    public CheckResult checkConfig() {
        Config producerConfig = TypesafeConfigUtils.extractSubConfig((Config)this.config, (String)this.producerPrefix(), (boolean)false);
        return this.config.hasPath("topic") && producerConfig.hasPath("bootstrap.servers") ? CheckResult.success() : CheckResult.error((String)"please specify [topic] and [producer.bootstrap.servers]");
    }

    public void prepare(SparkEnvironment env) {
        Config defaultConfig = ConfigFactory.parseMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("format"), "json"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringBuilder().append((Object)this.producerPrefix()).append((Object)"key.serializer").toString()), StringSerializer.class.getName()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringBuilder().append((Object)this.producerPrefix()).append((Object)"value.serializer").toString()), StringSerializer.class.getName())}))));
        ((BaseSparkSink)this).config = this.config.withFallback((ConfigMergeable)defaultConfig);
        Properties props = new Properties();
        JavaConversions$.MODULE$.asScalaSet(TypesafeConfigUtils.extractSubConfig((Config)this.config, (String)this.producerPrefix(), (boolean)false).entrySet()).foreach(new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Map.Entry<String, ConfigValue> entry) {
                String key = entry.getKey();
                String value = String.valueOf(entry.getValue().unwrapped());
                return this.props$1.put(key, value);
            }
            {
                this.props$1 = props$1;
            }
        });
        this.log().info("Kafka Output properties: ");
        JavaConversions$.MODULE$.propertiesAsScalaMap(props).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Kafka $outer;

            public final void apply(Tuple2<String, String> entry) {
                Tuple2<String, String> tuple2 = entry;
                if (tuple2 != null) {
                    Tuple2<String, String> tuple22;
                    String key = tuple2._1();
                    String value = tuple2._2();
                    Tuple2<String, String> tuple23 = tuple22 = new Tuple2<String, String>(key, value);
                    String key2 = tuple23._1();
                    String value2 = tuple23._2();
                    this.$outer.log().info(new StringBuilder().append((Object)key2).append((Object)" = ").append((Object)value2).toString());
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafkaSink_$eq(new Some<Broadcast<KafkaProducerUtil>>(env.getSparkSession().sparkContext().broadcast((Object)KafkaProducerUtil$.MODULE$.apply(props), ClassTag$.MODULE$.apply(KafkaProducerUtil.class))));
    }

    public void output(Dataset<Row> df, SparkEnvironment environment) {
        String string2;
        String topic = this.config.getString("topic");
        String format2 = this.config.getString("format");
        if (this.config.hasPath("serializer")) {
            format2 = this.config.getString("serializer");
        }
        if ("text".equals(string2 = format2)) {
            if (df.schema().size() != 1) {
                throw new Exception(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Text data source supports only a single column,"})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" and you have ", " columns."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(df.schema().size())}))).toString());
            }
            df.foreach((Function1)((Object)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Kafka $outer;
                public final String topic$1;

                public final void apply(Row row) {
                    this.$outer.kafkaSink().foreach(new Serializable(this, row){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$output$1 $outer;
                        private final Row row$1;

                        public final void apply(Broadcast<KafkaProducerUtil> ks) {
                            ((KafkaProducerUtil)ks.value()).send(this.$outer.topic$1, (String)this.row$1.getAs(0));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.row$1 = row$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Dataset dataSet = df.toJSON();
            dataSet.foreach((Function1)((Object)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Kafka $outer;
                public final String topic$1;

                public final void apply(String row) {
                    this.$outer.kafkaSink().foreach(new Serializable(this, row){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$output$2 $outer;
                        private final String row$2;

                        public final void apply(Broadcast<KafkaProducerUtil> ks) {
                            ((KafkaProducerUtil)ks.value()).send(this.$outer.topic$1, this.row$2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.row$2 = row$2;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            }));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String getPluginName() {
        return "Kafka";
    }

    public Kafka() {
        Logging.class.$init$((Logging)this);
        this.producerPrefix = "producer.";
        this.kafkaSink = None$.MODULE$;
    }
}

