/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClientProvider;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerLoginModule
implements LoginModule {
    public static final String OAUTHBEARER_MECHANISM = "OAUTHBEARER";
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerLoginModule.class);
    private Subject subject = null;
    private AuthenticateCallbackHandler callbackHandler = null;
    private OAuthBearerToken tokenRequiringCommit = null;
    private OAuthBearerToken myCommittedToken = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = Objects.requireNonNull(subject);
        if (!(Objects.requireNonNull(callbackHandler) instanceof AuthenticateCallbackHandler)) {
            throw new IllegalArgumentException(String.format("Callback handler must be castable to %s: %s", AuthenticateCallbackHandler.class.getName(), callbackHandler.getClass().getName()));
        }
        this.callbackHandler = (AuthenticateCallbackHandler)callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.tokenRequiringCommit != null) {
            throw new IllegalStateException(String.format("Already have an uncommitted token with private credential token count=%d", this.committedTokenCount()));
        }
        if (this.myCommittedToken != null) {
            throw new IllegalStateException(String.format("Already have a committed token with private credential token count=%d; must login on another login context or logout here first before reusing the same login context", this.committedTokenCount()));
        }
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        try {
            this.callbackHandler.handle(new Callback[]{callback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            log.error(e.getMessage(), e);
            throw new LoginException("An internal error occurred");
        }
        this.tokenRequiringCommit = callback.token();
        if (this.tokenRequiringCommit == null) {
            log.info(String.format("Login failed: %s : %s (URI=%s)", callback.errorCode(), callback.errorDescription(), callback.errorUri()));
            throw new LoginException(callback.errorDescription());
        }
        log.info("Login succeeded; invoke commit() to commit it; current committed token count={}", (Object)this.committedTokenCount());
        return true;
    }

    @Override
    public boolean logout() {
        if (this.tokenRequiringCommit != null) {
            throw new IllegalStateException("Cannot call logout() immediately after login(); need to first invoke commit() or abort()");
        }
        if (this.myCommittedToken == null) {
            if (log.isDebugEnabled()) {
                log.debug("Nothing here to log out");
            }
            return false;
        }
        log.info("Logging out my token; current committed token count = {}", (Object)this.committedTokenCount());
        Iterator<Object> iterator2 = this.subject.getPrivateCredentials().iterator();
        while (iterator2.hasNext()) {
            Object privateCredential = iterator2.next();
            if (privateCredential != this.myCommittedToken) continue;
            iterator2.remove();
            this.myCommittedToken = null;
            break;
        }
        log.info("Done logging out my token; committed token count is now {}", (Object)this.committedTokenCount());
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.tokenRequiringCommit == null) {
            if (log.isDebugEnabled()) {
                log.debug("Nothing here to commit");
            }
            return false;
        }
        log.info("Committing my token; current committed token count = {}", (Object)this.committedTokenCount());
        this.subject.getPrivateCredentials().add(this.tokenRequiringCommit);
        this.myCommittedToken = this.tokenRequiringCommit;
        this.tokenRequiringCommit = null;
        log.info("Done committing my token; committed token count is now {}", (Object)this.committedTokenCount());
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.tokenRequiringCommit != null) {
            log.info("Login aborted");
            this.tokenRequiringCommit = null;
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Nothing here to abort");
        }
        return false;
    }

    private int committedTokenCount() {
        return this.subject.getPrivateCredentials(OAuthBearerToken.class).size();
    }

    static {
        OAuthBearerSaslClientProvider.initialize();
        OAuthBearerSaslServerProvider.initialize();
    }
}

