/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.CollectionUtils;
import org.apache.kafka.common.utils.Utils;

public class ProduceRequest
extends AbstractRequest {
    private static final String ACKS_KEY_NAME = "acks";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final String TOPIC_DATA_KEY_NAME = "topic_data";
    private static final String PARTITION_DATA_KEY_NAME = "data";
    private static final String RECORD_SET_KEY_NAME = "record_set";
    private static final Schema TOPIC_PRODUCE_DATA_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("data", new ArrayOf(new Schema(CommonFields.PARTITION_ID, new Field("record_set", Type.RECORDS)))));
    private static final Schema PRODUCE_REQUEST_V0;
    private static final Schema PRODUCE_REQUEST_V1;
    private static final Schema PRODUCE_REQUEST_V2;
    private static final Schema PRODUCE_REQUEST_V3;
    private static final Schema PRODUCE_REQUEST_V4;
    private static final Schema PRODUCE_REQUEST_V5;
    private static final Schema PRODUCE_REQUEST_V6;
    private final short acks;
    private final int timeout;
    private final String transactionalId;
    private final Map<TopicPartition, Integer> partitionSizes;
    private volatile Map<TopicPartition, MemoryRecords> partitionRecords;
    private boolean transactional = false;
    private boolean idempotent = false;

    public static Schema[] schemaVersions() {
        return new Schema[]{PRODUCE_REQUEST_V0, PRODUCE_REQUEST_V1, PRODUCE_REQUEST_V2, PRODUCE_REQUEST_V3, PRODUCE_REQUEST_V4, PRODUCE_REQUEST_V5, PRODUCE_REQUEST_V6};
    }

    private ProduceRequest(short version, short acks, int timeout, Map<TopicPartition, MemoryRecords> partitionRecords, String transactionalId) {
        super(version);
        this.acks = acks;
        this.timeout = timeout;
        this.transactionalId = transactionalId;
        this.partitionRecords = partitionRecords;
        this.partitionSizes = ProduceRequest.createPartitionSizes(partitionRecords);
        for (MemoryRecords records : partitionRecords.values()) {
            this.validateRecords(version, records);
        }
    }

    private static Map<TopicPartition, Integer> createPartitionSizes(Map<TopicPartition, MemoryRecords> partitionRecords) {
        HashMap<TopicPartition, Integer> result2 = new HashMap<TopicPartition, Integer>(partitionRecords.size());
        for (Map.Entry<TopicPartition, MemoryRecords> entry : partitionRecords.entrySet()) {
            result2.put(entry.getKey(), entry.getValue().sizeInBytes());
        }
        return result2;
    }

    public ProduceRequest(Struct struct, short version) {
        super(version);
        this.partitionRecords = new HashMap<TopicPartition, MemoryRecords>();
        for (Object topicDataObj : struct.getArray(TOPIC_DATA_KEY_NAME)) {
            Struct topicData = (Struct)topicDataObj;
            String topic = topicData.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicData.getArray(PARTITION_DATA_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition2 = partitionResponse.get(CommonFields.PARTITION_ID);
                MemoryRecords records = (MemoryRecords)partitionResponse.getRecords(RECORD_SET_KEY_NAME);
                this.validateRecords(version, records);
                this.partitionRecords.put(new TopicPartition(topic, partition2), records);
            }
        }
        this.partitionSizes = ProduceRequest.createPartitionSizes(this.partitionRecords);
        this.acks = struct.getShort(ACKS_KEY_NAME);
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
        this.transactionalId = struct.getOrElse(CommonFields.NULLABLE_TRANSACTIONAL_ID, null);
    }

    private void validateRecords(short version, MemoryRecords records) {
        if (version >= 3) {
            Iterator<MutableRecordBatch> iterator2 = records.batches().iterator();
            if (!iterator2.hasNext()) {
                throw new InvalidRecordException("Produce requests with version " + version + " must have at least one record batch");
            }
            MutableRecordBatch entry = iterator2.next();
            if (entry.magic() != 2) {
                throw new InvalidRecordException("Produce requests with version " + version + " are only allowed to contain record batches with magic version 2");
            }
            if (iterator2.hasNext()) {
                throw new InvalidRecordException("Produce requests with version " + version + " are only allowed to contain exactly one record batch");
            }
            this.idempotent = entry.hasProducerId();
            this.transactional = entry.isTransactional();
        }
    }

    @Override
    public Struct toStruct() {
        Map<TopicPartition, MemoryRecords> partitionRecords = this.partitionRecordsOrFail();
        short version = this.version();
        Struct struct = new Struct(ApiKeys.PRODUCE.requestSchema(version));
        Map<String, Map<Integer, MemoryRecords>> recordsByTopic = CollectionUtils.groupDataByTopic(partitionRecords);
        struct.set(ACKS_KEY_NAME, (Object)this.acks);
        struct.set(TIMEOUT_KEY_NAME, (Object)this.timeout);
        struct.setIfExists(CommonFields.NULLABLE_TRANSACTIONAL_ID, (Object)this.transactionalId);
        ArrayList<Struct> topicDatas = new ArrayList<Struct>(recordsByTopic.size());
        for (Map.Entry<String, Map<Integer, MemoryRecords>> topicEntry : recordsByTopic.entrySet()) {
            Struct topicData = struct.instance(TOPIC_DATA_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, MemoryRecords> partitionEntry : topicEntry.getValue().entrySet()) {
                MemoryRecords records = partitionEntry.getValue();
                Struct part = topicData.instance(PARTITION_DATA_KEY_NAME).set(CommonFields.PARTITION_ID, partitionEntry.getKey()).set(RECORD_SET_KEY_NAME, (Object)records);
                partitionArray.add(part);
            }
            topicData.set(PARTITION_DATA_KEY_NAME, (Object)partitionArray.toArray());
            topicDatas.add(topicData);
        }
        struct.set(TOPIC_DATA_KEY_NAME, (Object)topicDatas.toArray());
        return struct;
    }

    @Override
    public String toString(boolean verbose) {
        StringBuilder bld = new StringBuilder();
        bld.append("{acks=").append(this.acks).append(",timeout=").append(this.timeout);
        if (verbose) {
            bld.append(",partitionSizes=").append(Utils.mkString(this.partitionSizes, "[", "]", "=", ","));
        } else {
            bld.append(",numPartitions=").append(this.partitionSizes.size());
        }
        bld.append("}");
        return bld.toString();
    }

    @Override
    public ProduceResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        if (this.acks == 0) {
            return null;
        }
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseMap = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        ProduceResponse.PartitionResponse partitionResponse = new ProduceResponse.PartitionResponse(error);
        for (TopicPartition tp : this.partitions()) {
            responseMap.put(tp, partitionResponse);
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new ProduceResponse(responseMap, throttleTimeMs);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.PRODUCE.latestVersion()));
    }

    @Override
    public Map<Errors, Integer> errorCounts(Throwable e) {
        Errors error = Errors.forException(e);
        return Collections.singletonMap(error, this.partitions().size());
    }

    private Collection<TopicPartition> partitions() {
        return this.partitionSizes.keySet();
    }

    public short acks() {
        return this.acks;
    }

    public int timeout() {
        return this.timeout;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public Map<TopicPartition, MemoryRecords> partitionRecordsOrFail() {
        Map<TopicPartition, MemoryRecords> partitionRecords = this.partitionRecords;
        if (partitionRecords == null) {
            throw new IllegalStateException("The partition records are no longer available because clearPartitionRecords() has been invoked.");
        }
        return partitionRecords;
    }

    public void clearPartitionRecords() {
        this.partitionRecords = null;
    }

    public static ProduceRequest parse(ByteBuffer buffer, short version) {
        return new ProduceRequest(ApiKeys.PRODUCE.parseRequest(version, buffer), version);
    }

    public static byte requiredMagicForVersion(short produceRequestVersion) {
        switch (produceRequestVersion) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Magic value to use for produce request version " + produceRequestVersion + " is not known");
    }

    static {
        PRODUCE_REQUEST_V2 = PRODUCE_REQUEST_V1 = (PRODUCE_REQUEST_V0 = new Schema(new Field(ACKS_KEY_NAME, Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field(TIMEOUT_KEY_NAME, Type.INT32, "The time to await a response in ms."), new Field(TOPIC_DATA_KEY_NAME, new ArrayOf(TOPIC_PRODUCE_DATA_V0))));
        PRODUCE_REQUEST_V6 = PRODUCE_REQUEST_V5 = (PRODUCE_REQUEST_V4 = (PRODUCE_REQUEST_V3 = new Schema(CommonFields.NULLABLE_TRANSACTIONAL_ID, new Field(ACKS_KEY_NAME, Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field(TIMEOUT_KEY_NAME, Type.INT32, "The time to await a response in ms."), new Field(TOPIC_DATA_KEY_NAME, new ArrayOf(TOPIC_PRODUCE_DATA_V0)))));
    }

    public static class Builder
    extends AbstractRequest.Builder<ProduceRequest> {
        private final short acks;
        private final int timeout;
        private final Map<TopicPartition, MemoryRecords> partitionRecords;
        private final String transactionalId;

        public static Builder forCurrentMagic(short acks, int timeout, Map<TopicPartition, MemoryRecords> partitionRecords) {
            return Builder.forMagic((byte)2, acks, timeout, partitionRecords, null);
        }

        public static Builder forMagic(byte magic, short acks, int timeout, Map<TopicPartition, MemoryRecords> partitionRecords, String transactionalId) {
            short maxVersion;
            short minVersion;
            if (magic < 2) {
                minVersion = 2;
                maxVersion = 2;
            } else {
                minVersion = 3;
                maxVersion = ApiKeys.PRODUCE.latestVersion();
            }
            return new Builder(minVersion, maxVersion, acks, timeout, partitionRecords, transactionalId);
        }

        private Builder(short minVersion, short maxVersion, short acks, int timeout, Map<TopicPartition, MemoryRecords> partitionRecords, String transactionalId) {
            super(ApiKeys.PRODUCE, minVersion, maxVersion);
            this.acks = acks;
            this.timeout = timeout;
            this.partitionRecords = partitionRecords;
            this.transactionalId = transactionalId;
        }

        @Override
        public ProduceRequest build(short version) {
            return new ProduceRequest(version, this.acks, this.timeout, this.partitionRecords, this.transactionalId);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=ProduceRequest").append(", acks=").append(this.acks).append(", timeout=").append(this.timeout).append(", partitionRecords=(").append(this.partitionRecords).append("), transactionalId='").append(this.transactionalId != null ? this.transactionalId : "").append("'");
            return bld.toString();
        }
    }
}

