/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class OffsetCommitRequest
extends AbstractRequest {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String RETENTION_TIME_KEY_NAME = "retention_time";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String COMMIT_OFFSET_KEY_NAME = "offset";
    private static final String METADATA_KEY_NAME = "metadata";
    @Deprecated
    private static final String TIMESTAMP_KEY_NAME = "timestamp";
    private static final Schema OFFSET_COMMIT_REQUEST_PARTITION_V0 = new Schema(CommonFields.PARTITION_ID, new Field("offset", Type.INT64, "Message offset to be committed."), new Field("metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
    private static final Schema OFFSET_COMMIT_REQUEST_PARTITION_V1 = new Schema(CommonFields.PARTITION_ID, new Field("offset", Type.INT64, "Message offset to be committed."), new Field("timestamp", Type.INT64, "Timestamp of the commit"), new Field("metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
    private static final Schema OFFSET_COMMIT_REQUEST_PARTITION_V2 = new Schema(CommonFields.PARTITION_ID, new Field("offset", Type.INT64, "Message offset to be committed."), new Field("metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
    private static final Schema OFFSET_COMMIT_REQUEST_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(OFFSET_COMMIT_REQUEST_PARTITION_V0), "Partitions to commit offsets."));
    private static final Schema OFFSET_COMMIT_REQUEST_TOPIC_V1 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(OFFSET_COMMIT_REQUEST_PARTITION_V1), "Partitions to commit offsets."));
    private static final Schema OFFSET_COMMIT_REQUEST_TOPIC_V2 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(OFFSET_COMMIT_REQUEST_PARTITION_V2), "Partitions to commit offsets."));
    private static final Schema OFFSET_COMMIT_REQUEST_V0 = new Schema(CommonFields.GROUP_ID, new Field("topics", new ArrayOf(OFFSET_COMMIT_REQUEST_TOPIC_V0), "Topics to commit offsets."));
    private static final Schema OFFSET_COMMIT_REQUEST_V1 = new Schema(CommonFields.GROUP_ID, CommonFields.GENERATION_ID, CommonFields.MEMBER_ID, new Field("topics", new ArrayOf(OFFSET_COMMIT_REQUEST_TOPIC_V1), "Topics to commit offsets."));
    private static final Schema OFFSET_COMMIT_REQUEST_V2;
    private static final Schema OFFSET_COMMIT_REQUEST_V3;
    private static final Schema OFFSET_COMMIT_REQUEST_V4;
    public static final int DEFAULT_GENERATION_ID = -1;
    public static final String DEFAULT_MEMBER_ID = "";
    public static final long DEFAULT_RETENTION_TIME = -1L;
    @Deprecated
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final String groupId;
    private final String memberId;
    private final int generationId;
    private final long retentionTime;
    private final Map<TopicPartition, PartitionData> offsetData;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_COMMIT_REQUEST_V0, OFFSET_COMMIT_REQUEST_V1, OFFSET_COMMIT_REQUEST_V2, OFFSET_COMMIT_REQUEST_V3, OFFSET_COMMIT_REQUEST_V4};
    }

    private OffsetCommitRequest(String groupId, int generationId, String memberId, long retentionTime, Map<TopicPartition, PartitionData> offsetData, short version) {
        super(version);
        this.groupId = groupId;
        this.generationId = generationId;
        this.memberId = memberId;
        this.retentionTime = retentionTime;
        this.offsetData = offsetData;
    }

    public OffsetCommitRequest(Struct struct, short versionId) {
        super(versionId);
        this.groupId = struct.get(CommonFields.GROUP_ID);
        this.generationId = struct.getOrElse(CommonFields.GENERATION_ID, -1);
        this.memberId = struct.getOrElse(CommonFields.MEMBER_ID, DEFAULT_MEMBER_ID);
        this.retentionTime = struct.hasField(RETENTION_TIME_KEY_NAME) ? struct.getLong(RETENTION_TIME_KEY_NAME) : -1L;
        this.offsetData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicDataObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicData = (Struct)topicDataObj;
            String topic = topicData.get(CommonFields.TOPIC_NAME);
            for (Object partitionDataObj : topicData.getArray(PARTITIONS_KEY_NAME)) {
                PartitionData partitionOffset;
                Struct partitionDataStruct = (Struct)partitionDataObj;
                int partition2 = partitionDataStruct.get(CommonFields.PARTITION_ID);
                long offset = partitionDataStruct.getLong(COMMIT_OFFSET_KEY_NAME);
                String metadata = partitionDataStruct.getString(METADATA_KEY_NAME);
                if (partitionDataStruct.hasField(TIMESTAMP_KEY_NAME)) {
                    long timestamp = partitionDataStruct.getLong(TIMESTAMP_KEY_NAME);
                    partitionOffset = new PartitionData(offset, timestamp, metadata);
                } else {
                    partitionOffset = new PartitionData(offset, metadata);
                }
                this.offsetData.put(new TopicPartition(topic, partition2), partitionOffset);
            }
        }
    }

    @Override
    public Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.OFFSET_COMMIT.requestSchema(version));
        struct.set(CommonFields.GROUP_ID, this.groupId);
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(this.offsetData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = struct.instance(TOPICS_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData fetchPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(COMMIT_OFFSET_KEY_NAME, (Object)fetchPartitionData.offset);
                if (partitionData.hasField(TIMESTAMP_KEY_NAME)) {
                    partitionData.set(TIMESTAMP_KEY_NAME, (Object)fetchPartitionData.timestamp);
                }
                partitionData.set(METADATA_KEY_NAME, (Object)fetchPartitionData.metadata);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
        struct.setIfExists(CommonFields.GENERATION_ID, (Object)this.generationId);
        struct.setIfExists(CommonFields.MEMBER_ID, (Object)this.memberId);
        if (struct.hasField(RETENTION_TIME_KEY_NAME)) {
            struct.set(RETENTION_TIME_KEY_NAME, (Object)this.retentionTime);
        }
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
        for (Map.Entry<TopicPartition, PartitionData> entry : this.offsetData.entrySet()) {
            responseData.put(entry.getKey(), Errors.forException(e));
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new OffsetCommitResponse(responseData);
            }
            case 3: 
            case 4: {
                return new OffsetCommitResponse(throttleTimeMs, responseData);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.OFFSET_COMMIT.latestVersion()));
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public long retentionTime() {
        return this.retentionTime;
    }

    public Map<TopicPartition, PartitionData> offsetData() {
        return this.offsetData;
    }

    public static OffsetCommitRequest parse(ByteBuffer buffer, short version) {
        Schema schema = ApiKeys.OFFSET_COMMIT.requestSchema(version);
        return new OffsetCommitRequest(schema.read(buffer), version);
    }

    static {
        OFFSET_COMMIT_REQUEST_V4 = OFFSET_COMMIT_REQUEST_V3 = (OFFSET_COMMIT_REQUEST_V2 = new Schema(CommonFields.GROUP_ID, CommonFields.GENERATION_ID, CommonFields.MEMBER_ID, new Field(RETENTION_TIME_KEY_NAME, Type.INT64, "Time period in ms to retain the offset."), new Field(TOPICS_KEY_NAME, new ArrayOf(OFFSET_COMMIT_REQUEST_TOPIC_V2), "Topics to commit offsets.")));
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetCommitRequest> {
        private final String groupId;
        private final Map<TopicPartition, PartitionData> offsetData;
        private String memberId = "";
        private int generationId = -1;
        private long retentionTime = -1L;

        public Builder(String groupId, Map<TopicPartition, PartitionData> offsetData) {
            super(ApiKeys.OFFSET_COMMIT);
            this.groupId = groupId;
            this.offsetData = offsetData;
        }

        public Builder setMemberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public Builder setGenerationId(int generationId) {
            this.generationId = generationId;
            return this;
        }

        public Builder setRetentionTime(long retentionTime) {
            this.retentionTime = retentionTime;
            return this;
        }

        @Override
        public OffsetCommitRequest build(short version) {
            switch (version) {
                case 0: {
                    return new OffsetCommitRequest(this.groupId, -1, OffsetCommitRequest.DEFAULT_MEMBER_ID, -1L, this.offsetData, version);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    long retentionTime = version == 1 ? -1L : this.retentionTime;
                    return new OffsetCommitRequest(this.groupId, this.generationId, this.memberId, retentionTime, this.offsetData, version);
                }
            }
            throw new UnsupportedVersionException("Unsupported version " + version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=OffsetCommitRequest").append(", groupId=").append(this.groupId).append(", memberId=").append(this.memberId).append(", generationId=").append(this.generationId).append(", retentionTime=").append(this.retentionTime).append(", offsetData=").append(this.offsetData).append(")");
            return bld.toString();
        }
    }

    public static final class PartitionData {
        @Deprecated
        public final long timestamp;
        public final long offset;
        public final String metadata;

        @Deprecated
        public PartitionData(long offset, long timestamp, String metadata) {
            this.offset = offset;
            this.timestamp = timestamp;
            this.metadata = metadata;
        }

        public PartitionData(long offset, String metadata) {
            this(offset, -1L, metadata);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(timestamp=").append(this.timestamp).append(", offset=").append(this.offset).append(", metadata=").append(this.metadata).append(")");
            return bld.toString();
        }
    }
}

