/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.InvalidMetadataException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Utils;

public class MetadataResponse
extends AbstractResponse {
    private static final String BROKERS_KEY_NAME = "brokers";
    private static final String TOPIC_METADATA_KEY_NAME = "topic_metadata";
    private static final String NODE_ID_KEY_NAME = "node_id";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private static final String RACK_KEY_NAME = "rack";
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    public static final int NO_CONTROLLER_ID = -1;
    private static final String CLUSTER_ID_KEY_NAME = "cluster_id";
    private static final String IS_INTERNAL_KEY_NAME = "is_internal";
    private static final String PARTITION_METADATA_KEY_NAME = "partition_metadata";
    private static final String LEADER_KEY_NAME = "leader";
    private static final String REPLICAS_KEY_NAME = "replicas";
    private static final String ISR_KEY_NAME = "isr";
    private static final String OFFLINE_REPLICAS_KEY_NAME = "offline_replicas";
    private static final Schema METADATA_BROKER_V0 = new Schema(new Field("node_id", Type.INT32, "The broker id."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("port", Type.INT32, "The port on which the broker accepts requests."));
    private static final Schema PARTITION_METADATA_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.PARTITION_ID, new Field("leader", Type.INT32, "The id of the broker acting as leader for this partition."), new Field("replicas", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."));
    private static final Schema TOPIC_METADATA_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.TOPIC_NAME, new Field("partition_metadata", new ArrayOf(PARTITION_METADATA_V0), "Metadata for each partition of the topic."));
    private static final Schema METADATA_RESPONSE_V0 = new Schema(new Field("brokers", new ArrayOf(METADATA_BROKER_V0), "Host and port information for all brokers."), new Field("topic_metadata", new ArrayOf(TOPIC_METADATA_V0)));
    private static final Schema METADATA_BROKER_V1 = new Schema(new Field("node_id", Type.INT32, "The broker id."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("port", Type.INT32, "The port on which the broker accepts requests."), new Field("rack", Type.NULLABLE_STRING, "The rack of the broker."));
    private static final Schema PARTITION_METADATA_V1 = PARTITION_METADATA_V0;
    private static final Schema PARTITION_METADATA_V2 = new Schema(CommonFields.ERROR_CODE, CommonFields.PARTITION_ID, new Field("leader", Type.INT32, "The id of the broker acting as leader for this partition."), new Field("replicas", new ArrayOf(Type.INT32), "The set of all nodes that host this partition."), new Field("isr", new ArrayOf(Type.INT32), "The set of nodes that are in sync with the leader for this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The set of offline replicas of this partition."));
    private static final Schema TOPIC_METADATA_V1 = new Schema(CommonFields.ERROR_CODE, CommonFields.TOPIC_NAME, new Field("is_internal", Type.BOOLEAN, "Indicates if the topic is considered a Kafka internal topic"), new Field("partition_metadata", new ArrayOf(PARTITION_METADATA_V1), "Metadata for each partition of the topic."));
    private static final Schema TOPIC_METADATA_V2 = new Schema(CommonFields.ERROR_CODE, CommonFields.TOPIC_NAME, new Field("is_internal", Type.BOOLEAN, "Indicates if the topic is considered a Kafka internal topic"), new Field("partition_metadata", new ArrayOf(PARTITION_METADATA_V2), "Metadata for each partition of the topic."));
    private static final Schema METADATA_RESPONSE_V1 = new Schema(new Field("brokers", new ArrayOf(METADATA_BROKER_V1), "Host and port information for all brokers."), new Field("controller_id", Type.INT32, "The broker id of the controller broker."), new Field("topic_metadata", new ArrayOf(TOPIC_METADATA_V1)));
    private static final Schema METADATA_RESPONSE_V2 = new Schema(new Field("brokers", new ArrayOf(METADATA_BROKER_V1), "Host and port information for all brokers."), new Field("cluster_id", Type.NULLABLE_STRING, "The cluster id that this broker belongs to."), new Field("controller_id", Type.INT32, "The broker id of the controller broker."), new Field("topic_metadata", new ArrayOf(TOPIC_METADATA_V1)));
    private static final Schema METADATA_RESPONSE_V3;
    private static final Schema METADATA_RESPONSE_V4;
    private static final Schema METADATA_RESPONSE_V5;
    private static final Schema METADATA_RESPONSE_V6;
    private final int throttleTimeMs;
    private final Collection<Node> brokers;
    private final Node controller;
    private final List<TopicMetadata> topicMetadata;
    private final String clusterId;

    public static Schema[] schemaVersions() {
        return new Schema[]{METADATA_RESPONSE_V0, METADATA_RESPONSE_V1, METADATA_RESPONSE_V2, METADATA_RESPONSE_V3, METADATA_RESPONSE_V4, METADATA_RESPONSE_V5, METADATA_RESPONSE_V6};
    }

    public MetadataResponse(List<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadata) {
        this(0, brokers, clusterId, controllerId, topicMetadata);
    }

    public MetadataResponse(int throttleTimeMs, List<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadata) {
        this.throttleTimeMs = throttleTimeMs;
        this.brokers = brokers;
        this.controller = this.getControllerNode(controllerId, brokers);
        this.topicMetadata = topicMetadata;
        this.clusterId = clusterId;
    }

    public MetadataResponse(Struct struct) {
        Object[] topicInfos;
        Object[] brokerStructs;
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        HashMap<Integer, Node> brokers = new HashMap<Integer, Node>();
        for (Object brokerStruct : brokerStructs = (Object[])struct.get(BROKERS_KEY_NAME)) {
            Struct broker = (Struct)brokerStruct;
            int nodeId = broker.getInt(NODE_ID_KEY_NAME);
            String host = broker.getString(HOST_KEY_NAME);
            int port = broker.getInt(PORT_KEY_NAME);
            String rack = broker.hasField(RACK_KEY_NAME) ? broker.getString(RACK_KEY_NAME) : null;
            brokers.put(nodeId, new Node(nodeId, host, port, rack));
        }
        int controllerId = -1;
        if (struct.hasField(CONTROLLER_ID_KEY_NAME)) {
            controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        }
        this.clusterId = struct.hasField(CLUSTER_ID_KEY_NAME) ? struct.getString(CLUSTER_ID_KEY_NAME) : null;
        ArrayList<TopicMetadata> topicMetadata = new ArrayList<TopicMetadata>();
        for (Object topicInfoObj : topicInfos = (Object[])struct.get(TOPIC_METADATA_KEY_NAME)) {
            Object[] partitionInfos;
            Struct topicInfo = (Struct)topicInfoObj;
            Errors topicError = Errors.forCode(topicInfo.get(CommonFields.ERROR_CODE));
            String topic = topicInfo.get(CommonFields.TOPIC_NAME);
            boolean isInternal = topicInfo.hasField(IS_INTERNAL_KEY_NAME) ? topicInfo.getBoolean(IS_INTERNAL_KEY_NAME) : false;
            ArrayList<PartitionMetadata> partitionMetadata = new ArrayList<PartitionMetadata>();
            for (Object partitionInfoObj : partitionInfos = (Object[])topicInfo.get(PARTITION_METADATA_KEY_NAME)) {
                Struct partitionInfo = (Struct)partitionInfoObj;
                Errors partitionError = Errors.forCode(partitionInfo.get(CommonFields.ERROR_CODE));
                int partition2 = partitionInfo.get(CommonFields.PARTITION_ID);
                int leader = partitionInfo.getInt(LEADER_KEY_NAME);
                Node leaderNode = leader == -1 ? null : (Node)brokers.get(leader);
                Object[] replicas = (Object[])partitionInfo.get(REPLICAS_KEY_NAME);
                List<Node> replicaNodes = this.convertToNodes(brokers, replicas);
                Object[] isr = (Object[])partitionInfo.get(ISR_KEY_NAME);
                List<Node> isrNodes = this.convertToNodes(brokers, isr);
                Object[] offlineReplicas = partitionInfo.hasField(OFFLINE_REPLICAS_KEY_NAME) ? (Object[])partitionInfo.get(OFFLINE_REPLICAS_KEY_NAME) : new Object[]{};
                List<Node> offlineNodes = this.convertToNodes(brokers, offlineReplicas);
                partitionMetadata.add(new PartitionMetadata(partitionError, partition2, leaderNode, replicaNodes, isrNodes, offlineNodes));
            }
            topicMetadata.add(new TopicMetadata(topicError, topic, isInternal, partitionMetadata));
        }
        this.brokers = brokers.values();
        this.controller = this.getControllerNode(controllerId, brokers.values());
        this.topicMetadata = topicMetadata;
    }

    private List<Node> convertToNodes(Map<Integer, Node> brokers, Object[] brokerIds) {
        ArrayList<Node> nodes = new ArrayList<Node>(brokerIds.length);
        for (Object brokerId : brokerIds) {
            if (brokers.containsKey(brokerId)) {
                nodes.add(brokers.get(brokerId));
                continue;
            }
            nodes.add(new Node((Integer)brokerId, "", -1));
        }
        return nodes;
    }

    private Node getControllerNode(int controllerId, Collection<Node> brokers) {
        for (Node broker : brokers) {
            if (broker.id() != controllerId) continue;
            return broker;
        }
        return null;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<String, Errors> errors() {
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        for (TopicMetadata metadata : this.topicMetadata) {
            if (metadata.error == Errors.NONE) continue;
            errors.put(metadata.topic(), metadata.error);
        }
        return errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (TopicMetadata metadata : this.topicMetadata) {
            this.updateErrorCounts(errorCounts, metadata.error);
        }
        return errorCounts;
    }

    public Set<String> topicsByError(Errors error) {
        HashSet<String> errorTopics = new HashSet<String>();
        for (TopicMetadata metadata : this.topicMetadata) {
            if (metadata.error != error) continue;
            errorTopics.add(metadata.topic());
        }
        return errorTopics;
    }

    public Set<String> unavailableTopics() {
        HashSet<String> invalidMetadataTopics = new HashSet<String>();
        block0: for (TopicMetadata topicMetadata : this.topicMetadata) {
            if (topicMetadata.error.exception() instanceof InvalidMetadataException) {
                invalidMetadataTopics.add(topicMetadata.topic);
                continue;
            }
            for (PartitionMetadata partitionMetadata : topicMetadata.partitionMetadata) {
                if (!(partitionMetadata.error.exception() instanceof InvalidMetadataException)) continue;
                invalidMetadataTopics.add(topicMetadata.topic);
                continue block0;
            }
        }
        return invalidMetadataTopics;
    }

    public Cluster cluster() {
        HashSet<String> internalTopics = new HashSet<String>();
        ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        for (TopicMetadata metadata : this.topicMetadata) {
            if (metadata.error != Errors.NONE) continue;
            if (metadata.isInternal) {
                internalTopics.add(metadata.topic);
            }
            for (PartitionMetadata partitionMetadata : metadata.partitionMetadata) {
                partitions.add(new PartitionInfo(metadata.topic, partitionMetadata.partition, partitionMetadata.leader, partitionMetadata.replicas.toArray(new Node[0]), partitionMetadata.isr.toArray(new Node[0]), partitionMetadata.offlineReplicas.toArray(new Node[0])));
            }
        }
        return new Cluster(this.clusterId, this.brokers, partitions, this.topicsByError(Errors.TOPIC_AUTHORIZATION_FAILED), internalTopics, this.controller);
    }

    public Collection<Node> brokers() {
        return this.brokers;
    }

    public Collection<TopicMetadata> topicMetadata() {
        return this.topicMetadata;
    }

    public Node controller() {
        return this.controller;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public static MetadataResponse parse(ByteBuffer buffer, short version) {
        return new MetadataResponse(ApiKeys.METADATA.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.METADATA.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        ArrayList<Struct> brokerArray = new ArrayList<Struct>();
        for (Node node : this.brokers) {
            Struct broker = struct.instance(BROKERS_KEY_NAME);
            broker.set(NODE_ID_KEY_NAME, (Object)node.id());
            broker.set(HOST_KEY_NAME, (Object)node.host());
            broker.set(PORT_KEY_NAME, (Object)node.port());
            if (broker.hasField(RACK_KEY_NAME)) {
                broker.set(RACK_KEY_NAME, (Object)node.rack());
            }
            brokerArray.add(broker);
        }
        struct.set(BROKERS_KEY_NAME, (Object)brokerArray.toArray());
        if (struct.hasField(CONTROLLER_ID_KEY_NAME)) {
            struct.set(CONTROLLER_ID_KEY_NAME, (Object)(this.controller == null ? -1 : this.controller.id()));
        }
        if (struct.hasField(CLUSTER_ID_KEY_NAME)) {
            struct.set(CLUSTER_ID_KEY_NAME, (Object)this.clusterId);
        }
        ArrayList<Struct> topicMetadataArray = new ArrayList<Struct>(this.topicMetadata.size());
        for (TopicMetadata metadata : this.topicMetadata) {
            Struct topicData = struct.instance(TOPIC_METADATA_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, metadata.topic);
            topicData.set(CommonFields.ERROR_CODE, metadata.error.code());
            if (topicData.hasField(IS_INTERNAL_KEY_NAME)) {
                topicData.set(IS_INTERNAL_KEY_NAME, (Object)metadata.isInternal());
            }
            ArrayList<Struct> partitionMetadataArray = new ArrayList<Struct>(metadata.partitionMetadata.size());
            for (PartitionMetadata partitionMetadata : metadata.partitionMetadata()) {
                Object node2;
                Struct partitionData = topicData.instance(PARTITION_METADATA_KEY_NAME);
                partitionData.set(CommonFields.ERROR_CODE, partitionMetadata.error.code());
                partitionData.set(CommonFields.PARTITION_ID, partitionMetadata.partition);
                partitionData.set(LEADER_KEY_NAME, (Object)partitionMetadata.leaderId());
                ArrayList<Integer> replicas = new ArrayList<Integer>(partitionMetadata.replicas.size());
                for (Object node2 : partitionMetadata.replicas) {
                    replicas.add(((Node)node2).id());
                }
                partitionData.set(REPLICAS_KEY_NAME, (Object)replicas.toArray());
                ArrayList<Integer> isr = new ArrayList<Integer>(partitionMetadata.isr.size());
                node2 = partitionMetadata.isr.iterator();
                while (node2.hasNext()) {
                    Node node3 = (Node)node2.next();
                    isr.add(node3.id());
                }
                partitionData.set(ISR_KEY_NAME, (Object)isr.toArray());
                if (partitionData.hasField(OFFLINE_REPLICAS_KEY_NAME)) {
                    ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(partitionMetadata.offlineReplicas.size());
                    for (Node node4 : partitionMetadata.offlineReplicas) {
                        offlineReplicas.add(node4.id());
                    }
                    partitionData.set(OFFLINE_REPLICAS_KEY_NAME, (Object)offlineReplicas.toArray());
                }
                partitionMetadataArray.add(partitionData);
            }
            topicData.set(PARTITION_METADATA_KEY_NAME, (Object)partitionMetadataArray.toArray());
            topicMetadataArray.add(topicData);
        }
        struct.set(TOPIC_METADATA_KEY_NAME, (Object)topicMetadataArray.toArray());
        return struct;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 6;
    }

    static {
        METADATA_RESPONSE_V4 = METADATA_RESPONSE_V3 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(BROKERS_KEY_NAME, new ArrayOf(METADATA_BROKER_V1), "Host and port information for all brokers."), new Field(CLUSTER_ID_KEY_NAME, Type.NULLABLE_STRING, "The cluster id that this broker belongs to."), new Field(CONTROLLER_ID_KEY_NAME, Type.INT32, "The broker id of the controller broker."), new Field(TOPIC_METADATA_KEY_NAME, new ArrayOf(TOPIC_METADATA_V1)));
        METADATA_RESPONSE_V6 = METADATA_RESPONSE_V5 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(BROKERS_KEY_NAME, new ArrayOf(METADATA_BROKER_V1), "Host and port information for all brokers."), new Field(CLUSTER_ID_KEY_NAME, Type.NULLABLE_STRING, "The cluster id that this broker belongs to."), new Field(CONTROLLER_ID_KEY_NAME, Type.INT32, "The broker id of the controller broker."), new Field(TOPIC_METADATA_KEY_NAME, new ArrayOf(TOPIC_METADATA_V2)));
    }

    public static class PartitionMetadata {
        private final Errors error;
        private final int partition;
        private final Node leader;
        private final List<Node> replicas;
        private final List<Node> isr;
        private final List<Node> offlineReplicas;

        public PartitionMetadata(Errors error, int partition2, Node leader, List<Node> replicas, List<Node> isr, List<Node> offlineReplicas) {
            this.error = error;
            this.partition = partition2;
            this.leader = leader;
            this.replicas = replicas;
            this.isr = isr;
            this.offlineReplicas = offlineReplicas;
        }

        public Errors error() {
            return this.error;
        }

        public int partition() {
            return this.partition;
        }

        public int leaderId() {
            return this.leader == null ? -1 : this.leader.id();
        }

        public Node leader() {
            return this.leader;
        }

        public List<Node> replicas() {
            return this.replicas;
        }

        public List<Node> isr() {
            return this.isr;
        }

        public List<Node> offlineReplicas() {
            return this.offlineReplicas;
        }

        public String toString() {
            return "(type=PartitionMetadata, error=" + (Object)((Object)this.error) + ", partition=" + this.partition + ", leader=" + this.leader + ", replicas=" + Utils.join(this.replicas, ",") + ", isr=" + Utils.join(this.isr, ",") + ", offlineReplicas=" + Utils.join(this.offlineReplicas, ",") + ')';
        }
    }

    public static class TopicMetadata {
        private final Errors error;
        private final String topic;
        private final boolean isInternal;
        private final List<PartitionMetadata> partitionMetadata;

        public TopicMetadata(Errors error, String topic, boolean isInternal, List<PartitionMetadata> partitionMetadata) {
            this.error = error;
            this.topic = topic;
            this.isInternal = isInternal;
            this.partitionMetadata = partitionMetadata;
        }

        public Errors error() {
            return this.error;
        }

        public String topic() {
            return this.topic;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public List<PartitionMetadata> partitionMetadata() {
            return this.partitionMetadata;
        }

        public String toString() {
            return "(type=TopicMetadata, error=" + (Object)((Object)this.error) + ", topic=" + this.topic + ", isInternal=" + this.isInternal + ", partitionMetadata=" + this.partitionMetadata + ')';
        }
    }
}

