/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class ControlledShutdownResponse
extends AbstractResponse {
    private static final String PARTITIONS_REMAINING_KEY_NAME = "partitions_remaining";
    private static final Schema CONTROLLED_SHUTDOWN_PARTITION_V0 = new Schema(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID);
    private static final Schema CONTROLLED_SHUTDOWN_RESPONSE_V0;
    private static final Schema CONTROLLED_SHUTDOWN_RESPONSE_V1;
    private final Errors error;
    private final Set<TopicPartition> partitionsRemaining;

    public static Schema[] schemaVersions() {
        return new Schema[]{CONTROLLED_SHUTDOWN_RESPONSE_V0, CONTROLLED_SHUTDOWN_RESPONSE_V1};
    }

    public ControlledShutdownResponse(Errors error, Set<TopicPartition> partitionsRemaining) {
        this.error = error;
        this.partitionsRemaining = partitionsRemaining;
    }

    public ControlledShutdownResponse(Struct struct) {
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
        for (Object topicPartitionObj : struct.getArray(PARTITIONS_REMAINING_KEY_NAME)) {
            Struct topicPartition = (Struct)topicPartitionObj;
            String topic = topicPartition.get(CommonFields.TOPIC_NAME);
            int partition2 = topicPartition.get(CommonFields.PARTITION_ID);
            partitions.add(new TopicPartition(topic, partition2));
        }
        this.partitionsRemaining = partitions;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    public Set<TopicPartition> partitionsRemaining() {
        return this.partitionsRemaining;
    }

    public static ControlledShutdownResponse parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownResponse(ApiKeys.CONTROLLED_SHUTDOWN.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.CONTROLLED_SHUTDOWN.responseSchema(version));
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        ArrayList<Struct> partitionsRemainingList = new ArrayList<Struct>(this.partitionsRemaining.size());
        for (TopicPartition topicPartition : this.partitionsRemaining) {
            Struct topicPartitionStruct = struct.instance(PARTITIONS_REMAINING_KEY_NAME);
            topicPartitionStruct.set(CommonFields.TOPIC_NAME, topicPartition.topic());
            topicPartitionStruct.set(CommonFields.PARTITION_ID, topicPartition.partition());
            partitionsRemainingList.add(topicPartitionStruct);
        }
        struct.set(PARTITIONS_REMAINING_KEY_NAME, (Object)partitionsRemainingList.toArray());
        return struct;
    }

    static {
        CONTROLLED_SHUTDOWN_RESPONSE_V1 = CONTROLLED_SHUTDOWN_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field(PARTITIONS_REMAINING_KEY_NAME, new ArrayOf(CONTROLLED_SHUTDOWN_PARTITION_V0), "The partitions that the broker still leads."));
    }
}

