/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class RedisOutputStream
extends FilterOutputStream {
    protected final byte[] buf;
    protected int count;
    private static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

    public RedisOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public RedisOutputStream(OutputStream out, int size2) {
        super(out);
        if (size2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size2];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void write(byte b) throws IOException {
        if (this.count == this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
        } else {
            if (len >= this.buf.length - this.count) {
                this.flushBuffer();
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        }
    }

    public void writeCrLf() throws IOException {
        if (2 >= this.buf.length - this.count) {
            this.flushBuffer();
        }
        this.buf[this.count++] = 13;
        this.buf[this.count++] = 10;
    }

    public void writeIntCrLf(int value2) throws IOException {
        int r;
        int q;
        if (value2 < 0) {
            this.write((byte)45);
            value2 = -value2;
        }
        int size2 = 0;
        while (value2 > sizeTable[size2]) {
            ++size2;
        }
        if (++size2 >= this.buf.length - this.count) {
            this.flushBuffer();
        }
        int charPos = this.count + size2;
        while (value2 >= 65536) {
            q = value2 / 100;
            r = value2 - ((q << 6) + (q << 5) + (q << 2));
            value2 = q;
            this.buf[--charPos] = DigitOnes[r];
            this.buf[--charPos] = DigitTens[r];
        }
        do {
            q = value2 * 52429 >>> 19;
            r = value2 - ((q << 3) + (q << 1));
            this.buf[--charPos] = digits[r];
        } while ((value2 = q) != 0);
        this.count += size2;
        this.writeCrLf();
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

