/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.BinaryJedisCommands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.Hashing;
import redis.clients.jedis.util.Sharded;

public class BinaryShardedJedis
extends Sharded<Jedis, JedisShardInfo>
implements BinaryJedisCommands {
    private final byte[][] dummyArray = new byte[0][];

    public BinaryShardedJedis(List<JedisShardInfo> shards) {
        super(shards);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Hashing algo) {
        super(shards, algo);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Pattern keyTagPattern) {
        super(shards, keyTagPattern);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(shards, algo, keyTagPattern);
    }

    public void disconnect() {
        for (Jedis jedis : this.getAllShards()) {
            if (!jedis.isConnected()) continue;
            try {
                jedis.quit();
            }
            catch (JedisConnectionException jedisConnectionException) {
                // empty catch block
            }
            try {
                jedis.disconnect();
            }
            catch (JedisConnectionException jedisConnectionException) {}
        }
    }

    protected Jedis create(JedisShardInfo shard) {
        return new Jedis(shard);
    }

    @Override
    public String set(byte[] key, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value2);
    }

    @Override
    public String set(byte[] key, byte[] value2, SetParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value2, params2);
    }

    @Override
    public byte[] get(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.get(key);
    }

    @Override
    public Boolean exists(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.exists(key);
    }

    @Override
    public String type(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.type(key);
    }

    @Override
    public byte[] dump(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.dump(key);
    }

    @Override
    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        Jedis j = (Jedis)this.getShard(key);
        return j.restore(key, ttl, serializedValue);
    }

    @Override
    public String restoreReplace(byte[] key, int ttl, byte[] serializedValue) {
        Jedis j = (Jedis)this.getShard(key);
        return j.restoreReplace(key, ttl, serializedValue);
    }

    @Override
    public Long expire(byte[] key, int seconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expire(key, seconds);
    }

    @Override
    public Long pexpire(byte[] key, long milliseconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpire(key, milliseconds);
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expireAt(key, unixTime);
    }

    @Override
    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Long ttl(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ttl(key);
    }

    @Override
    public Long pttl(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pttl(key);
    }

    @Override
    public Long touch(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.touch(key);
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getSet(key, value2);
    }

    @Override
    public Long setnx(byte[] key, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setnx(key, value2);
    }

    @Override
    public String setex(byte[] key, int seconds, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setex(key, seconds, value2);
    }

    @Override
    public String psetex(byte[] key, long milliseconds, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.psetex(key, milliseconds, value2);
    }

    @Override
    public Long decrBy(byte[] key, long decrement) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decrBy(key, decrement);
    }

    @Override
    public Long decr(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decr(key);
    }

    @Override
    public Long del(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.del(key);
    }

    @Override
    public Long unlink(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.unlink(key);
    }

    @Override
    public Long incrBy(byte[] key, long increment) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrBy(key, increment);
    }

    @Override
    public Double incrByFloat(byte[] key, double increment) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrByFloat(key, increment);
    }

    @Override
    public Long incr(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incr(key);
    }

    @Override
    public Long append(byte[] key, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.append(key, value2);
    }

    @Override
    public byte[] substr(byte[] key, int start2, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.substr(key, start2, end);
    }

    @Override
    public Long hset(byte[] key, byte[] field2, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, field2, value2);
    }

    @Override
    public Long hset(byte[] key, Map<byte[], byte[]> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, hash);
    }

    @Override
    public byte[] hget(byte[] key, byte[] field2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hget(key, field2);
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field2, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hsetnx(key, field2, value2);
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmset(key, hash);
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmget(key, fields);
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field2, long value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrBy(key, field2, value2);
    }

    @Override
    public Double hincrByFloat(byte[] key, byte[] field2, double value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrByFloat(key, field2, value2);
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hexists(key, field2);
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hdel(key, fields);
    }

    @Override
    public Long hlen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hlen(key);
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hkeys(key);
    }

    @Override
    public Collection<byte[]> hvals(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hvals(key);
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hgetAll(key);
    }

    @Override
    public Long rpush(byte[] key, byte[] ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpush(key, strings);
    }

    @Override
    public Long lpush(byte[] key, byte[] ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpush(key, strings);
    }

    @Override
    public Long strlen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.strlen(key);
    }

    @Override
    public Long lpushx(byte[] key, byte[] ... string2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpushx(key, string2);
    }

    @Override
    public Long persist(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.persist(key);
    }

    @Override
    public Long rpushx(byte[] key, byte[] ... string2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpushx(key, string2);
    }

    @Override
    public Long llen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.llen(key);
    }

    @Override
    public List<byte[]> lrange(byte[] key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrange(key, start2, stop);
    }

    @Override
    public String ltrim(byte[] key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ltrim(key, start2, stop);
    }

    @Override
    public byte[] lindex(byte[] key, long index2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lindex(key, index2);
    }

    @Override
    public String lset(byte[] key, long index2, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lset(key, index2, value2);
    }

    @Override
    public Long lrem(byte[] key, long count2, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrem(key, count2, value2);
    }

    @Override
    public byte[] lpop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpop(key);
    }

    @Override
    public byte[] rpop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpop(key);
    }

    @Override
    public Long sadd(byte[] key, byte[] ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sadd(key, members2);
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.smembers(key);
    }

    @Override
    public Long srem(byte[] key, byte[] ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srem(key, members2);
    }

    @Override
    public byte[] spop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key);
    }

    @Override
    public Set<byte[]> spop(byte[] key, long count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key, count2);
    }

    @Override
    public Long scard(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.scard(key);
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sismember(key, member);
    }

    @Override
    public byte[] srandmember(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key);
    }

    @Override
    public List<byte[]> srandmember(byte[] key, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key, count2);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member, params2);
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers);
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers, params2);
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrange(key, start2, stop);
    }

    @Override
    public Long zrem(byte[] key, byte[] ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrem(key, members2);
    }

    @Override
    public Double zincrby(byte[] key, double increment, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, increment, member);
    }

    @Override
    public Double zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, increment, member, params2);
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrank(key, member);
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrank(key, member);
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrange(key, start2, stop);
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeWithScores(key, start2, stop);
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeWithScores(key, start2, stop);
    }

    @Override
    public Long zcard(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcard(key);
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscore(key, member);
    }

    @Override
    public Tuple zpopmax(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zpopmax(key);
    }

    @Override
    public Set<Tuple> zpopmax(byte[] key, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zpopmax(key, count2);
    }

    @Override
    public Tuple zpopmin(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zpopmin(key);
    }

    @Override
    public Set<Tuple> zpopmin(byte[] key, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zpopmin(key, count2);
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key);
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key, sortingParameters);
    }

    @Override
    public Long zcount(byte[] key, double min2, double max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min2, max2);
    }

    @Override
    public Long zcount(byte[] key, byte[] min2, byte[] max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min2, max2);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min2, double max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max2);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min2, double max2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max2, offset, count2);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min2, double max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max2);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min2, double max2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max2, offset, count2);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min2, byte[] max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max2);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max2);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min2, byte[] max2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min2, max2, offset, count2);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min2, byte[] max2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min2, max2, offset, count2);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max2, double min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max2, min2);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max2, double min2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max2, min2, offset, count2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max2, double min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max2, min2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max2, double min2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max2, min2, offset, count2);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max2, byte[] min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max2, min2);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max2, byte[] min2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max2, min2, offset, count2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max2, byte[] min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max2, min2);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max2, byte[] min2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max2, min2, offset, count2);
    }

    @Override
    public Long zremrangeByRank(byte[] key, long start2, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByRank(key, start2, stop);
    }

    @Override
    public Long zremrangeByScore(byte[] key, double min2, double max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, min2, max2);
    }

    @Override
    public Long zremrangeByScore(byte[] key, byte[] min2, byte[] max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, min2, max2);
    }

    @Override
    public Long zlexcount(byte[] key, byte[] min2, byte[] max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zlexcount(key, min2, max2);
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min2, byte[] max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByLex(key, min2, max2);
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min2, byte[] max2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByLex(key, min2, max2, offset, count2);
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max2, byte[] min2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByLex(key, max2, min2);
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max2, byte[] min2, int offset, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByLex(key, max2, min2, offset, count2);
    }

    @Override
    public Long zremrangeByLex(byte[] key, byte[] min2, byte[] max2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByLex(key, min2, max2);
    }

    @Override
    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.linsert(key, where, pivot, value2);
    }

    public ShardedJedisPipeline pipelined() {
        ShardedJedisPipeline pipeline = new ShardedJedisPipeline();
        pipeline.setShardedJedis(this);
        return pipeline;
    }

    public Long objectRefcount(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectRefcount(key);
    }

    public byte[] objectEncoding(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectEncoding(key);
    }

    public Long objectIdletime(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectIdletime(key);
    }

    @Override
    public Boolean setbit(byte[] key, long offset, boolean value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value2);
    }

    @Override
    public Boolean setbit(byte[] key, long offset, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value2);
    }

    @Override
    public Boolean getbit(byte[] key, long offset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getbit(key, offset);
    }

    @Override
    public Long setrange(byte[] key, long offset, byte[] value2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setrange(key, offset, value2);
    }

    @Override
    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getrange(key, startOffset, endOffset);
    }

    @Override
    public Long move(byte[] key, int dbIndex) {
        Jedis j = (Jedis)this.getShard(key);
        return j.move(key, dbIndex);
    }

    @Override
    public byte[] echo(byte[] arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.echo(arg);
    }

    public List<byte[]> brpop(byte[] arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.brpop(new byte[][]{arg});
    }

    public List<byte[]> blpop(byte[] arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.blpop(new byte[][]{arg});
    }

    @Override
    public Long bitcount(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key);
    }

    @Override
    public Long bitcount(byte[] key, long start2, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key, start2, end);
    }

    @Override
    public Long pfadd(byte[] key, byte[] ... elements2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfadd(key, elements2);
    }

    @Override
    public long pfcount(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfcount(key);
    }

    @Override
    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, longitude, latitude, member);
    }

    @Override
    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2);
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2, unit2);
    }

    @Override
    public List<byte[]> geohash(byte[] key, byte[] ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geohash(key, members2);
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geopos(key, members2);
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusReadonly(key, longitude, latitude, radius, unit2);
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit2, param2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusReadonly(key, longitude, latitude, radius, unit2, param2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMemberReadonly(key, member, radius, unit2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit2, param2);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit2, GeoRadiusParam param2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMemberReadonly(key, member, radius, unit2, param2);
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hscan(key, cursor);
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hscan(key, cursor, params2);
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sscan(key, cursor);
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sscan(key, cursor, params2);
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscan(key, cursor);
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscan(key, cursor, params2);
    }

    @Override
    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitfield(key, arguments);
    }

    @Override
    public Long hstrlen(byte[] key, byte[] field2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hstrlen(key, field2);
    }

    @Override
    public byte[] xadd(byte[] key, byte[] id, Map<byte[], byte[]> hash, long maxLen, boolean approximateLength) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xadd(key, id, hash, maxLen, approximateLength);
    }

    @Override
    public Long xlen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xlen(key);
    }

    @Override
    public List<byte[]> xrange(byte[] key, byte[] start2, byte[] end, long count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xrange(key, start2, end, count2);
    }

    @Override
    public List<byte[]> xrevrange(byte[] key, byte[] end, byte[] start2, int count2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xrevrange(key, end, start2, count2);
    }

    @Override
    public Long xack(byte[] key, byte[] group2, byte[] ... ids) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xack(key, group2, ids);
    }

    @Override
    public String xgroupCreate(byte[] key, byte[] consumer, byte[] id, boolean makeStream) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupCreate(key, consumer, id, makeStream);
    }

    @Override
    public String xgroupSetID(byte[] key, byte[] consumer, byte[] id) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupSetID(key, consumer, id);
    }

    @Override
    public Long xgroupDestroy(byte[] key, byte[] consumer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupDestroy(key, consumer);
    }

    @Override
    public String xgroupDelConsumer(byte[] key, byte[] consumer, byte[] consumerName) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupDelConsumer(key, consumer, consumerName);
    }

    @Override
    public Long xdel(byte[] key, byte[] ... ids) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xdel(key, ids);
    }

    @Override
    public Long xtrim(byte[] key, long maxLen, boolean approximateLength) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xtrim(key, maxLen, approximateLength);
    }

    @Override
    public List<byte[]> xpending(byte[] key, byte[] groupname, byte[] start2, byte[] end, int count2, byte[] consumername) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xpending(key, groupname, start2, end, count2, consumername);
    }

    @Override
    public List<byte[]> xclaim(byte[] key, byte[] groupname, byte[] consumername, long minIdleTime, long newIdleTime, int retries, boolean force, byte[][] ids) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xclaim(key, groupname, consumername, minIdleTime, newIdleTime, retries, force, ids);
    }

    public Object sendCommand(ProtocolCommand cmd, byte[] ... args2) {
        byte[] sampleKey = args2.length > 0 ? args2[0] : cmd.getRaw();
        Jedis j = (Jedis)this.getShard(sampleKey);
        return j.sendCommand(cmd, args2);
    }

    public Object sendCommand(ProtocolCommand cmd) {
        return this.sendCommand(cmd, this.dummyArray);
    }
}

