/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.samza.config;

/**
 * The factory for an {@link ConfigLoader} instance to load full job config.
 */
public interface ConfigLoaderFactory {
  /**
   * job.config.loader.properties prefix wraps properties needed for {@link ConfigLoader} to loader config.
   * e.g. PropertiesConfigLoaderFactory will read job.config.loader.properties.path to locate the config file location
   */
  String CONFIG_LOADER_PROPERTIES_PREFIX = "job.config.loader.properties.";

  /**
   * Get an instance of {@link ConfigLoader}
   *
   * @param config start up config which specifies properties needed for the loader to load full job config.
   * @return a config loader instance.
   */
  ConfigLoader getLoader(Config config);
}
