/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.projects;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.royale.compiler.internal.projects.ASProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.problems.DuplicateQNameInSourcePathProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.NonDirectoryInSourcePathProblem;
import org.apache.royale.compiler.problems.OverlappingSourcePathProblem;
import org.apache.royale.compiler.problems.SourcePathNotFoundProblem;
import org.apache.royale.compiler.problems.UnableToListFilesProblem;
import org.apache.royale.compiler.projects.IRoyaleProject;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.utils.DirectoryID;
import org.apache.royale.utils.FilenameNormalization;

public final class SourcePathManager {
    private final ASProject compilerProject;
    private LinkedHashMap<DirectoryID, HashSet<QNameFile>> sourcePaths;
    private Collection<ICompilerProblem> problems;
    private Collection<ICompilerProblem> duplicateQNameProblems;

    public SourcePathManager(ASProject compilerProject) {
        this.compilerProject = compilerProject;
        this.sourcePaths = new LinkedHashMap();
        this.problems = Collections.emptyList();
    }

    public boolean isFileOnSourcePath(File file) {
        for (DirectoryID directory : this.sourcePaths.keySet()) {
            if (!directory.isParentOf(file)) continue;
            return true;
        }
        return false;
    }

    public File getSourcePath(File file) {
        for (DirectoryID directory : this.sourcePaths.keySet()) {
            if (!directory.isParentOf(file)) continue;
            return directory.getFile();
        }
        return null;
    }

    private void accumulateQNameFiles(Set<QNameFile> qNameFiles, File directory, String baseQName, String locale, Collection<ICompilerProblem> problems, int order) {
        assert (directory.isDirectory());
        assert (directory.equals(FilenameNormalization.normalize(directory)));
        File[] files = directory.listFiles();
        if (files == null) {
            problems.add(new UnableToListFilesProblem(directory));
            return;
        }
        for (File file : directory.listFiles()) {
            assert (file.equals(FilenameNormalization.normalize(file)));
            if (file.isDirectory()) {
                this.accumulateQNameFiles(qNameFiles, file, baseQName + file.getName() + ".", locale, problems, order);
                continue;
            }
            if (!this.compilerProject.getSourceCompilationUnitFactory().canCreateCompilationUnit(file)) continue;
            String className = FilenameUtils.getBaseName((String)file.getName());
            String qName = baseQName + className;
            qNameFiles.add(new QNameFile(qName, file, locale, order));
        }
    }

    public static String computeQName(File ancestor, File descendent) {
        assert (ancestor.equals(FilenameNormalization.normalize(ancestor)));
        assert (descendent.equals(FilenameNormalization.normalize(descendent)));
        StringBuilder result = new StringBuilder();
        result.insert(0, FilenameUtils.getBaseName((String)descendent.getPath()));
        for (File current = descendent.getParentFile(); current != null; current = current.getParentFile()) {
            if (current.equals(ancestor)) {
                return result.toString();
            }
            result.insert(0, '.');
            result.insert(0, FilenameUtils.getBaseName((String)current.getPath()));
        }
        return null;
    }

    private static boolean arePathsEqual(File[] newPaths, LinkedHashMap<DirectoryID, HashSet<QNameFile>> oldPaths) {
        if (newPaths.length != oldPaths.size()) {
            return false;
        }
        int i = 0;
        for (DirectoryID oldPath : oldPaths.keySet()) {
            if (!newPaths[i].isDirectory()) {
                return false;
            }
            DirectoryID newDir = new DirectoryID(newPaths[i]);
            if (!newDir.equals(oldPath)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isAncestorOf(File ancestor, File descendent) {
        return SourcePathManager.computeQName(ancestor, descendent) != null;
    }

    void handleChangedSourcePath(File[] newSourcePath) {
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        LinkedHashMap<DirectoryID, HashSet<QNameFile>> newSourcePaths = new LinkedHashMap<DirectoryID, HashSet<QNameFile>>();
        ArrayList newQNameFilesToCreate = new ArrayList();
        int order = 0;
        for (File sourcePathEntry : newSourcePath) {
            if (!sourcePathEntry.isDirectory()) {
                problems.add(new NonDirectoryInSourcePathProblem(sourcePathEntry));
            } else {
                DirectoryID directoryId = new DirectoryID(sourcePathEntry);
                if (!newSourcePaths.containsKey(directoryId)) {
                    HashSet<QNameFile> filesInPath = new HashSet<QNameFile>();
                    newSourcePaths.put(directoryId, filesInPath);
                    for (File descendent : newSourcePath) {
                        if (sourcePathEntry == descendent || !SourcePathManager.isAncestorOf(sourcePathEntry, descendent)) continue;
                        problems.add(new OverlappingSourcePathProblem(sourcePathEntry, descendent));
                    }
                    String locale = null;
                    if (this.compilerProject instanceof IRoyaleProject) {
                        locale = ((IRoyaleProject)((Object)this.compilerProject)).getResourceLocale(sourcePathEntry.getAbsolutePath());
                    }
                    this.accumulateQNameFiles(filesInPath, sourcePathEntry, "", locale, problems, order);
                    Set existingEntriesForSourcePath = (Set)MoreObjects.firstNonNull(this.sourcePaths.get(directoryId), Collections.emptySet());
                    newQNameFilesToCreate.addAll(Sets.difference(filesInPath, (Set)existingEntriesForSourcePath));
                }
            }
            ++order;
        }
        HashSet<ICompilationUnit> unitsToRemove = new HashSet<ICompilationUnit>();
        for (Map.Entry<DirectoryID, HashSet<QNameFile>> e : this.sourcePaths.entrySet()) {
            Set newSourcePathFiles = (Set)MoreObjects.firstNonNull(newSourcePaths.get(e.getKey()), Collections.emptySet());
            Sets.SetView filesToRemove = Sets.difference((Set)e.getValue(), (Set)newSourcePathFiles);
            for (QNameFile qNameFile : filesToRemove) {
                File sourceFile = qNameFile.file;
                Collection sourcePathCompilationUnitsToRemove = Collections2.filter(this.compilerProject.getCompilationUnits(sourceFile.getAbsolutePath()), (Predicate)new Predicate<ICompilationUnit>(){

                    public boolean apply(ICompilationUnit cu) {
                        DefinitionPriority defPriority = (DefinitionPriority)cu.getDefinitionPriority();
                        return defPriority.getBasePriority() == DefinitionPriority.BasePriority.SOURCE_PATH;
                    }

                    public boolean test(ICompilationUnit input) {
                        return this.apply(input);
                    }
                });
                unitsToRemove.addAll(sourcePathCompilationUnitsToRemove);
            }
        }
        this.sourcePaths = newSourcePaths;
        ArrayList<ICompilationUnit> unitsToAdd = new ArrayList<ICompilationUnit>();
        if (!newQNameFilesToCreate.isEmpty()) {
            for (QNameFile qNameFile : newQNameFilesToCreate) {
                ICompilationUnit newCU = this.compilerProject.getSourceCompilationUnitFactory().createCompilationUnit(qNameFile.file, DefinitionPriority.BasePriority.SOURCE_PATH, qNameFile.order, qNameFile.qName, qNameFile.locale);
                if (newCU == null) continue;
                unitsToAdd.add(newCU);
            }
        }
        this.problems = problems;
        this.compilerProject.updateCompilationUnitsForPathChange(unitsToRemove, unitsToAdd);
        this.checkForDuplicateQNames();
    }

    private boolean foundAllCompilationUnits() {
        this.compilerProject.getWorkspace();
        for (Set set : this.sourcePaths.values()) {
            for (QNameFile qNameFile : set) {
                if (!this.compilerProject.getWorkspace().getCompilationUnits(qNameFile.file.getAbsolutePath(), this.compilerProject).isEmpty() || !this.compilerProject.getSourceCompilationUnitFactory().needCompilationUnit(qNameFile.file, qNameFile.qName, qNameFile.locale)) continue;
                return false;
            }
        }
        return true;
    }

    void setSourcePath(File[] newSourcePath) {
        newSourcePath = FilenameNormalization.normalize(newSourcePath);
        try {
            if (SourcePathManager.arePathsEqual(newSourcePath, this.sourcePaths)) {
                return;
            }
            this.handleChangedSourcePath(newSourcePath);
        }
        finally {
            assert (this.foundAllCompilationUnits());
        }
    }

    private Collection<ICompilationUnit> getCompilationUnits(File f) {
        assert (FilenameNormalization.normalize(f).equals(f));
        return Collections2.filter(this.compilerProject.getCompilationUnits(f.getAbsolutePath()), (Predicate)new Predicate<ICompilationUnit>(){

            public boolean apply(ICompilationUnit compilationUnit) {
                DefinitionPriority priority = (DefinitionPriority)compilationUnit.getDefinitionPriority();
                return priority.getBasePriority() == DefinitionPriority.BasePriority.SOURCE_PATH;
            }

            public boolean test(ICompilationUnit input) {
                return this.apply(input);
            }
        });
    }

    public boolean addFile(File f) {
        if (!this.getCompilationUnits(f = FilenameNormalization.normalize(f)).isEmpty()) {
            return false;
        }
        ArrayList<QNameFile> qNameFiles = new ArrayList<QNameFile>(1);
        int order = 0;
        for (Map.Entry<DirectoryID, HashSet<QNameFile>> sourcePathEntry : this.sourcePaths.entrySet()) {
            DirectoryID dir = sourcePathEntry.getKey();
            String qname = SourcePathManager.computeQName(dir.getFile(), f);
            if (qname != null) {
                String locale = null;
                if (this.compilerProject instanceof IRoyaleProject) {
                    locale = ((IRoyaleProject)((Object)this.compilerProject)).getResourceLocale(dir.getFile().getAbsolutePath());
                }
                QNameFile newQNameFile = new QNameFile(qname, f, locale, order);
                sourcePathEntry.getValue().add(newQNameFile);
                qNameFiles.add(newQNameFile);
            }
            ++order;
        }
        if (qNameFiles.isEmpty()) {
            return false;
        }
        ArrayList<ICompilationUnit> unitsToAdd = new ArrayList<ICompilationUnit>();
        for (QNameFile qNameFile : qNameFiles) {
            ICompilationUnit newCU = this.compilerProject.getSourceCompilationUnitFactory().createCompilationUnit(qNameFile.file, DefinitionPriority.BasePriority.SOURCE_PATH, qNameFile.order, qNameFile.qName, qNameFile.locale);
            if (newCU == null) continue;
            unitsToAdd.add(newCU);
        }
        if (unitsToAdd.size() == 0) {
            return false;
        }
        assert (unitsToAdd != null);
        this.compilerProject.updateCompilationUnitsForPathChange(Collections.emptyList(), unitsToAdd);
        this.checkForDuplicateQNames();
        return true;
    }

    private void checkForDuplicateQNames() {
        HashMap<String, HashSet<QNameFile>> qNameMap = new HashMap<String, HashSet<QNameFile>>();
        for (HashSet<QNameFile> qNameFiles : this.sourcePaths.values()) {
            for (QNameFile qNameFile : qNameFiles) {
                HashSet<QNameFile> qNameFilesForQName = (HashSet<QNameFile>)qNameMap.get(qNameFile.qName);
                if (qNameFilesForQName == null) {
                    qNameFilesForQName = new HashSet<QNameFile>(1);
                    qNameMap.put(qNameFile.qName, qNameFilesForQName);
                }
                qNameFilesForQName.add(qNameFile);
            }
        }
        ArrayList<ICompilerProblem> duplicateQNameProblems = new ArrayList<ICompilerProblem>();
        for (Map.Entry qNameMapEntry : qNameMap.entrySet()) {
            Set qNameFiles = (Set)qNameMapEntry.getValue();
            String qName = (String)qNameMapEntry.getKey();
            if (qNameFiles.size() <= 1) continue;
            StringBuilder listString = new StringBuilder();
            int found = 0;
            for (QNameFile qNameFile : qNameFiles) {
                if ("properties".equalsIgnoreCase(FilenameUtils.getExtension((String)qNameFile.file.getAbsolutePath()))) continue;
                if (found++ > 0) {
                    listString.append(", ");
                }
                assert (qName.equals(qNameFile.qName));
                listString.append(qNameFile.file.getAbsolutePath());
            }
            if (found <= true) continue;
            DuplicateQNameInSourcePathProblem problem = new DuplicateQNameInSourcePathProblem(listString.toString(), qName);
            duplicateQNameProblems.add(problem);
        }
        this.duplicateQNameProblems = duplicateQNameProblems.size() > 0 ? duplicateQNameProblems : null;
    }

    public boolean removeFile(File f) {
        Collection<ICompilationUnit> unitsToRemove = this.getCompilationUnits(f);
        if (!unitsToRemove.isEmpty()) {
            List<ICompilationUnit> unitsToAdd = Collections.emptyList();
            this.compilerProject.updateCompilationUnitsForPathChange(unitsToRemove, unitsToAdd);
            this.removeQNames(f);
            if (this.duplicateQNameProblems != null && !this.duplicateQNameProblems.isEmpty()) {
                this.checkForDuplicateQNames();
            }
            return true;
        }
        return false;
    }

    private void removeQNames(File f) {
        for (Map.Entry<DirectoryID, HashSet<QNameFile>> sourcePathEntry : this.sourcePaths.entrySet()) {
            DirectoryID dir = sourcePathEntry.getKey();
            String qname = SourcePathManager.computeQName(dir.getFile(), f);
            if (qname == null) continue;
            Iterator<QNameFile> iter = sourcePathEntry.getValue().iterator();
            while (iter.hasNext()) {
                QNameFile qNameFile = iter.next();
                if (!qNameFile.file.equals(f)) continue;
                iter.remove();
            }
        }
    }

    void collectProblems(Collection<ICompilerProblem> problems) {
        problems.addAll(this.problems);
        if (this.duplicateQNameProblems != null) {
            problems.addAll(this.duplicateQNameProblems);
        }
        for (DirectoryID sourcePath : this.sourcePaths.keySet()) {
            if (sourcePath.getFile().exists()) continue;
            problems.add(new SourcePathNotFoundProblem(sourcePath.getFile().getAbsolutePath()));
        }
    }

    public void collectionCompilationUnitsForRootSourceFile(File rootSourceFile, Collection<ICompilationUnit> units) {
        Collection<ICompilationUnit> compilationUnits = this.compilerProject.getCompilationUnits(rootSourceFile.getAbsolutePath());
        units.addAll(compilationUnits);
    }

    public boolean hasCompilationUnitsForRootSourceFile(File rootSourceFile) {
        Collection<ICompilationUnit> compilationUnits = this.compilerProject.getCompilationUnits(rootSourceFile.getAbsolutePath());
        return compilationUnits.size() > 0;
    }

    String getSourceFileFromSourcePath(String file) {
        DirectoryID sourcePath;
        String sourceFile = null;
        Iterator<DirectoryID> iterator = this.sourcePaths.keySet().iterator();
        while (iterator.hasNext() && (sourceFile = SourcePathManager.getSourceFileInPath((sourcePath = iterator.next()).getFile(), file)) == null) {
        }
        return sourceFile;
    }

    private List<QNameFile> createQNameFilesForFile(File f) {
        ArrayList<QNameFile> qNameFiles = new ArrayList<QNameFile>(1);
        int order = 0;
        for (Map.Entry<DirectoryID, HashSet<QNameFile>> sourcePathEntry : this.sourcePaths.entrySet()) {
            DirectoryID dir = sourcePathEntry.getKey();
            String qname = SourcePathManager.computeQName(dir.getFile(), f);
            if (qname != null) {
                String locale = null;
                if (this.compilerProject instanceof IRoyaleProject) {
                    locale = ((IRoyaleProject)((Object)this.compilerProject)).getResourceLocale(dir.getFile().getAbsolutePath());
                }
                QNameFile newQNameFile = new QNameFile(qname, f, locale, order);
                sourcePathEntry.getValue().add(newQNameFile);
                qNameFiles.add(newQNameFile);
            }
            ++order;
        }
        return qNameFiles;
    }

    QNameFile computeQNameForFilename(String rootSourceFileName) {
        List<QNameFile> qNameFiles = this.createQNameFilesForFile(new File(rootSourceFileName));
        if (qNameFiles.isEmpty()) {
            return null;
        }
        return (QNameFile)Iterables.getFirst(qNameFiles, null);
    }

    public static String getSourceFileInPath(File path, String file) {
        File sourceFile = path != null ? new File(path, file) : new File(file);
        if (sourceFile.exists()) {
            return FilenameNormalization.normalize(sourceFile.getAbsolutePath());
        }
        return null;
    }

    public List<File> getSourcePath() {
        ArrayList<File> paths = new ArrayList<File>(this.sourcePaths.keySet().size());
        for (DirectoryID path : this.sourcePaths.keySet()) {
            paths.add(path.getFile());
        }
        return paths;
    }

    public String toString() {
        return Joiner.on((char)'\n').join(Iterables.transform(this.sourcePaths.keySet(), (Function)new Function<DirectoryID, String>(){

            public String apply(DirectoryID input) {
                return input.getFile().getAbsolutePath();
            }
        }));
    }

    public static class QNameFile {
        final String qName;
        final File file;
        final String locale;
        final int order;

        QNameFile(String qName, File file, String locale, int order) {
            this.qName = qName;
            this.file = file;
            this.locale = locale;
            this.order = order;
        }

        public int hashCode() {
            return this.qName.hashCode() + this.file.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof QNameFile)) {
                return false;
            }
            QNameFile otherQNameFile = (QNameFile)other;
            return this.qName.equals(otherQNameFile.qName) && this.file.equals(otherQNameFile.file);
        }

        public String toString() {
            return "QNameFile qName:" + this.qName + " file:" + this.file;
        }
    }
}

