////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

package mx.core
{


/**
 *  The IVisualElementContainer interface defines the minimum properties and methods 
 *  required for a container to manage Spark components for display.
 *
 *  <p>Note that the Spark SkinnableDataContainer and DataGroup containers 
 *  do not implement this interface. 
 *  Those containers manage their 
 *  children through the <code>dataProvider</code> property.</p>
 *
 *  @see mx.core.IVisualElement
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Royale 0.9.3
 */
public interface IVisualElementContainer
{
   
}

}
