/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSDocEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.tree.as.TypedExpressionNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.ITypeNode;

public class InterfaceEmitter
extends JSSubEmitter
implements ISubEmitter<IInterfaceNode> {
    public InterfaceEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IInterfaceNode node) {
        IDefinitionNode[] members;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        ICompilerProject project = this.getWalker().getProject();
        fjs.getDocEmitter().emitInterfaceDoc(node, project);
        String qname = node.getQualifiedName();
        if (qname != null && !qname.equals("")) {
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.FUNCTION);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
        JSRoyaleDocEmitter doc = (JSRoyaleDocEmitter)this.getEmitter().getDocEmitter();
        for (IDefinitionNode mnode : members = node.getAllMemberDefinitionNodes()) {
            boolean isAccessor = mnode.getNodeID() == ASTNodeID.GetterID || mnode.getNodeID() == ASTNodeID.SetterID;
            String memberName = mnode.getQualifiedName();
            if (isAccessor && this.getModel().getInterfacePropertyMap().contains(memberName)) continue;
            this.writeNewline();
            if (isAccessor) {
                IAccessorNode accessor = (IAccessorNode)mnode;
                String propType = accessor.getVariableType();
                IExpressionNode typeNode = accessor.getVariableTypeNode();
                ITypeDefinition typeDef = typeNode.resolveType(project);
                String packageName = typeDef.getPackageName();
                packageName = project.getActualPackageName(packageName);
                if (typeNode instanceof TypedExpressionNode) {
                    propType = "Vector.<" + JSGoogDocEmitter.convertASTypeToJSType(((TypedExpressionNode)typeNode).getTypeNode().resolveType(project).getQualifiedName(), "") + ">";
                    packageName = "";
                }
                this.write(JSDocEmitterTokens.JSDOC_OPEN);
                this.write(ASEmitterTokens.SPACE);
                fjs.getDocEmitter().emitType(propType, packageName);
                this.write(ASEmitterTokens.SPACE);
                this.write(JSDocEmitterTokens.JSDOC_CLOSE);
            } else {
                doc.emitMethodDoc((IFunctionNode)mnode, project);
            }
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(memberName);
            if (isAccessor && !this.getModel().getInterfacePropertyMap().contains(memberName)) {
                this.getModel().getInterfacePropertyMap().add(memberName);
            } else {
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.FUNCTION);
                fjs.emitParameters(((IFunctionNode)mnode).getParametersContainerNode());
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.BLOCK_OPEN);
                this.writeNewline();
                this.write(ASEmitterTokens.BLOCK_CLOSE);
            }
            this.write(ASEmitterTokens.SEMICOLON);
        }
        fjs.getPackageFooterEmitter().emitClassInfo((ITypeNode)node);
    }
}

