/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.Escaper;
import java.util.HashMap;

public final class SourceCodeEscapers {
    private static final char PRINTABLE_ASCII_MIN = ' ';
    private static final char PRINTABLE_ASCII_MAX = '~';
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final Escaper JAVASCRIPT_ESCAPER;

    private SourceCodeEscapers() {
    }

    public static Escaper javascriptEscaper() {
        return JAVASCRIPT_ESCAPER;
    }

    private static char[] asUnicodeHexEscape(char c) {
        char[] r = new char[6];
        r[0] = 92;
        r[1] = 117;
        r[5] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[4] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[3] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[2] = HEX_DIGITS[c & 0xF];
        return r;
    }

    static {
        HashMap<Character, String> jsMap = new HashMap<Character, String>();
        jsMap.put(Character.valueOf('\''), "\\x27");
        jsMap.put(Character.valueOf('\"'), "\\x22");
        jsMap.put(Character.valueOf('<'), "\\x3c");
        jsMap.put(Character.valueOf('='), "\\x3d");
        jsMap.put(Character.valueOf('>'), "\\x3e");
        jsMap.put(Character.valueOf('&'), "\\x26");
        jsMap.put(Character.valueOf('\b'), "\\b");
        jsMap.put(Character.valueOf('\t'), "\\t");
        jsMap.put(Character.valueOf('\n'), "\\n");
        jsMap.put(Character.valueOf('\f'), "\\f");
        jsMap.put(Character.valueOf('\r'), "\\r");
        jsMap.put(Character.valueOf('\\'), "\\\\");
        JAVASCRIPT_ESCAPER = new ArrayBasedCharEscaper(jsMap, ' ', '~'){

            @Override
            protected char[] escapeUnsafe(char c) {
                if (c < '\u0100') {
                    char[] r = new char[4];
                    r[3] = HEX_DIGITS[c & 0xF];
                    c = (char)(c >>> 4);
                    r[2] = HEX_DIGITS[c & 0xF];
                    r[1] = 120;
                    r[0] = 92;
                    return r;
                }
                return SourceCodeEscapers.asUnicodeHexEscape(c);
            }
        };
    }
}

