/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

import org.apache.royale.abc.semantics.ArbitraryOperandsInstruction;
import org.apache.royale.abc.semantics.ImmediateOperandInstruction;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.NoOperandsInstruction;
import org.apache.royale.abc.semantics.OneOperandInstruction;

public abstract class InstructionFactory {
    private static final Instruction s_add = new NoOperandsInstruction(160);
    private static final Instruction s_astypelate = new NoOperandsInstruction(135);
    private static final Instruction s_bitand = new NoOperandsInstruction(168);
    private static final Instruction s_bitnot = new NoOperandsInstruction(151);
    private static final Instruction s_bitor = new NoOperandsInstruction(169);
    private static final Instruction s_bitxor = new NoOperandsInstruction(170);
    private static final Instruction s_checkfilter = new NoOperandsInstruction(120);
    private static final Instruction s_coerce = new NoOperandsInstruction(128);
    private static final Instruction s_coerce_a = new NoOperandsInstruction(130);
    private static final Instruction s_coerce_s = new NoOperandsInstruction(133);
    private static final Instruction s_convert_b = new NoOperandsInstruction(118);
    private static final Instruction s_convert_d = new NoOperandsInstruction(117);
    private static final Instruction s_convert_i = new NoOperandsInstruction(115);
    private static final Instruction s_convert_o = new NoOperandsInstruction(119);
    private static final Instruction s_convert_s = new NoOperandsInstruction(112);
    private static final Instruction s_convert_u = new NoOperandsInstruction(116);
    private static final Instruction s_decrement = new NoOperandsInstruction(147);
    private static final Instruction s_decrement_i = new NoOperandsInstruction(193);
    private static final Instruction s_divide = new NoOperandsInstruction(163);
    private static final Instruction s_dup = new NoOperandsInstruction(42);
    private static final Instruction s_dxnslate = new NoOperandsInstruction(7);
    private static final Instruction s_equals = new NoOperandsInstruction(171);
    private static final Instruction s_esc_xattr = new NoOperandsInstruction(114);
    private static final Instruction s_esc_xelem = new NoOperandsInstruction(113);
    private static final Instruction s_getglobalscope = new NoOperandsInstruction(100);
    private static final Instruction s_getlocal0 = new NoOperandsInstruction(208);
    private static final Instruction s_getlocal1 = new NoOperandsInstruction(209);
    private static final Instruction s_getlocal2 = new NoOperandsInstruction(210);
    private static final Instruction s_getlocal3 = new NoOperandsInstruction(211);
    private static final Instruction s_greaterequals = new NoOperandsInstruction(176);
    private static final Instruction s_greaterthan = new NoOperandsInstruction(175);
    private static final Instruction s_hasnext = new NoOperandsInstruction(31);
    private static final Instruction s_in = new NoOperandsInstruction(180);
    private static final Instruction s_increment = new NoOperandsInstruction(145);
    private static final Instruction s_increment_i = new NoOperandsInstruction(192);
    private static final Instruction s_instanceof = new NoOperandsInstruction(177);
    private static final Instruction s_istypelate = new NoOperandsInstruction(179);
    private static final Instruction s_label = new NoOperandsInstruction(9);
    private static final Instruction s_lessequals = new NoOperandsInstruction(174);
    private static final Instruction s_lessthan = new NoOperandsInstruction(173);
    private static final Instruction s_lshift = new NoOperandsInstruction(165);
    private static final Instruction s_modulo = new NoOperandsInstruction(164);
    private static final Instruction s_multiply = new NoOperandsInstruction(162);
    private static final Instruction s_multiply_i = new NoOperandsInstruction(199);
    private static final Instruction s_negate = new NoOperandsInstruction(144);
    private static final Instruction s_negate_i = new NoOperandsInstruction(196);
    private static final Instruction s_newactivation = new NoOperandsInstruction(87);
    private static final Instruction s_nextname = new NoOperandsInstruction(30);
    private static final Instruction s_nextvalue = new NoOperandsInstruction(35);
    private static final Instruction s_nop = new NoOperandsInstruction(2);
    private static final Instruction s_not = new NoOperandsInstruction(150);
    private static final Instruction s_pop = new NoOperandsInstruction(41);
    private static final Instruction s_popscope = new NoOperandsInstruction(29);
    private static final Instruction s_pushfalse = new NoOperandsInstruction(39);
    private static final Instruction s_pushnan = new NoOperandsInstruction(40);
    private static final Instruction s_pushnull = new NoOperandsInstruction(32);
    private static final Instruction s_pushscope = new NoOperandsInstruction(48);
    private static final Instruction s_pushtrue = new NoOperandsInstruction(38);
    private static final Instruction s_pushundefined = new NoOperandsInstruction(33);
    private static final Instruction s_pushwith = new NoOperandsInstruction(28);
    private static final Instruction s_returnvalue = new NoOperandsInstruction(72);
    private static final Instruction s_returnvoid = new NoOperandsInstruction(71);
    private static final Instruction s_rshift = new NoOperandsInstruction(166);
    private static final Instruction s_setlocal0 = new NoOperandsInstruction(212);
    private static final Instruction s_setlocal1 = new NoOperandsInstruction(213);
    private static final Instruction s_setlocal2 = new NoOperandsInstruction(214);
    private static final Instruction s_setlocal3 = new NoOperandsInstruction(215);
    private static final Instruction s_strictequals = new NoOperandsInstruction(172);
    private static final Instruction s_subtract = new NoOperandsInstruction(161);
    private static final Instruction s_subtract_i = new NoOperandsInstruction(198);
    private static final Instruction s_swap = new NoOperandsInstruction(43);
    private static final Instruction s_throw = new NoOperandsInstruction(3);
    private static final Instruction s_typeof = new NoOperandsInstruction(149);
    private static final Instruction s_urshift = new NoOperandsInstruction(167);
    private static final Instruction s_unplus = new NoOperandsInstruction(122);
    private static final Object[] NO_OPERANDS = new Object[0];

    public static final Instruction getInstruction(int opcode) {
        switch (opcode) {
            case 160: {
                return s_add;
            }
            case 135: {
                return s_astypelate;
            }
            case 168: {
                return s_bitand;
            }
            case 151: {
                return s_bitnot;
            }
            case 169: {
                return s_bitor;
            }
            case 170: {
                return s_bitxor;
            }
            case 120: {
                return s_checkfilter;
            }
            case 128: {
                return s_coerce;
            }
            case 130: {
                return s_coerce_a;
            }
            case 133: {
                return s_coerce_s;
            }
            case 118: {
                return s_convert_b;
            }
            case 117: {
                return s_convert_d;
            }
            case 115: {
                return s_convert_i;
            }
            case 119: {
                return s_convert_o;
            }
            case 112: {
                return s_convert_s;
            }
            case 116: {
                return s_convert_u;
            }
            case 147: {
                return s_decrement;
            }
            case 193: {
                return s_decrement_i;
            }
            case 163: {
                return s_divide;
            }
            case 42: {
                return s_dup;
            }
            case 7: {
                return s_dxnslate;
            }
            case 171: {
                return s_equals;
            }
            case 114: {
                return s_esc_xattr;
            }
            case 113: {
                return s_esc_xelem;
            }
            case 100: {
                return s_getglobalscope;
            }
            case 208: {
                return s_getlocal0;
            }
            case 209: {
                return s_getlocal1;
            }
            case 210: {
                return s_getlocal2;
            }
            case 211: {
                return s_getlocal3;
            }
            case 176: {
                return s_greaterequals;
            }
            case 175: {
                return s_greaterthan;
            }
            case 31: {
                return s_hasnext;
            }
            case 180: {
                return s_in;
            }
            case 145: {
                return s_increment;
            }
            case 192: {
                return s_increment_i;
            }
            case 177: {
                return s_instanceof;
            }
            case 179: {
                return s_istypelate;
            }
            case 9: {
                return s_label;
            }
            case 174: {
                return s_lessequals;
            }
            case 173: {
                return s_lessthan;
            }
            case 165: {
                return s_lshift;
            }
            case 164: {
                return s_modulo;
            }
            case 162: {
                return s_multiply;
            }
            case 199: {
                return s_multiply_i;
            }
            case 144: {
                return s_negate;
            }
            case 196: {
                return s_negate_i;
            }
            case 87: {
                return s_newactivation;
            }
            case 30: {
                return s_nextname;
            }
            case 35: {
                return s_nextvalue;
            }
            case 2: {
                return s_nop;
            }
            case 150: {
                return s_not;
            }
            case 41: {
                return s_pop;
            }
            case 29: {
                return s_popscope;
            }
            case 39: {
                return s_pushfalse;
            }
            case 40: {
                return s_pushnan;
            }
            case 32: {
                return s_pushnull;
            }
            case 48: {
                return s_pushscope;
            }
            case 38: {
                return s_pushtrue;
            }
            case 33: {
                return s_pushundefined;
            }
            case 28: {
                return s_pushwith;
            }
            case 72: {
                return s_returnvalue;
            }
            case 71: {
                return s_returnvoid;
            }
            case 166: {
                return s_rshift;
            }
            case 212: {
                return s_setlocal0;
            }
            case 213: {
                return s_setlocal1;
            }
            case 214: {
                return s_setlocal2;
            }
            case 215: {
                return s_setlocal3;
            }
            case 172: {
                return s_strictequals;
            }
            case 161: {
                return s_subtract;
            }
            case 198: {
                return s_subtract_i;
            }
            case 43: {
                return s_swap;
            }
            case 3: {
                return s_throw;
            }
            case 149: {
                return s_typeof;
            }
            case 167: {
                return s_urshift;
            }
            case 122: {
                return s_unplus;
            }
        }
        return new ArbitraryOperandsInstruction(opcode, NO_OPERANDS);
    }

    public static final Instruction getInstruction(int opcode, int immediate) {
        return new ImmediateOperandInstruction(opcode, immediate);
    }

    public static final Instruction getDeferredImmediateInstruction(int opcode) {
        return new ImmediateOperandInstruction(opcode);
    }

    public static final Instruction getInstruction(int opcode, Object singleOperand) {
        return new OneOperandInstruction(opcode, singleOperand);
    }

    public static final Instruction getTargetableInstruction(int opcode) {
        return new OneOperandInstruction(opcode);
    }

    public static final Instruction getInstruction(int opcode, Object[] operands) {
        return new ArbitraryOperandsInstruction(opcode, operands);
    }

    public static final Instruction getHasnext2Instruction() {
        return new ArbitraryOperandsInstruction(50, NO_OPERANDS);
    }

    public static final Instruction createModifiedInstruction(int opcode, Instruction original) {
        if (original instanceof ArbitraryOperandsInstruction) {
            return new ArbitraryOperandsInstruction(opcode, (ArbitraryOperandsInstruction)original);
        }
        if (original instanceof OneOperandInstruction) {
            return InstructionFactory.getInstruction(opcode, original.getOperand(0));
        }
        if (original instanceof ImmediateOperandInstruction) {
            return InstructionFactory.getInstruction(opcode, original.getImmediate());
        }
        return InstructionFactory.getInstruction(opcode);
    }
}

