/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Selectors;
import com.microsoft.playwright.impl.LoggingSupport;
import com.microsoft.playwright.impl.SelectorsImpl;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class SharedSelectors
extends LoggingSupport
implements Selectors {
    private final List<SelectorsImpl> channels = new ArrayList<SelectorsImpl>();
    private final List<Registration> registrations = new ArrayList<Registration>();

    @Override
    public void register(String name, String script, Selectors.RegisterOptions options) {
        this.withLogging("Selectors.register", () -> this.registerImpl(name, script, options));
    }

    @Override
    public void register(String name, Path path, Selectors.RegisterOptions options) {
        this.withLogging("Selectors.register", () -> {
            byte[] buffer;
            try {
                buffer = Files.readAllBytes(path);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read selector from file: " + path, e);
            }
            this.registerImpl(name, new String(buffer, StandardCharsets.UTF_8), options);
        });
    }

    void addChannel(SelectorsImpl channel) {
        this.registrations.forEach(r -> channel.registerImpl(r.name, r.script, r.options));
        this.channels.add(channel);
    }

    void removeChannel(SelectorsImpl channel) {
        this.channels.remove(channel);
    }

    private void registerImpl(String name, String script, Selectors.RegisterOptions options) {
        this.channels.forEach(impl -> impl.registerImpl(name, script, options));
        this.registrations.add(new Registration(name, script, options));
    }

    private static class Registration {
        final String name;
        final String script;
        final Selectors.RegisterOptions options;

        Registration(String name, String script, Selectors.RegisterOptions options) {
            this.name = name;
            this.script = script;
            this.options = options;
        }
    }
}

