/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.embedding.transcoders.MovieTranscoder;
import org.apache.royale.compiler.internal.embedding.transcoders.TranscoderBase;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.targets.RoyaleFontInfo;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnit;
import org.apache.royale.compiler.internal.units.ResourceBundleCompilationUnit;
import org.apache.royale.compiler.problems.DependencyNotCompatibleProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.swc.ISWC;

abstract class RoyaleFrame1Info {
    protected final RoyaleProject royaleProject;
    private final ClassDefinition resourceBundleDefinition;
    final TreeSet<String> compiledResourceBundleNames;
    final TreeMap<String, RoyaleFontInfo> embeddedFonts;
    final ArrayList<ICompilerProblem> problems;

    protected RoyaleFrame1Info(RoyaleProject royaleProject) {
        this.royaleProject = royaleProject;
        IResolvedQualifiersReference resourceBundleRef = ReferenceFactory.packageQualifiedReference(royaleProject.getWorkspace(), royaleProject.getResourceBundleClass());
        this.resourceBundleDefinition = (ClassDefinition)resourceBundleRef.resolve(royaleProject);
        this.compiledResourceBundleNames = new TreeSet();
        this.embeddedFonts = new TreeMap();
        this.problems = new ArrayList();
    }

    protected final void collectFromCompilationUnits(Iterable<ICompilationUnit> builtCompilationUnits) throws InterruptedException {
        for (ICompilationUnit cu : builtCompilationUnits) {
            this.collectFromCompilationUnit(cu);
        }
    }

    protected void collectFromCompilationUnit(ICompilationUnit cu) throws InterruptedException {
        if (this.resourceBundleDefinition != null) {
            this.collectCompiledResourceBundleNames(cu);
        }
        this.collectEmbeddedFonts(cu);
        this.checkSWCVersioningFilter(this.problems, cu);
    }

    private final void collectEmbeddedFonts(ICompilationUnit compilationUnit) {
        if (!(compilationUnit instanceof EmbedCompilationUnit)) {
            return;
        }
        TranscoderBase transcoder = (TranscoderBase)((EmbedCompilationUnit)compilationUnit).getEmbedData().getTranscoder();
        if (!(transcoder instanceof MovieTranscoder)) {
            return;
        }
        MovieTranscoder movieTranscoder = (MovieTranscoder)transcoder;
        RoyaleFontInfo royaleFontInfo = movieTranscoder.getRoyaleFontInfo();
        if (royaleFontInfo != null) {
            this.embeddedFonts.put(movieTranscoder.getSymbol(), royaleFontInfo);
        }
    }

    private void collectCompiledResourceBundleNames(ICompilationUnit compilationUnit) throws InterruptedException {
        if (compilationUnit instanceof ResourceBundleCompilationUnit) {
            this.compiledResourceBundleNames.add(((ResourceBundleCompilationUnit)compilationUnit).getBundleNameInColonSyntax());
        } else {
            IFileScopeRequestResult result = compilationUnit.getFileScopeRequest().get();
            for (IDefinition def : result.getExternallyVisibleDefinitions()) {
                ClassDefinition classDef;
                if (!(def instanceof ClassDefinition) || this.resourceBundleDefinition.equals(classDef = (ClassDefinition)def) || !classDef.isInstanceOf(this.resourceBundleDefinition, (ICompilerProject)this.royaleProject)) continue;
                this.compiledResourceBundleNames.add(def.getQualifiedName());
            }
        }
    }

    private void checkSWCVersioningFilter(ArrayList<ICompilerProblem> problems, ICompilationUnit cu) throws InterruptedException {
        Integer compatibilityVersion = this.royaleProject.getCompatibilityVersion();
        if (compatibilityVersion == null) {
            return;
        }
        if (cu.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT) {
            return;
        }
        Set<ICompilationUnit> dependencies = this.royaleProject.getDependencies(cu);
        for (ICompilationUnit dependency : dependencies) {
            if (dependency.getCompilationUnitType() != ICompilationUnit.UnitType.SWC_UNIT) continue;
            ISWC swc = this.royaleProject.getWorkspace().getSWCManager().get(new File(dependency.getAbsoluteFilename()));
            int royaleMinSupportedVersion = swc.getVersion().getRoyaleMinSupportedVersionInt();
            if (compatibilityVersion >= royaleMinSupportedVersion) continue;
            problems.add(new DependencyNotCompatibleProblem(dependency.getQualifiedNames().get(0), dependency.getAbsoluteFilename(), swc.getVersion().getRoyaleMinSupportedVersion(), this.royaleProject.getCompatibilityVersionString()));
        }
    }

    Set<String> getMixins() {
        return Collections.emptySet();
    }
}

