/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.ModuleMetadataMap;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Export;
import javax.annotation.Nullable;

final class ModuleRenaming {
    private static final String DEFAULT_EXPORT_VAR_PREFIX = "$jscompDefaultExport";

    private ModuleRenaming() {
    }

    static String getGlobalName(ModuleMetadataMap.ModuleMetadata moduleMetadata, @Nullable String googNamespace) {
        Preconditions.checkState(googNamespace == null || moduleMetadata.googNamespaces().contains(googNamespace));
        switch (moduleMetadata.moduleType()) {
            case GOOG_MODULE: {
                return ClosureRewriteModule.getBinaryModuleNamespace(googNamespace);
            }
            case GOOG_PROVIDE: 
            case LEGACY_GOOG_MODULE: {
                return googNamespace;
            }
            case ES6_MODULE: 
            case COMMON_JS: {
                return moduleMetadata.path().toModuleName();
            }
        }
        throw new IllegalStateException("Unexpected module type: " + (Object)((Object)moduleMetadata.moduleType()));
    }

    static String getGlobalName(Export export) {
        if (export.moduleMetadata().isEs6Module()) {
            String prefix = Preconditions.checkNotNull(export.localName());
            if (export.localName().equals("*default*")) {
                prefix = DEFAULT_EXPORT_VAR_PREFIX;
            }
            return prefix + "$$" + ModuleRenaming.getGlobalName(export.moduleMetadata(), null);
        }
        return ModuleRenaming.getGlobalName(export.moduleMetadata(), export.closureNamespace()) + "." + export.localName();
    }

    static String getGlobalName(Binding binding) {
        if (binding.isModuleNamespace()) {
            return ModuleRenaming.getGlobalName(binding.metadata(), binding.closureNamespace());
        }
        return ModuleRenaming.getGlobalName(binding.originatingExport());
    }
}

