/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.config;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.common.IPathResolver;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.annotations.Arguments;
import org.apache.royale.compiler.internal.config.annotations.Config;
import org.apache.royale.compiler.internal.config.annotations.InfiniteArguments;
import org.apache.royale.compiler.internal.config.annotations.Mapping;
import org.apache.royale.compiler.problems.DeprecatedConfigurationOptionProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.RemovedConfigurationOptionProblem;
import org.apache.royale.linter.config.ConfigurationBuffer;
import org.apache.royale.linter.config.ConfigurationInfo;
import org.apache.royale.linter.config.ConfigurationValue;
import org.apache.royale.linter.config.LineCommentPosition;
import org.apache.royale.utils.FilenameNormalization;

public class Configuration {
    private static Map<String, String> aliases = null;
    private IPathResolver pathResolver;
    private Collection<ICompilerProblem> configurationProblems = new ArrayList<ICompilerProblem>();
    private String configFile = null;
    private List<String> files = new ArrayList<String>();
    private boolean skipLocalConfigFile = false;
    private boolean ignoreParsingProblems = false;
    private boolean className = false;
    private boolean constantName = false;
    private boolean emptyComment = false;
    private boolean emptyFunctionBody = false;
    private boolean emptyNestedBlock = false;
    private boolean emptyStatement = true;
    private boolean fieldName = false;
    private boolean functionName = false;
    private boolean interfaceName = false;
    private LineCommentPosition lineCommentPosition = null;
    private boolean localVarParamName = false;
    private boolean localVarShadowsField = false;
    private int maxBlockDepth = 0;
    private int maxParams = 0;
    private boolean missingAsdoc = false;
    private boolean missingConstructorSuper = false;
    private boolean missingNamespace = false;
    private boolean missingSemicolon = false;
    private boolean missingType = false;
    private boolean mxmlEmptyAttr = false;
    private boolean mxmlId = false;
    private boolean noAnyType = false;
    private boolean noBooleanEquality = false;
    private boolean noConstructorDispatch = false;
    private boolean noConstructorReturnType = false;
    private boolean noDuplicateKeys = true;
    private boolean noDynamicClass = false;
    private boolean noIfBoolean = true;
    private boolean noLeadingZero = true;
    private boolean noSparseArray = true;
    private boolean noStringEvent = false;
    private boolean noThisClosure = false;
    private boolean noTrace = false;
    private boolean noVoidOperator = false;
    private boolean noWildcardImport = false;
    private boolean noWith = true;
    private boolean overrideSuper = false;
    private boolean packageName = false;
    private boolean staticConstants = false;
    private boolean strictEquality = false;
    private boolean switchDefault = false;
    private boolean unsafeNegation = true;
    private boolean validTypeof = true;
    private boolean varsOnTop = false;

    public static Map<String, String> getAliases() {
        if (aliases == null) {
            aliases = new HashMap<String, String>();
        }
        return aliases;
    }

    public void setPathResolver(IPathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    public Collection<ICompilerProblem> getConfigurationProblems() {
        return this.configurationProblems;
    }

    public void validate(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        this.processDeprecatedAndRemovedOptions(configurationBuffer);
    }

    private void processDeprecatedAndRemovedOptions(ConfigurationBuffer configurationBuffer) {
        for (String var : configurationBuffer.getVars()) {
            ConfigurationInfo info = configurationBuffer.getInfo(var);
            List<ConfigurationValue> values = configurationBuffer.getVar(var);
            if (values == null) continue;
            for (ConfigurationValue cv : values) {
                if (info.isRemoved()) {
                    this.addRemovedConfigurationOptionProblem(cv);
                    continue;
                }
                if (!info.isDeprecated() || configurationBuffer.getVar(var) == null) continue;
                String replacement = info.getDeprecatedReplacement();
                String since = info.getDeprecatedSince();
                DeprecatedConfigurationOptionProblem problem = new DeprecatedConfigurationOptionProblem(var, replacement, since, cv.getSource(), cv.getLine());
                this.configurationProblems.add((ICompilerProblem)problem);
            }
        }
    }

    private void addRemovedConfigurationOptionProblem(ConfigurationValue cv) {
        RemovedConfigurationOptionProblem problem = new RemovedConfigurationOptionProblem(cv.getVar(), cv.getSource(), cv.getLine());
        this.configurationProblems.add((ICompilerProblem)problem);
    }

    @Config(displayed=false, greedy=true)
    @Arguments(value={"keyword"})
    @InfiniteArguments
    public void setHelp(ConfigurationValue cv, String[] keywords) {
    }

    @Config
    public void setVersion(ConfigurationValue cv, boolean value) {
    }

    public String getLoadConfig() {
        return this.configFile;
    }

    @Config(allowMultiple=true)
    @Arguments(value={"filename"})
    public void setLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.configFile = this.resolvePathStrict(filename, cv);
    }

    public List<String> getFiles() {
        return this.files;
    }

    @Config(allowMultiple=true, hidden=true)
    @Mapping(value={"files"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setFiles(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.files.addAll(args);
    }

    public boolean getSkipLocalConfigFile() {
        return this.skipLocalConfigFile;
    }

    @Config
    @Mapping(value={"skip-local-config-file"})
    public void setSkipLocalConfigFile(ConfigurationValue cv, boolean b) {
        this.skipLocalConfigFile = b;
    }

    public boolean getIgnoreParsingProblems() {
        return this.ignoreParsingProblems;
    }

    @Config(advanced=true)
    @Mapping(value={"ignore-parsing-problems"})
    public void setIgnoreParsingProblems(ConfigurationValue cv, boolean b) {
        this.ignoreParsingProblems = b;
    }

    public boolean getClassName() {
        return this.className;
    }

    @Config
    @Mapping(value={"class-name"})
    public void setClassName(ConfigurationValue cv, boolean b) {
        this.className = b;
    }

    public boolean getConstantName() {
        return this.constantName;
    }

    @Config
    @Mapping(value={"constant-name"})
    public void setConstantName(ConfigurationValue cv, boolean b) {
        this.constantName = b;
    }

    public boolean getEmptyComment() {
        return this.emptyComment;
    }

    @Config
    @Mapping(value={"empty-comment"})
    public void setEmptyComment(ConfigurationValue cv, boolean b) {
        this.emptyComment = b;
    }

    public boolean getEmptyFunctionBody() {
        return this.emptyFunctionBody;
    }

    @Config
    @Mapping(value={"empty-function-body"})
    public void setEmptyFunctionBody(ConfigurationValue cv, boolean b) {
        this.emptyFunctionBody = b;
    }

    public boolean getEmptyNestedBlock() {
        return this.emptyNestedBlock;
    }

    @Config
    @Mapping(value={"empty-nested-block"})
    public void setEmptyNestedBlock(ConfigurationValue cv, boolean b) {
        this.emptyNestedBlock = b;
    }

    public boolean getEmptyStatement() {
        return this.emptyStatement;
    }

    @Config
    @Mapping(value={"empty-statement"})
    public void setEmptyStatement(ConfigurationValue cv, boolean b) {
        this.emptyStatement = b;
    }

    public boolean getFieldName() {
        return this.fieldName;
    }

    @Config
    @Mapping(value={"field-name"})
    public void setFieldName(ConfigurationValue cv, boolean b) {
        this.fieldName = b;
    }

    public boolean getFunctionName() {
        return this.functionName;
    }

    @Config
    @Mapping(value={"function-name"})
    public void setFunctionName(ConfigurationValue cv, boolean b) {
        this.functionName = b;
    }

    public boolean getInterfaceName() {
        return this.interfaceName;
    }

    @Config
    @Mapping(value={"interface-name"})
    public void setInterfaceName(ConfigurationValue cv, boolean b) {
        this.interfaceName = b;
    }

    public String getLineCommentPosition() {
        if (this.lineCommentPosition == null) {
            return null;
        }
        return this.lineCommentPosition.getPosition();
    }

    @Config
    @Mapping(value={"line-comment-position"})
    public void setLineCommentPosition(ConfigurationValue cv, String s) {
        this.lineCommentPosition = LineCommentPosition.valueOf(s.toUpperCase());
    }

    public boolean getLocalVarParamName() {
        return this.localVarParamName;
    }

    @Config
    @Mapping(value={"local-var-param-name"})
    public void setLocalVarParamName(ConfigurationValue cv, boolean b) {
        this.localVarParamName = b;
    }

    public boolean getLocalVarShadowsField() {
        return this.localVarShadowsField;
    }

    @Config
    @Mapping(value={"local-var-shadows-field"})
    public void setLocalVarShadowsField(ConfigurationValue cv, boolean b) {
        this.localVarShadowsField = b;
    }

    public int getMaxBlockDepth() {
        return this.maxBlockDepth;
    }

    @Config
    @Mapping(value={"max-block-depth"})
    public void setMaxBlockDepth(ConfigurationValue cv, int i) {
        this.maxBlockDepth = i;
    }

    public int getMaxParams() {
        return this.maxParams;
    }

    @Config
    @Mapping(value={"max-params"})
    public void setMaxParams(ConfigurationValue cv, int i) {
        this.maxParams = i;
    }

    public boolean getMissingAsdoc() {
        return this.missingAsdoc;
    }

    @Config
    @Mapping(value={"missing-asdoc"})
    public void setMissingAsdoc(ConfigurationValue cv, boolean b) {
        this.missingAsdoc = b;
    }

    public boolean getMissingConstructorSuper() {
        return this.missingConstructorSuper;
    }

    @Config
    @Mapping(value={"missing-constructor-super"})
    public void setMissingConstructorSuper(ConfigurationValue cv, boolean b) {
        this.missingConstructorSuper = b;
    }

    public boolean getMissingNamespace() {
        return this.missingNamespace;
    }

    @Config
    @Mapping(value={"missing-namespace"})
    public void setMissingNamespace(ConfigurationValue cv, boolean b) {
        this.missingNamespace = b;
    }

    public boolean getMissingSemicolon() {
        return this.missingSemicolon;
    }

    @Config
    @Mapping(value={"missing-semicolon"})
    public void setMissingSemicolon(ConfigurationValue cv, boolean b) {
        this.missingSemicolon = b;
    }

    public boolean getMissingType() {
        return this.missingType;
    }

    @Config
    @Mapping(value={"missing-type"})
    public void setMissingType(ConfigurationValue cv, boolean b) {
        this.missingType = b;
    }

    public boolean getMxmlEmptyAttr() {
        return this.mxmlEmptyAttr;
    }

    @Config
    @Mapping(value={"mxml-empty-attr"})
    public void setMxmlEmptyAttr(ConfigurationValue cv, boolean b) {
        this.mxmlEmptyAttr = b;
    }

    public boolean getMxmlId() {
        return this.mxmlId;
    }

    @Config
    @Mapping(value={"mxml-id"})
    public void setMxmlId(ConfigurationValue cv, boolean b) {
        this.mxmlId = b;
    }

    public boolean getNoAnyType() {
        return this.noAnyType;
    }

    @Config
    @Mapping(value={"no-any-type"})
    public void setNoAnyType(ConfigurationValue cv, boolean b) {
        this.noAnyType = b;
    }

    public boolean getNoBooleanEquality() {
        return this.noBooleanEquality;
    }

    @Config
    @Mapping(value={"no-boolean-equality"})
    public void setNoBooleanEquality(ConfigurationValue cv, boolean b) {
        this.noBooleanEquality = b;
    }

    public boolean getNoConstructorDispatch() {
        return this.noConstructorDispatch;
    }

    @Config
    @Mapping(value={"no-constructor-dispatch"})
    public void setNoConstructorDispatch(ConfigurationValue cv, boolean b) {
        this.noConstructorDispatch = b;
    }

    public boolean getNoConstructorReturnType() {
        return this.noConstructorReturnType;
    }

    @Config
    @Mapping(value={"no-constructor-return-type"})
    public void setNoConstructorReturnType(ConfigurationValue cv, boolean b) {
        this.noConstructorReturnType = b;
    }

    public boolean getNoDuplicateKeys() {
        return this.noDuplicateKeys;
    }

    @Config
    @Mapping(value={"no-duplicate-keys"})
    public void setNoDuplicateKeys(ConfigurationValue cv, boolean b) {
        this.noDuplicateKeys = b;
    }

    public boolean getNoDynamicClass() {
        return this.noDynamicClass;
    }

    @Config
    @Mapping(value={"no-dynamic-class"})
    public void setNoDynamicClass(ConfigurationValue cv, boolean b) {
        this.noDynamicClass = b;
    }

    public boolean getNoIfBoolean() {
        return this.noIfBoolean;
    }

    @Config
    @Mapping(value={"no-if-boolean"})
    public void setNoIfBoolean(ConfigurationValue cv, boolean b) {
        this.noIfBoolean = b;
    }

    public boolean getNoLeadingZero() {
        return this.noLeadingZero;
    }

    @Config
    @Mapping(value={"no-leading-zero"})
    public void setNoLeadingZero(ConfigurationValue cv, boolean b) {
        this.noLeadingZero = b;
    }

    public boolean getNoSparseArray() {
        return this.noSparseArray;
    }

    @Config
    @Mapping(value={"no-sparse-array"})
    public void setNoSparseArray(ConfigurationValue cv, boolean b) {
        this.noSparseArray = b;
    }

    public boolean getNoStringEvent() {
        return this.noStringEvent;
    }

    @Config
    @Mapping(value={"no-string-event"})
    public void setNoStringEvent(ConfigurationValue cv, boolean b) {
        this.noStringEvent = b;
    }

    public boolean getNoThisClosure() {
        return this.noThisClosure;
    }

    @Config
    @Mapping(value={"no-this-closure"})
    public void setNoThisClosure(ConfigurationValue cv, boolean b) {
        this.noThisClosure = b;
    }

    public boolean getNoTrace() {
        return this.noTrace;
    }

    @Config
    @Mapping(value={"no-trace"})
    public void setNoTrace(ConfigurationValue cv, boolean b) {
        this.noTrace = b;
    }

    public boolean getNoVoidOperator() {
        return this.noVoidOperator;
    }

    @Config
    @Mapping(value={"no-void-operator"})
    public void setNoVoidOperator(ConfigurationValue cv, boolean b) {
        this.noVoidOperator = b;
    }

    public boolean getNoWildcardImport() {
        return this.noWildcardImport;
    }

    @Config
    @Mapping(value={"no-wildcard-import"})
    public void setNoWildcardImport(ConfigurationValue cv, boolean b) {
        this.noWildcardImport = b;
    }

    public boolean getNoWith() {
        return this.noWith;
    }

    @Config
    @Mapping(value={"no-with"})
    public void setNoWith(ConfigurationValue cv, boolean b) {
        this.noWith = b;
    }

    public boolean getOverrideSuper() {
        return this.overrideSuper;
    }

    @Config
    @Mapping(value={"override-super"})
    public void setOverrideSuper(ConfigurationValue cv, boolean b) {
        this.overrideSuper = b;
    }

    public boolean getPackageName() {
        return this.packageName;
    }

    @Config
    @Mapping(value={"package-name"})
    public void setPackageName(ConfigurationValue cv, boolean b) {
        this.packageName = b;
    }

    public boolean getStaticConstants() {
        return this.staticConstants;
    }

    @Config
    @Mapping(value={"static-constants"})
    public void setStaticConstants(ConfigurationValue cv, boolean b) {
        this.staticConstants = b;
    }

    public boolean getStrictEquality() {
        return this.strictEquality;
    }

    @Config
    @Mapping(value={"strict-equality"})
    public void setStrictEquality(ConfigurationValue cv, boolean b) {
        this.strictEquality = b;
    }

    public boolean getSwitchDefault() {
        return this.switchDefault;
    }

    @Config
    @Mapping(value={"switch-default"})
    public void setSwitchDefault(ConfigurationValue cv, boolean b) {
        this.switchDefault = b;
    }

    public boolean getUnsafeNegation() {
        return this.unsafeNegation;
    }

    @Config
    @Mapping(value={"unsafe-negation"})
    public void setUnsafeNegation(ConfigurationValue cv, boolean b) {
        this.unsafeNegation = b;
    }

    public boolean getValidTypeof() {
        return this.validTypeof;
    }

    @Config
    @Mapping(value={"valid-typeof"})
    public void setValidTypeof(ConfigurationValue cv, boolean b) {
        this.validTypeof = b;
    }

    public boolean getVarsOnTop() {
        return this.varsOnTop;
    }

    @Config
    @Mapping(value={"vars-on-top"})
    public void setVarsOnTop(ConfigurationValue cv, boolean b) {
        this.varsOnTop = b;
    }

    protected String resolvePathStrict(String path, ConfigurationValue cv) throws ConfigurationException.CannotOpen {
        return this.resolvePathStrict(path, cv, false);
    }

    private String resolvePathStrict(String path, ConfigurationValue cv, boolean returnMissingFiles) throws ConfigurationException.CannotOpen {
        ImmutableList singletonPath = ImmutableList.of((Object)path);
        ImmutableList<String> results = this.resolvePathsStrict((ImmutableList<String>)singletonPath, cv, returnMissingFiles);
        return (String)results.get(0);
    }

    private ImmutableList<String> resolvePathsStrict(ImmutableList<String> paths, ConfigurationValue cv) throws ConfigurationException.CannotOpen {
        return this.resolvePathsStrict(paths, cv, false);
    }

    private ImmutableList<String> resolvePathsStrict(ImmutableList<String> paths, ConfigurationValue cv, boolean returnMissingFiles) throws ConfigurationException.CannotOpen {
        assert (paths != null) : "Expected paths";
        assert (cv != null) : "Require ConfigurationValue as context.";
        ImmutableList.Builder resolvedPathsBuilder = new ImmutableList.Builder();
        for (String processedPath : paths) {
            int c;
            boolean isAbsolute;
            if (cv.getContext() != null && !(isAbsolute = new File(processedPath).isAbsolute())) {
                processedPath = new File(cv.getContext(), processedPath).getAbsolutePath();
            }
            if (processedPath.contains("*") && (c = processedPath.lastIndexOf(File.separator, processedPath.indexOf("*"))) != -1) {
                processedPath = processedPath.substring(0, c);
            }
            if (!processedPath.contains(".swc:")) {
                File fileSpec = this.pathResolver.resolve(processedPath);
                if (!returnMissingFiles && !fileSpec.exists()) {
                    throw new ConfigurationException.CannotOpen(FilenameNormalization.normalize((String)processedPath), cv.getVar(), cv.getSource(), cv.getLine());
                }
                resolvedPathsBuilder.add((Object)fileSpec.getAbsolutePath());
                continue;
            }
            resolvedPathsBuilder.add((Object)processedPath);
        }
        return resolvedPathsBuilder.build();
    }
}

