/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flex.tools.FlexTool;
import org.apache.royale.compiler.Messages;
import org.apache.royale.compiler.clients.MXMLC;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.projects.RoyaleProjectConfigurator;
import org.apache.royale.compiler.internal.targets.SWFTarget;
import org.apache.royale.compiler.internal.watcher.WatchThread;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MissingRequirementConfigurationProblem;
import org.apache.royale.compiler.targets.ISWCTarget;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.io.SWCDirectoryWriter;
import org.apache.royale.swc.io.SWCWriter;
import org.apache.royale.swf.io.SizeReportWritingSWFWriter;
import org.apache.royale.utils.FilenameNormalization;

public class COMPC
extends MXMLC
implements FlexTool {
    private String swcOutputMessage;

    public static void main(String[] args) {
        int exitCode = COMPC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        COMPC compc = new COMPC();
        return compc.mainNoExit(args);
    }

    @Override
    public String getName() {
        return "COMPC";
    }

    @Override
    public int execute(String[] args) {
        return this.mainNoExit(args);
    }

    @Override
    public boolean configure(String[] args) {
        return super.configure(args);
    }

    @Override
    protected String getConfigurationDefaultVariable() {
        return "include-classes";
    }

    @Override
    protected Configurator createConfigurator() {
        return new RoyaleProjectConfigurator(this.configurationClass);
    }

    @Override
    protected String getProgramName() {
        return "compc";
    }

    @Override
    protected String getStartMessage() {
        String message = "Apache Royale SWC Component Compiler (compc)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE;
        return message;
    }

    @Override
    protected void setupWatcher() {
        if (!this.config.getWatch()) {
            return;
        }
        WatchThread.IWatchWriter writer = new WatchThread.IWatchWriter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rebuild(Collection<ICompilationUnit> units, Collection<ICompilerProblem> problems) throws InterruptedException, IOException {
                COMPC.this.startTime = System.nanoTime();
                COMPC.this.workspace.startBuilding();
                try {
                    if (!COMPC.this.setupTargetFile()) {
                        throw new IOException("Failed to setup target file.");
                    }
                    COMPC.this.buildArtifact();
                    for (ICompilationUnit unit : units) {
                        unit.waitForBuildFinish(problems, null);
                    }
                }
                finally {
                    COMPC.this.workspace.doneBuilding();
                }
            }

            @Override
            public void write(Collection<ICompilationUnit> units) throws InterruptedException, IOException {
                COMPC.this.reportTargetCompletion();
            }
        };
        WatchThread watcherThread = new WatchThread("SWF", writer, this.config, this.project, this.workspace, this.problems);
        watcherThread.start();
    }

    @Override
    protected void buildArtifact() throws InterruptedException, IOException {
        String outputOptionValue = this.config.getOutput();
        if (outputOptionValue == null || outputOptionValue.length() == 0) {
            MissingRequirementConfigurationProblem problem = new MissingRequirementConfigurationProblem("output");
            this.problems.add(problem);
            return;
        }
        ITargetSettings targetSettings = this.projectConfigurator.getTargetSettings(ITarget.TargetType.SWC);
        if (targetSettings == null) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("target settings is null");
            }
            return;
        }
        ISWCTarget swcTarget = this.project.createSWCTarget(targetSettings, null);
        this.target = (SWFTarget)swcTarget.getLibrarySWFTarget();
        ArrayList<ICompilerProblem> swcProblems = new ArrayList<ICompilerProblem>();
        if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
            System.out.println("attempting to build SWC");
        }
        ISWC swc = swcTarget.build(swcProblems);
        this.problems.addAll(swcProblems);
        if (!this.config.getCreateTargetWithErrors() && this.problems.hasErrors()) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("got errors creating target in compc");
            }
            return;
        }
        boolean useCompression = targetSettings.useCompression();
        if (this.config.getOutputSwcAsDirectory()) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("output swc as directory");
            }
            String path = FilenameNormalization.normalize(outputOptionValue);
            SWCDirectoryWriter swcWriter = new SWCDirectoryWriter(path, useCompression, targetSettings.isDebugEnabled(), targetSettings.isTelemetryEnabled(), SizeReportWritingSWFWriter.getSWFWriterFactory(targetSettings.getSizeReport()));
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("attempting to write swc");
            }
            swcWriter.write(swc);
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("returned from writing swc");
            }
            long endTime = System.nanoTime();
            String seconds = String.format("%5.3f", (double)(endTime - this.startTime) / 1.0E9);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("path", path);
            params.put("seconds", seconds);
            this.swcOutputMessage = Messages.getString("COMPC.swc_written_open_directory_in_seconds_format", params);
        } else {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("output swc as file");
            }
            SWCWriter swcWriter = new SWCWriter(outputOptionValue, useCompression, targetSettings.isDebugEnabled(), targetSettings.isTelemetryEnabled(), targetSettings.getSWFMetadataDate(), targetSettings.getSWFMetadataDateFormat(), SizeReportWritingSWFWriter.getSWFWriterFactory(targetSettings.getSizeReport()));
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("attempting to write swc");
            }
            swcWriter.write(swc);
            if ((CompilerDiagnosticsConstants.diagnostics & 0x4000) == 16384) {
                System.out.println("returned from writing swc");
            }
            File outputFile = new File(outputOptionValue);
            long endTime = System.nanoTime();
            String seconds = String.format("%5.3f", (double)(endTime - this.startTime) / 1.0E9);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("byteCount", outputFile.length());
            params.put("path", outputFile.getCanonicalPath());
            params.put("seconds", seconds);
            this.swcOutputMessage = Messages.getString("MXMLC.bytes_written_to_file_in_seconds_format", params);
        }
    }

    @Override
    protected void reportTargetCompletion() {
        if (this.swcOutputMessage != null) {
            this.println(this.swcOutputMessage);
        }
    }

    @Override
    protected boolean setupTargetFile() throws InterruptedException {
        return true;
    }

    @Override
    protected void validateTargetFile() throws ConfigurationException {
    }

    @Override
    protected boolean isCompc() {
        return true;
    }

    @Override
    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }
}

