/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.rhea.metadata.Peer;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.Requires;
import java.util.ArrayList;
import java.util.List;

public final class JRaftHelper {
    public static String getJRaftGroupId(String clusterName, long regionId) {
        Requires.requireNonNull((Object)clusterName, (String)"clusterName");
        return clusterName + "-" + regionId;
    }

    public static PeerId toJRaftPeerId(Peer peer) {
        Requires.requireNonNull((Object)peer, (String)"peer");
        Endpoint endpoint = peer.getEndpoint();
        Requires.requireNonNull((Object)endpoint, (String)"peer.endpoint");
        return new PeerId(endpoint, 0);
    }

    public static List<PeerId> toJRaftPeerIdList(List<Peer> peerList) {
        if (peerList == null) {
            return null;
        }
        ArrayList<PeerId> peerIdList = Lists.newArrayListWithCapacity(peerList.size());
        for (Peer peer : peerList) {
            peerIdList.add(JRaftHelper.toJRaftPeerId(peer));
        }
        return peerIdList;
    }

    public static Peer toPeer(PeerId peerId) {
        Requires.requireNonNull((Object)peerId, (String)"peerId");
        Endpoint endpoint = peerId.getEndpoint();
        Requires.requireNonNull((Object)endpoint, (String)"peerId.endpoint");
        Peer peer = new Peer();
        peer.setId(-1L);
        peer.setStoreId(-1L);
        peer.setEndpoint(endpoint.copy());
        return peer;
    }

    public static List<Peer> toPeerList(List<PeerId> peerIdList) {
        if (peerIdList == null) {
            return null;
        }
        ArrayList<Peer> peerList = Lists.newArrayListWithCapacity(peerIdList.size());
        for (PeerId peerId : peerIdList) {
            peerList.add(JRaftHelper.toPeer(peerId));
        }
        return peerList;
    }
}

