/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.activity;

import com.alibaba.fastjson2.JSONWriter;
import com.google.common.net.HostAndPort;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.proxy.common.Address;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.remoting.activity.AbstractRemotingActivity;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.proxy.service.route.ProxyTopicRouteData;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.namesrv.GetRouteInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class GetTopicRouteActivity
extends AbstractRemotingActivity {
    public GetTopicRouteActivity(RequestPipeline requestPipeline, MessagingProcessor messagingProcessor) {
        super(requestPipeline, messagingProcessor);
    }

    @Override
    protected RemotingCommand processRequest0(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetRouteInfoRequestHeader requestHeader = (GetRouteInfoRequestHeader)request.decodeCommandCustomHeader(GetRouteInfoRequestHeader.class);
        ArrayList<Address> addressList = new ArrayList<Address>();
        addressList.add(new Address(HostAndPort.fromParts((String)proxyConfig.getRemotingAccessAddr(), (int)proxyConfig.getRemotingListenPort())));
        ProxyTopicRouteData proxyTopicRouteData = this.messagingProcessor.getTopicRouteDataForProxy(context, addressList, requestHeader.getTopic());
        TopicRouteData topicRouteData = proxyTopicRouteData.buildTopicRouteData();
        Boolean standardJsonOnly = requestHeader.getAcceptStandardJsonOnly();
        byte[] content = request.getVersion() >= MQVersion.Version.V4_9_4.ordinal() || null != standardJsonOnly && standardJsonOnly != false ? topicRouteData.encode(new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible, JSONWriter.Feature.MapSortField}) : topicRouteData.encode();
        response.setBody(content);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }
}

